/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public class GOperator
extends UnaryModalOperator {
    public GOperator(Formula f) {
        super(f);
    }

    public static Formula of(Formula operand) {
        if (operand instanceof BooleanConstant) {
            return operand;
        }
        if (operand instanceof Conjunction) {
            return Conjunction.of(((Conjunction)operand).map(GOperator::of));
        }
        if (operand instanceof Biconditional) {
            Biconditional biconditional = (Biconditional)operand;
            return Conjunction.of(GOperator.of(Disjunction.of(biconditional.left.not(), biconditional.right)), GOperator.of(Disjunction.of(biconditional.left, biconditional.right.not())));
        }
        if (operand instanceof GOperator) {
            return operand;
        }
        if (operand instanceof MOperator) {
            MOperator mOperator = (MOperator)operand;
            return Conjunction.of(GOperator.of(mOperator.right), GOperator.of(FOperator.of(mOperator.left)));
        }
        if (operand instanceof ROperator) {
            return GOperator.of(((ROperator)operand).right);
        }
        if (operand instanceof WOperator) {
            WOperator wOperator = (WOperator)operand;
            return GOperator.of(Disjunction.of(wOperator.left, wOperator.right));
        }
        return new GOperator(operand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String getOperator() {
        return "G";
    }

    @Override
    public boolean isPureEventual() {
        return this.operand.isPureEventual();
    }

    @Override
    public boolean isPureUniversal() {
        return true;
    }

    @Override
    public boolean isSuspendable() {
        return this.operand.isPureEventual() || this.operand.isSuspendable();
    }

    @Override
    public Formula nnf() {
        return GOperator.of(this.operand.nnf());
    }

    @Override
    public Formula not() {
        return FOperator.of(this.operand.not());
    }

    @Override
    public Formula unfold() {
        return Conjunction.of(this.operand.unfold(), (Formula)this);
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Conjunction.of(this.operand.unfoldTemporalStep(valuation), (Formula)this);
    }
}

