/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import owl.ltl.AbstractFormula;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;

public abstract class PropositionalFormula
extends AbstractFormula {
    public final Set<Formula> children;

    PropositionalFormula(Collection<? extends Formula> children) {
        this.children = Set.copyOf(children);
    }

    public static Formula shortCircuit(Formula formula) {
        if (formula instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)formula;
            if (conjunction.children.stream().anyMatch((? super T x) -> conjunction.children.contains(x.not()))) {
                return BooleanConstant.FALSE;
            }
        }
        if (formula instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)formula;
            if (disjunction.children.stream().anyMatch((? super T x) -> disjunction.children.contains(x.not()))) {
                return BooleanConstant.TRUE;
            }
        }
        return formula;
    }

    @Override
    public boolean allMatch(Predicate<Formula> p) {
        return p.test(this) && this.allMatchChildren(p);
    }

    private boolean allMatchChildren(Predicate<Formula> p) {
        for (Formula child : this.children) {
            if (child.allMatch(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean anyMatch(Predicate<Formula> p) {
        return p.test(this) || this.anyMatchChildren(p);
    }

    private boolean anyMatchChildren(Predicate<Formula> p) {
        for (Formula child : this.children) {
            if (!child.anyMatch(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals2(AbstractFormula o) {
        PropositionalFormula that = (PropositionalFormula)o;
        return Objects.equals(this.children, that.children);
    }

    public void forEach(Consumer<Formula> consumer) {
        this.children.forEach(consumer);
    }

    protected abstract char getOperator();

    @Override
    public boolean isPureEventual() {
        return this.children.stream().allMatch(Formula::isPureEventual);
    }

    @Override
    public boolean isPureUniversal() {
        return this.children.stream().allMatch(Formula::isPureUniversal);
    }

    @Override
    public boolean isSuspendable() {
        return this.children.stream().allMatch(Formula::isSuspendable);
    }

    public <T> Stream<T> map(Function<Formula, T> mapper) {
        return this.children.stream().map(mapper);
    }

    public String toString() {
        String delimiter = String.valueOf(this.getOperator());
        return "(" + String.join((CharSequence)delimiter, Iterables.transform(this.children, Object::toString)) + ")";
    }
}

