/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import owl.grammar.TLSFLexer;
import owl.grammar.TLSFParser;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.parser.LtlParser;
import owl.ltl.tlsf.ImmutableTlsf;
import owl.ltl.tlsf.Tlsf;

public final class TlsfParser {
    private TlsfParser() {
    }

    public static Tlsf parse(String input) {
        return TlsfParser.parse((CharStream)CharStreams.fromString((String)input));
    }

    private static Tlsf parse(CharStream stream) {
        TLSFLexer lexer = new TLSFLexer(stream);
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        TLSFParser parser = new TLSFParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        TLSFParser.TlsfContext tree = parser.tlsf();
        ImmutableTlsf.Builder builder = ImmutableTlsf.builder();
        builder.title(tree.title.getText());
        builder.description(tree.description.getText());
        TLSFParser.SemanticsContext semantics = tree.semantics();
        if (semantics.MEALY() != null) {
            builder.semantics(Tlsf.Semantics.MEALY);
        } else if (semantics.MOORE() != null) {
            builder.semantics(Tlsf.Semantics.MOORE);
        } else if (semantics.MEALY_STRICT() != null) {
            builder.semantics(Tlsf.Semantics.MEALY_STRICT);
        } else if (semantics.MOORE_STRICT() != null) {
            builder.semantics(Tlsf.Semantics.MOORE_STRICT);
        } else {
            throw new ParseCancellationException("Unknown semantics");
        }
        TLSFParser.TargetContext target = tree.target();
        if (target.MEALY() != null) {
            builder.target(Tlsf.Semantics.MEALY);
        } else if (target.MOORE() != null) {
            builder.target(Tlsf.Semantics.MOORE);
        } else {
            throw new ParseCancellationException("Unknown semantics");
        }
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<String> lowercaseVariables = new ArrayList<String>();
        BitSet inputs = new BitSet();
        for (TerminalNode terminalNode : tree.input().VAR_ID()) {
            String variableName = terminalNode.getText();
            if (lowercaseVariables.contains(variableName.toLowerCase())) {
                throw new ParseCancellationException("Duplicate variable definition: " + variableName);
            }
            inputs.set(variables.size());
            variables.add(variableName);
            lowercaseVariables.add(variableName.toLowerCase());
        }
        BitSet outputs = new BitSet();
        for (TerminalNode variableNode : tree.output().VAR_ID()) {
            String variableName = variableNode.getText();
            if (lowercaseVariables.contains(variableName.toLowerCase())) {
                throw new ParseCancellationException("Duplicate variable definition: " + variableName);
            }
            outputs.set(variables.size());
            variables.add(variableName);
            lowercaseVariables.add(variableName.toLowerCase());
        }
        builder.inputs(inputs);
        builder.outputs(outputs);
        builder.variables(List.copyOf(variables));
        ArrayList<Formula> arrayList = new ArrayList<Formula>();
        ArrayList<Formula> preset = new ArrayList<Formula>();
        ArrayList<Formula> require = new ArrayList<Formula>();
        ArrayList<Formula> assert_ = new ArrayList<Formula>();
        ArrayList<Formula> assume = new ArrayList<Formula>();
        ArrayList<Formula> guarantee = new ArrayList<Formula>();
        for (TLSFParser.SpecificationContext specificationContext : tree.specification()) {
            int children = specificationContext.children.size();
            for (ParseTree child : specificationContext.children.subList(2, children - 1)) {
                String formulaString = child.getText();
                assert (!formulaString.isEmpty());
                String sanitizedFormula = formulaString.substring(0, formulaString.length() - 1).trim();
                for (int i = 0; i < variables.size(); ++i) {
                    String variableName = (String)variables.get(i);
                    for (int j = 0; j < i; ++j) {
                        variableName = variableName.replace((CharSequence)variables.get(j), (CharSequence)lowercaseVariables.get(j));
                    }
                    sanitizedFormula = sanitizedFormula.replace(variableName, (CharSequence)lowercaseVariables.get(i));
                }
                Formula formula = LtlParser.syntax(sanitizedFormula, lowercaseVariables);
                if (specificationContext.INITIALLY() != null) {
                    arrayList.add(formula);
                    continue;
                }
                if (specificationContext.PRESET() != null) {
                    preset.add(formula);
                    continue;
                }
                if (specificationContext.REQUIRE() != null) {
                    require.add(formula);
                    continue;
                }
                if (specificationContext.ASSERT() != null) {
                    assert_.add(formula);
                    continue;
                }
                if (specificationContext.ASSUME() != null) {
                    assume.add(formula);
                    continue;
                }
                if (specificationContext.GUARANTEE() != null) {
                    guarantee.add(formula);
                    continue;
                }
                throw new ParseCancellationException("Unknown specification type");
            }
        }
        builder.initially(Conjunction.of(arrayList));
        builder.preset(Conjunction.of(preset));
        builder.require(Conjunction.of(require));
        builder.assume(Conjunction.of(assume));
        builder.assert_(List.copyOf(assert_));
        builder.guarantee(List.copyOf(guarantee));
        return builder.build();
    }

    public static Tlsf parse(InputStream input, Charset charset) throws IOException {
        return TlsfParser.parse(CharStreams.fromStream((InputStream)input, (Charset)charset));
    }

    public static Tlsf parse(Reader input) throws IOException {
        return TlsfParser.parse((CharStream)CharStreams.fromReader((Reader)input));
    }
}

