/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import owl.ltl.Biconditional;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

public class PullUpXVisitor
implements Visitor<XFormula>,
UnaryOperator<Formula> {
    public static final PullUpXVisitor INSTANCE = new PullUpXVisitor();

    @Override
    public Formula apply(Formula formula) {
        return formula.accept(this).toFormula();
    }

    @Override
    public XFormula visit(Biconditional biconditional) {
        XFormula right = biconditional.right.accept(this);
        XFormula left = biconditional.left.accept(this);
        left.formula = Biconditional.of(left.toFormula(right.depth), right.toFormula(left.depth));
        left.depth = Math.min(left.depth, right.depth);
        return left;
    }

    @Override
    public XFormula visit(BooleanConstant booleanConstant) {
        return new XFormula(0, booleanConstant);
    }

    @Override
    public XFormula visit(Conjunction conjunction) {
        List children = conjunction.map(c -> c.accept(this)).collect(Collectors.toList());
        int depth = children.stream().mapToInt(c -> c.depth).min().orElse(0);
        return new XFormula(depth, Conjunction.of(children.stream().map(c -> c.toFormula(depth))));
    }

    @Override
    public XFormula visit(Disjunction disjunction) {
        List children = disjunction.map(c -> c.accept(this)).collect(Collectors.toList());
        int depth = children.stream().mapToInt(c -> c.depth).min().orElse(0);
        return new XFormula(depth, Disjunction.of(children.stream().map(c -> c.toFormula(depth))));
    }

    @Override
    public XFormula visit(FOperator fOperator) {
        return this.visit(fOperator, FOperator::of);
    }

    @Override
    public XFormula visit(GOperator gOperator) {
        return this.visit(gOperator, GOperator::of);
    }

    @Override
    public XFormula visit(Literal literal) {
        return new XFormula(0, literal);
    }

    @Override
    public XFormula visit(MOperator mOperator) {
        return this.visit(mOperator, MOperator::of);
    }

    @Override
    public XFormula visit(ROperator rOperator) {
        return this.visit(rOperator, ROperator::of);
    }

    @Override
    public XFormula visit(UOperator uOperator) {
        return this.visit(uOperator, UOperator::of);
    }

    @Override
    public XFormula visit(WOperator wOperator) {
        return this.visit(wOperator, WOperator::of);
    }

    @Override
    public XFormula visit(XOperator xOperator) {
        XFormula r = xOperator.operand.accept(this);
        ++r.depth;
        return r;
    }

    private XFormula visit(BinaryModalOperator operator, BiFunction<Formula, Formula, Formula> constructor) {
        XFormula right = operator.right.accept(this);
        XFormula left = operator.left.accept(this);
        left.formula = constructor.apply(left.toFormula(right.depth), right.toFormula(left.depth));
        left.depth = Math.min(left.depth, right.depth);
        return left;
    }

    private XFormula visit(UnaryModalOperator operator, Function<Formula, Formula> constructor) {
        XFormula formula = operator.operand.accept(this);
        formula.formula = constructor.apply(formula.formula);
        return formula;
    }

    public static final class XFormula {
        int depth;
        Formula formula;

        XFormula(int depth, Formula formula) {
            this.depth = depth;
            this.formula = formula;
        }

        Formula toFormula(int newDepth) {
            Formula formula = this.formula;
            for (int i = this.depth - newDepth; i > 0; --i) {
                formula = XOperator.of(formula);
            }
            return formula;
        }

        Formula toFormula() {
            return this.toFormula(0);
        }

        public Formula rawFormula() {
            return this.formula;
        }

        public int depth() {
            return this.depth;
        }
    }
}

