/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.robust;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import owl.collections.Collections3;
import owl.grammar.LTLParser;
import owl.grammar.LTLParserBaseVisitor;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.XOperator;
import owl.ltl.robust.Split;

class RobustLtlVisitor
extends LTLParserBaseVisitor<Split> {
    private final List<Split> literalCache = new ArrayList<Split>();
    private final List<String> variables = new ArrayList<String>();

    RobustLtlVisitor() {
    }

    public List<String> variables() {
        return List.copyOf(this.variables);
    }

    @Override
    public Split visitExpression(LTLParser.ExpressionContext ctx) {
        assert (ctx.getChildCount() == 1);
        return (Split)this.visit(ctx.getChild(0));
    }

    @Override
    public Split visitFormula(LTLParser.FormulaContext ctx) {
        assert (ctx.getChildCount() == 2) : ctx.getChildCount();
        return (Split)this.visit(ctx.getChild(0));
    }

    @Override
    public Split visitNested(LTLParser.NestedContext ctx) {
        assert (ctx.getChildCount() == 3);
        return (Split)this.visit((ParseTree)ctx.nested);
    }

    @Override
    public Split visitBoolean(LTLParser.BooleanContext ctx) {
        assert (ctx.getChildCount() == 1);
        LTLParser.BoolContext constant = ctx.bool();
        if (constant.FALSE() != null) {
            return Split.FALSE;
        }
        if (constant.TRUE() != null) {
            return Split.TRUE;
        }
        throw new ParseCancellationException("Unknown constant");
    }

    @Override
    public Split visitVariable(LTLParser.VariableContext ctx) {
        assert (ctx.getChildCount() == 1);
        assert (this.variables.size() == this.literalCache.size());
        String name = ctx.getText();
        int index = this.variables.indexOf(name);
        if (index == -1) {
            int newIndex = this.variables.size();
            Literal literal = new Literal(newIndex);
            this.variables.add(name);
            Split literalSplit = Split.of(literal, true);
            this.literalCache.add(literalSplit);
            return literalSplit;
        }
        return this.literalCache.get(index);
    }

    @Override
    public Split visitAndExpression(LTLParser.AndExpressionContext ctx) {
        assert (ctx.getChildCount() > 0);
        return ctx.children.stream().filter(child -> !(child instanceof TerminalNode)).map(arg_0 -> ((RobustLtlVisitor)this).visit(arg_0)).reduce(Split.TRUE, Split.combiner(Conjunction::of));
    }

    @Override
    public Split visitOrExpression(LTLParser.OrExpressionContext ctx) {
        assert (ctx.getChildCount() > 0);
        return ctx.children.stream().filter(child -> !(child instanceof TerminalNode)).map(arg_0 -> ((RobustLtlVisitor)this).visit(arg_0)).reduce(Split.FALSE, Split.combiner(Disjunction::of));
    }

    @Override
    public Split visitUnaryOperation(LTLParser.UnaryOperationContext ctx) {
        assert (ctx.getChildCount() == 2);
        LTLParser.UnaryOpContext unaryOp = ctx.unaryOp();
        Split operand = (Split)this.visit((ParseTree)ctx.inner);
        if (unaryOp.NOT() != null) {
            return operand.grFree() ? operand.map(Formula::not) : Split.of(Conjunction.of(operand.all()).not(), operand.grFree());
        }
        if (unaryOp.FINALLY() != null) {
            return operand.map(FOperator::of);
        }
        if (unaryOp.GLOBALLY() != null) {
            return Split.of(GOperator.of(operand.always()), FOperator.of(GOperator.of(operand.eventuallyAlways())), GOperator.of(FOperator.of(operand.infinitelyOften())), FOperator.of(operand.eventually()), false);
        }
        if (unaryOp.NEXT() != null) {
            return operand.map(XOperator::of);
        }
        throw new ParseCancellationException("Unsupported operator");
    }

    @Override
    public Split visitBinaryOperation(LTLParser.BinaryOperationContext ctx) {
        assert (ctx.getChildCount() == 3);
        assert (ctx.left != null && ctx.right != null);
        LTLParser.BinaryOpContext binaryOp = ctx.binaryOp();
        Split left = (Split)this.visit((ParseTree)ctx.left);
        Split right = (Split)this.visit((ParseTree)ctx.right);
        if (binaryOp.IMP() != null) {
            if (left.grFree() && right.grFree()) {
                return (Split)Split.combiner((l, r) -> Disjunction.of(l.not(), r)).apply(left, right);
            }
            ArrayList conjuncts = new ArrayList(4);
            Collections3.zip(left.all(), right.all(), (l, r) -> conjuncts.add(Conjunction.of(l, r.not())));
            Formula antecedent = Disjunction.of(conjuncts).not();
            return right.map(r -> Disjunction.of(antecedent, r));
        }
        throw new ParseCancellationException("Unsupported operator");
    }
}

