/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import owl.run.PipelineException;

public final class RunUtil {
    private static final Logger logger = Logger.getLogger(RunUtil.class.getName());

    private RunUtil() {
    }

    public static Option getDefaultAnnotationOption() {
        return new Option("a", "annotations", false, "Gather additional labels etc. (where supported)");
    }

    public static boolean checkDefaultAnnotationOption(CommandLine settings) {
        String annotationsEnv = System.getenv("OWL_ANNOTATIONS");
        boolean annotationsFromEnv = !Strings.isNullOrEmpty((String)annotationsEnv) && !"0".equals(annotationsEnv);
        return annotationsFromEnv || settings.hasOption("annotations");
    }

    public static Option getDefaultParallelOption() {
        return new Option("p", "parallel", false, "Enable parallel processing (where supported)");
    }

    public static boolean checkDefaultParallelOption(CommandLine settings) {
        return settings.hasOption("parallel");
    }

    public static AssertionError failWithMessage(String message) {
        System.err.println(message);
        System.exit(1);
        return new AssertionError((Object)"Unreachable");
    }

    public static AssertionError failWithMessage(String message, Throwable cause) {
        System.err.println(message);
        logger.log(Level.FINE, "Stacktrace:", cause);
        System.exit(1);
        return new AssertionError("Unreachable", cause);
    }

    public static void checkForVersion(String[] args) {
        if (Arrays.asList(args).contains("-v") || Arrays.asList(args).contains("--version")) {
            System.out.println("Name: " + RunUtil.class.getPackage().getImplementationTitle());
            System.out.println("Version: " + RunUtil.class.getPackage().getImplementationVersion());
            System.exit(0);
        }
    }

    public static void execute(Callable<Void> runner) {
        try {
            runner.call();
        }
        catch (PipelineException e) {
            logger.log(Level.FINE, "Error during execution", e);
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error during execution", e);
            if (e.getMessage() == null) {
                System.err.printf("An unexpected error of type %s occurred during execution%n", e.getClass().getSimpleName());
            } else {
                System.err.printf("An unexpected error occurred during execution: %s%n", e.getMessage());
            }
            e.printStackTrace(System.err);
        }
    }
}

