/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.automaton.Automaton;
import owl.automaton.AutomatonReader;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.output.HoaPrinter;
import owl.factories.FactorySupplier;
import owl.factories.ValuationSetFactory;
import owl.ltl.LabelledFormula;
import owl.ltl.visitors.PrintVisitor;
import owl.run.Environment;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformers;

public class ExternalTranslator
implements Function<LabelledFormula, Automaton<AutomatonReader.HoaState, OmegaAcceptance>> {
    private static final Logger logger = Logger.getLogger(ExternalTranslator.class.getName());
    private static final Pattern splitPattern = Pattern.compile("\\s+");
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("ltl2aut-ext").description("Runs an external tool for LTL to automaton translation").optionsBuilder(() -> {
        Option toolOption = new Option("t", "tool", true, "The tool invocation");
        toolOption.setRequired(true);
        Option inputType = new Option("i", "input", true, "How to pass the formula to the tool. Available modes are stdin or replace (add %f to the invocation)");
        return new Options().addOption(toolOption).addOption(inputType);
    }).parser(settings -> {
        InputMode inputMode;
        String inputType = settings.getOptionValue("inputType");
        if (inputType == null || "stdin".equals(inputType)) {
            inputMode = InputMode.STDIN;
        } else if ("replace".equals(inputType)) {
            inputMode = InputMode.REPLACE;
        } else {
            throw new ParseException("Unknown input mode " + inputType);
        }
        String toolPath = settings.getOptionValue("tool");
        String[] tool = splitPattern.split(toolPath);
        return environment -> {
            ExternalTranslator translator = new ExternalTranslator(environment, inputMode, tool);
            return Transformers.instanceFromFunction(LabelledFormula.class, translator);
        };
    }).build();
    private final Environment env;
    private final InputMode inputMode;
    private final String[] tool;

    public ExternalTranslator(Environment env, String tool) {
        this(env, InputMode.STDIN, splitPattern.split(tool));
    }

    ExternalTranslator(Environment env, InputMode inputMode, String[] tool) {
        this.env = env;
        this.inputMode = inputMode;
        this.tool = tool;
        if (inputMode == InputMode.REPLACE) {
            Preconditions.checkArgument((boolean)Arrays.stream(tool).anyMatch("%f"::equals));
        }
    }

    @Override
    public Automaton<AutomatonReader.HoaState, OmegaAcceptance> apply(LabelledFormula formula) {
        ProcessBuilder processBuilder;
        String formulaString = PrintVisitor.toString(formula, true);
        if (this.inputMode == InputMode.REPLACE) {
            String[] invocation = (String[])this.tool.clone();
            for (int i = 0; i < invocation.length; ++i) {
                if (!"%f".equals(invocation[i])) continue;
                invocation[i] = formulaString;
            }
            processBuilder = new ProcessBuilder(invocation);
        } else {
            processBuilder = new ProcessBuilder(this.tool);
        }
        Process process = null;
        try {
            Automaton<AutomatonReader.HoaState, OmegaAcceptance> automaton;
            Throwable throwable;
            process = processBuilder.start();
            logger.log(Level.FINER, "Running process {0}", processBuilder.command());
            if (this.inputMode == InputMode.STDIN) {
                throwable = null;
                try (OutputStreamWriter outputStream = new OutputStreamWriter(process.getOutputStream(), Charset.defaultCharset());){
                    logger.log(Level.FINER, "Passing {0} to process", formulaString);
                    outputStream.write(formulaString);
                    ((Writer)outputStream).write(10);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            BufferedInputStream inputStream = new BufferedInputStream(process.getInputStream());
            throwable = null;
            try {
                FactorySupplier factorySupplier = this.env.factorySupplier();
                ValuationSetFactory vsFactory = factorySupplier.getValuationSetFactory(formula.variables());
                Automaton<AutomatonReader.HoaState, OmegaAcceptance> automaton2 = AutomatonReader.readHoa((InputStream)inputStream, vsFactory, OmegaAcceptance.class);
                logger.log(Level.FINEST, () -> String.format("Read automaton for %s:%n%s", formula, HoaPrinter.toString(automaton2)));
                automaton = automaton2;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ExternalTranslator.$closeResource(throwable, inputStream);
                        throw throwable4;
                    }
                }
                catch (IOException | jhoafparser.parser.generated.ParseException e) {
                    throw new IllegalStateException("Failed to use external translator.", e);
                }
            }
            ExternalTranslator.$closeResource(throwable, inputStream);
            return automaton;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
                try {
                    process.waitFor(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
                process.destroyForcibly();
            }
        }
    }

    static enum InputMode {
        STDIN,
        REPLACE;

    }
}

