/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.PropositionalVisitor;
import owl.translations.delag.DependencyTree;
import owl.translations.delag.ProductState;

class DependencyTreeFactory<T>
extends PropositionalVisitor<DependencyTree<T>> {
    private final ProductState.Builder<T> builder;
    private final Function<Formula, ? extends Automaton<T, ?>> constructor;
    private final EquivalenceClassFactory factory;
    private final Map<Formula, Automaton<T, ?>> automatonCache = new HashMap();
    int setNumber;

    DependencyTreeFactory(Factories factory, Function<LabelledFormula, ? extends Automaton<T, ?>> constructor) {
        this.factory = factory.eqFactory;
        this.setNumber = 0;
        this.builder = ProductState.builder();
        this.constructor = formula -> this.automatonCache.computeIfAbsent((Formula)formula, x -> (Automaton)constructor.apply(LabelledFormula.of(x, this.factory.variables())));
    }

    ProductState<T> buildInitialState() {
        return this.builder.build();
    }

    @Override
    protected DependencyTree<T> modalOperatorAction(Formula formula) {
        return this.defaultAction(formula, null);
    }

    private DependencyTree<T> defaultAction(Formula formula, @Nullable AtomAcceptance piggyback) {
        DependencyTree.Leaf leaf = DependencyTree.createLeaf(formula, this.setNumber, () -> this.constructor.apply(formula), piggyback);
        if (leaf.type == DependencyTree.Type.CO_SAFETY || leaf.type == DependencyTree.Type.SAFETY) {
            this.builder.addSafety(formula, this.factory.of(formula.unfold()));
        }
        if (leaf instanceof DependencyTree.FallbackLeaf) {
            assert (piggyback == null);
            DependencyTree.FallbackLeaf fallbackLeaf = (DependencyTree.FallbackLeaf)leaf;
            this.setNumber += ((OmegaAcceptance)fallbackLeaf.automaton.acceptance()).acceptanceSets();
            Object initialState = Iterables.getOnlyElement(fallbackLeaf.automaton.initialStates(), null);
            if (initialState == null) {
                this.builder.addFinished(fallbackLeaf, Boolean.FALSE);
            } else {
                this.builder.addFallback(formula, initialState);
            }
        } else if (piggyback == null) {
            ++this.setNumber;
        }
        return leaf;
    }

    @Nullable
    private AtomAcceptance findPiggybackableLeaf(List<DependencyTree<T>> leafs) {
        for (DependencyTree<T> leaf : leafs) {
            if (!(leaf instanceof DependencyTree.Leaf) || ((DependencyTree.Leaf)leaf).type != DependencyTree.Type.LIMIT_GF && ((DependencyTree.Leaf)leaf).type != DependencyTree.Type.LIMIT_FG) continue;
            return (AtomAcceptance)leaf.getAcceptanceExpression().getAtom();
        }
        return null;
    }

    private List<DependencyTree<T>> group(Iterable<Formula> formulas, List<Formula> safety, List<Formula> coSafety, List<Formula> finite) {
        ArrayList<DependencyTree<T>> children = new ArrayList<DependencyTree<T>>();
        formulas.forEach(x -> {
            if (SyntacticFragment.FINITE.contains((Formula)x)) {
                finite.add((Formula)x);
                return;
            }
            if (SyntacticFragment.CO_SAFETY.contains((Formula)x)) {
                coSafety.add((Formula)x);
                return;
            }
            if (SyntacticFragment.SAFETY.contains((Formula)x)) {
                safety.add((Formula)x);
                return;
            }
            children.add((DependencyTree)x.accept(this));
        });
        return children;
    }

    @Override
    public DependencyTree<T> visit(Disjunction disjunction) {
        ArrayList<Formula> safety = new ArrayList<Formula>();
        ArrayList<Formula> coSafety = new ArrayList<Formula>();
        ArrayList<Formula> finite = new ArrayList<Formula>();
        List<DependencyTree<T>> children = this.group(disjunction.children, safety, coSafety, finite);
        if (safety.isEmpty()) {
            coSafety.addAll(finite);
        } else {
            safety.addAll(finite);
        }
        if (!safety.isEmpty()) {
            children.add(this.defaultAction(Disjunction.of(safety), this.findPiggybackableLeaf(children)));
        }
        if (!coSafety.isEmpty()) {
            children.add((DependencyTree<T>)this.modalOperatorAction(Disjunction.of(coSafety)));
        }
        return DependencyTree.createOr(children);
    }

    @Override
    public DependencyTree<T> visit(BooleanConstant booleanConstant) {
        throw new IllegalStateException("The input formula should be constant-free.");
    }

    @Override
    public DependencyTree<T> visit(Conjunction conjunction) {
        ArrayList<Formula> safety = new ArrayList<Formula>();
        ArrayList<Formula> coSafety = new ArrayList<Formula>();
        ArrayList<Formula> finite = new ArrayList<Formula>();
        List<DependencyTree<T>> children = this.group(conjunction.children, safety, coSafety, finite);
        if (coSafety.isEmpty()) {
            safety.addAll(finite);
        } else {
            coSafety.addAll(finite);
        }
        if (!safety.isEmpty()) {
            children.add((DependencyTree<T>)this.modalOperatorAction(Conjunction.of(safety)));
        }
        if (!coSafety.isEmpty()) {
            children.add(this.defaultAction(Conjunction.of(coSafety), this.findPiggybackableLeaf(children)));
        }
        return DependencyTree.createAnd(children);
    }
}

