/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.dpa2safety;

import com.google.common.primitives.ImmutableIntArray;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntPredicate;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;

public class DPA2Safety<S>
implements BiFunction<Automaton<S, ParityAcceptance>, Integer, Automaton<Counter<S>, AllAcceptance>> {
    @Override
    public Automaton<Counter<S>, AllAcceptance> apply(Automaton<S, ParityAcceptance> automaton, Integer bound) {
        int d = automaton.acceptance().acceptanceSets() % 2 == 0 ? automaton.acceptance().acceptanceSets() + 1 : automaton.acceptance().acceptanceSets();
        Counter<S> initialState = new Counter<S>(automaton.onlyInitialState(), d / 2 + 1);
        IntPredicate isAcceptingColour = x -> ((ParityAcceptance)automaton.acceptance()).isAccepting(x);
        BiFunction<Counter, BitSet, Edge> successor = (x, y) -> {
            Edge edge = automaton.edge((Object)x.state, (BitSet)y);
            if (edge == null) {
                return null;
            }
            int[] counters = x.counters.toArray();
            int colour = edge.smallestAcceptanceSet();
            int i = (colour == Integer.MAX_VALUE ? d : colour) / 2;
            if (isAcceptingColour.test(colour)) {
                ++i;
                while (i < counters.length) {
                    counters[i] = 0;
                    ++i;
                }
            } else {
                int n = i;
                counters[n] = counters[n] + 1;
                if (x.counters.get(i) == bound.intValue()) {
                    return null;
                }
            }
            return Edge.of(new Counter(edge.successor(), counters));
        };
        return AutomatonFactory.create(automaton.factory(), initialState, AllAcceptance.INSTANCE, successor);
    }

    static final class Counter<X> {
        final X state;
        final ImmutableIntArray counters;

        Counter(X state, int length) {
            this(state, new int[length]);
        }

        Counter(X state, int[] counters) {
            this.state = state;
            this.counters = ImmutableIntArray.copyOf((int[])counters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Counter counters1 = (Counter)o;
            return Objects.equals(this.state, counters1.state) && Objects.equals(this.counters, counters1.counters);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.counters);
        }

        public String toString() {
            return "Counters{state=" + this.state + ", counters=" + this.counters + "}";
        }
    }
}

