/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.fgx2dpa;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.ltl.AbstractFormula;
import owl.ltl.Formula;
import owl.ltl.UnaryModalOperator;
import owl.translations.fgx2dpa.Monitor;

@ParametersAreNonnullByDefault
@Generated(from="Monitor", generator="Immutables")
@CheckReturnValue
@Immutable
final class MonitorTuple<F extends UnaryModalOperator>
extends Monitor<F> {
    private final F formula;
    private final ImmutableSet<Formula> currentTokens;
    private final transient Set<Formula> finalStates;
    private final transient Set<Formula> nonFinalStates;
    private final transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private MonitorTuple(F formula, Iterable<? extends Formula> currentTokens) {
        this.formula = (UnaryModalOperator)Objects.requireNonNull(formula, "formula");
        this.currentTokens = ImmutableSet.copyOf(currentTokens);
        this.finalStates = this.initShim.finalStates();
        this.nonFinalStates = this.initShim.nonFinalStates();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    @Override
    F formula() {
        return this.formula;
    }

    ImmutableSet<Formula> currentTokens() {
        return this.currentTokens;
    }

    @Override
    Set<Formula> finalStates() {
        InitShim shim = this.initShim;
        return shim != null ? shim.finalStates() : this.finalStates;
    }

    @Override
    Set<Formula> nonFinalStates() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nonFinalStates() : this.nonFinalStates;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MonitorTuple && this.equalTo((MonitorTuple)another);
    }

    private boolean equalTo(MonitorTuple<?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return ((AbstractFormula)this.formula).equals(another.formula) && this.currentTokens.equals(another.currentTokens);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + ((AbstractFormula)this.formula).hashCode();
        h += (h << 5) + this.currentTokens.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Monitor").omitNullValues().add("formula", this.formula).add("currentTokens", this.currentTokens).toString();
    }

    public static <F extends UnaryModalOperator> MonitorTuple<F> create(F formula, Set<Formula> currentTokens) {
        return MonitorTuple.create(formula, currentTokens);
    }

    public static <F extends UnaryModalOperator> MonitorTuple<F> create(F formula, Iterable<? extends Formula> currentTokens) {
        return new MonitorTuple<F>(formula, currentTokens);
    }

    private final class InitShim {
        private byte finalStatesBuildStage = 0;
        private Set<Formula> finalStates;
        private byte nonFinalStatesBuildStage = 0;
        private Set<Formula> nonFinalStates;

        private InitShim() {
        }

        Set<Formula> finalStates() {
            if (this.finalStatesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.finalStatesBuildStage == 0) {
                this.finalStatesBuildStage = (byte)-1;
                this.finalStates = Objects.requireNonNull(MonitorTuple.super.finalStates(), "finalStates");
                this.finalStatesBuildStage = 1;
            }
            return this.finalStates;
        }

        Set<Formula> nonFinalStates() {
            if (this.nonFinalStatesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nonFinalStatesBuildStage == 0) {
                this.nonFinalStatesBuildStage = (byte)-1;
                this.nonFinalStates = Objects.requireNonNull(MonitorTuple.super.nonFinalStates(), "nonFinalStates");
                this.nonFinalStatesBuildStage = 1;
            }
            return this.nonFinalStates;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.finalStatesBuildStage == -1) {
                attributes.add("finalStates");
            }
            if (this.nonFinalStatesBuildStage == -1) {
                attributes.add("nonFinalStates");
            }
            return "Cannot build Monitor, attribute initializers form cycle " + attributes;
        }
    }
}

