/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ldba2dra;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.translations.ldba2dpa.AbstractBuilder;
import owl.translations.ldba2dpa.LanguageLattice;
import owl.translations.ldba2dra.MapRankingState;
import owl.translations.ltl2ldba.breakpointfree.BooleanLattice;

public final class MapRankingAutomaton {
    private MapRankingAutomaton() {
    }

    public static <S, T, A, L> Automaton<MapRankingState<S, A, T>, GeneralizedRabinAcceptance> of(LimitDeterministicAutomaton<S, T, GeneralizedBuchiAcceptance, A> ldba, LanguageLattice<T, A, L> lattice, Predicate<S> isAcceptingState, boolean resetAfterSccSwitch, boolean optimizeInitialState) {
        Preconditions.checkArgument((boolean)(lattice instanceof BooleanLattice));
        Preconditions.checkArgument((boolean)ldba.initialStates().equals(ldba.initialComponent().initialStates()));
        int acceptanceSets = ldba.acceptingComponent().acceptance().acceptanceSets();
        Class acceptanceClass = acceptanceSets == 1 ? RabinAcceptance.class : GeneralizedRabinAcceptance.class;
        Builder<S, T, A, L, GeneralizedBuchiAcceptance, RabinAcceptance> builder = new Builder<S, T, A, L, GeneralizedBuchiAcceptance, RabinAcceptance>(ldba, resetAfterSccSwitch, lattice, isAcceptingState, acceptanceClass);
        Automaton<MapRankingState<S, A, T>, GeneralizedRabinAcceptance> automaton = AutomatonFactory.create(ldba.acceptingComponent().factory(), builder.initialState, builder.acceptance, builder::getSuccessor);
        return optimizeInitialState ? AbstractBuilder.optimizeInitialState(automaton) : automaton;
    }

    static final class Builder<S, T, A, L, B extends GeneralizedBuchiAcceptance, R extends GeneralizedRabinAcceptance>
    extends AbstractBuilder<S, T, A, L, B> {
        private static final Logger logger = Logger.getLogger(Builder.class.getName());
        final R acceptance;
        final Map<A, GeneralizedRabinAcceptance.RabinPair> pairs;
        final GeneralizedRabinAcceptance.RabinPair truePair;
        final MapRankingState<S, A, T> initialState;

        Builder(LimitDeterministicAutomaton<S, T, B, A> ldba, boolean resetAfterSccSwitch, LanguageLattice<T, A, L> lattice, Predicate<S> isAcceptingState, Class<R> acceptanceClass) {
            super(ldba, lattice, isAcceptingState, resetAfterSccSwitch);
            Object builder;
            logger.log(Level.FINER, "Safety Components: {0}", this.safetyComponents);
            this.pairs = new HashMap<A, GeneralizedRabinAcceptance.RabinPair>();
            if (acceptanceClass.equals(RabinAcceptance.class)) {
                builder = new RabinAcceptance.Builder();
                this.sortingOrder.forEach(arg_0 -> this.lambda$new$0((RabinAcceptance.Builder)builder, arg_0));
                this.truePair = ((RabinAcceptance.Builder)builder).add();
                this.acceptance = ((RabinAcceptance.Builder)builder).build();
            } else if (acceptanceClass.equals(GeneralizedRabinAcceptance.class)) {
                builder = new GeneralizedRabinAcceptance.Builder();
                int infSets = ((GeneralizedBuchiAcceptance)ldba.acceptingComponent().acceptance()).acceptanceSets();
                this.sortingOrder.forEach(arg_0 -> this.lambda$new$1((GeneralizedRabinAcceptance.Builder)builder, infSets, arg_0));
                this.truePair = ((GeneralizedRabinAcceptance.Builder)builder).add(0);
                this.acceptance = ((GeneralizedRabinAcceptance.Builder)builder).build();
            } else {
                throw new AssertionError();
            }
            S ldbaInitialState = ldba.initialComponent().onlyInitialState();
            this.initialState = this.buildEdge(ldbaInitialState, Map.of(), null).successor();
        }

        Edge<MapRankingState<S, A, T>> buildEdge(S state, Map<A, T> previousRanking, @Nullable BitSet valuation) {
            if (this.isAcceptingState.test(state)) {
                if (this.truePair.hasInfSet()) {
                    return Edge.of(MapRankingState.of(state), this.truePair.infSet());
                }
                return Edge.of(MapRankingState.of(state));
            }
            HashMap ranking = new HashMap();
            this.ldba.epsilonJumps(state).forEach(x -> ranking.put(this.ldba.annotation(x), x));
            BitSet acceptance = new BitSet();
            acceptance.set(this.truePair.finSet());
            previousRanking.forEach((annotation, x) -> {
                assert (valuation != null) : "Valuation is only allowed to be null for empty rankings.";
                Edge<Object> edge = this.ldba.acceptingComponent().edge(x, valuation);
                GeneralizedRabinAcceptance.RabinPair pair = this.pairs.get(annotation);
                if (edge == null || !ranking.containsKey(annotation)) {
                    acceptance.set(pair.finSet());
                } else {
                    ranking.put(annotation, edge.successor());
                    edge.acceptanceSetIterator().forEachRemaining(i -> acceptance.set(pair.infSet(i)));
                }
            });
            return Edge.of(MapRankingState.of(state, ranking), acceptance);
        }

        @Nullable
        Edge<MapRankingState<S, A, T>> getSuccessor(MapRankingState<S, A, T> state, BitSet valuation) {
            Edge edge = this.ldba.initialComponent().edge(state.state(), valuation);
            if (edge == null) {
                return null;
            }
            Object successor = edge.successor();
            if (this.sccSwitchOccurred(state.state(), successor)) {
                return Edge.of(this.buildEdge(successor, Map.of(), valuation).successor());
            }
            return this.buildEdge(successor, state.componentMap(), valuation);
        }

        private /* synthetic */ void lambda$new$1(GeneralizedRabinAcceptance.Builder builder, int infSets, Object x) {
            this.pairs.put(x, builder.add(infSets));
        }

        private /* synthetic */ void lambda$new$0(RabinAcceptance.Builder builder, Object x) {
            this.pairs.put(x, builder.add());
        }
    }
}

