/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import java.util.EnumSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import owl.ltl.LabelledFormula;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.translations.ltl2ldba.AbstractLTL2LDBAModule;

public final class LTL2DPACliParser
implements OwlModuleParser.TransformerParser {
    public static final LTL2DPACliParser INSTANCE = new LTL2DPACliParser();

    private LTL2DPACliParser() {
    }

    @Override
    public String getKey() {
        return "ltl2dpa";
    }

    @Override
    public String getDescription() {
        return "Translates LTL to deterministic parity automata, using an LDBA construction";
    }

    @Override
    public Options getOptions() {
        return new Options().addOption(null, "complement", false, "Compute the automaton also for the negation and return the smaller.").addOption("c", "complete", false, "Output a complete automaton").addOption(AbstractLTL2LDBAModule.guessF()).addOption(AbstractLTL2LDBAModule.simple());
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        EnumSet<LTL2DPAFunction.Configuration> configuration = commandLine.hasOption(AbstractLTL2LDBAModule.simple().getOpt()) ? EnumSet.noneOf(LTL2DPAFunction.Configuration.class) : EnumSet.of(LTL2DPAFunction.Configuration.EXISTS_SAFETY_CORE, LTL2DPAFunction.Configuration.OPTIMISED_STATE_STRUCTURE, LTL2DPAFunction.Configuration.OPTIMISE_INITIAL_STATE);
        if (commandLine.hasOption("complement")) {
            configuration.add(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION);
        }
        if (commandLine.hasOption("complete")) {
            configuration.add(LTL2DPAFunction.Configuration.COMPLETE);
        }
        if (commandLine.hasOption(AbstractLTL2LDBAModule.guessF().getOpt())) {
            configuration.add(LTL2DPAFunction.Configuration.GUESS_F);
        }
        configuration.add(LTL2DPAFunction.Configuration.COMPRESS_COLOURS);
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, new LTL2DPAFunction(environment, configuration));
    }
}

