/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.transformations.ParityUtil;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierFactory;
import owl.run.Environment;
import owl.translations.ldba2dpa.FlatRankingAutomaton;
import owl.translations.ldba2dpa.FlatRankingState;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.SafetyDetector;
import owl.translations.ltl2ldba.breakpoint.DegeneralizedBreakpointState;
import owl.translations.ltl2ldba.breakpoint.EquivalenceClassLanguageLattice;
import owl.translations.ltl2ldba.breakpoint.GObligations;
import owl.translations.ltl2ldba.breakpointfree.BooleanLattice;
import owl.translations.ltl2ldba.breakpointfree.DegeneralizedBreakpointFreeState;
import owl.translations.ltl2ldba.breakpointfree.FGObligations;
import owl.util.DaemonThreadFactory;

public class LTL2DPAFunction
implements Function<LabelledFormula, Automaton<?, ParityAcceptance>> {
    public static final Set<Configuration> RECOMMENDED_ASYMMETRIC_CONFIG = Set.of(Configuration.OPTIMISE_INITIAL_STATE, Configuration.OPTIMISED_STATE_STRUCTURE, Configuration.COMPLEMENT_CONSTRUCTION, Configuration.EXISTS_SAFETY_CORE, Configuration.COMPRESS_COLOURS);
    public static final Set<Configuration> RECOMMENDED_SYMMETRIC_CONFIG = Set.of(Configuration.GUESS_F, Configuration.OPTIMISE_INITIAL_STATE, Configuration.OPTIMISED_STATE_STRUCTURE, Configuration.COMPLEMENT_CONSTRUCTION, Configuration.EXISTS_SAFETY_CORE, Configuration.COMPRESS_COLOURS);
    private static final int GREEDY_WAITING_TIME_SEC = 7;
    private final EnumSet<Configuration> configuration;
    private final Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointState, BuchiAcceptance, GObligations>> translatorBreakpoint;
    private final Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointFreeState, BuchiAcceptance, FGObligations>> translatorBreakpointFree;

    public LTL2DPAFunction(Environment env, Set<Configuration> configuration) {
        this.configuration = EnumSet.copyOf(configuration);
        Preconditions.checkArgument((!configuration.contains((Object)Configuration.GREEDY) || configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION) ? 1 : 0) != 0, (Object)"GREEDY requires COMPLEMENT_CONSTRUCTION");
        EnumSet<LTL2LDBAFunction.Configuration> ldbaConfiguration = EnumSet.of(LTL2LDBAFunction.Configuration.EAGER_UNFOLD, LTL2LDBAFunction.Configuration.EPSILON_TRANSITIONS, LTL2LDBAFunction.Configuration.SUPPRESS_JUMPS);
        if (configuration.contains((Object)Configuration.OPTIMISED_STATE_STRUCTURE)) {
            ldbaConfiguration.add(LTL2LDBAFunction.Configuration.OPTIMISED_STATE_STRUCTURE);
        }
        this.translatorBreakpointFree = LTL2LDBAFunction.createDegeneralizedBreakpointFreeLDBABuilder(env, ldbaConfiguration);
        this.translatorBreakpoint = LTL2LDBAFunction.createDegeneralizedBreakpointLDBABuilder(env, ldbaConfiguration);
    }

    @Override
    public Automaton<?, ParityAcceptance> apply(LabelledFormula formula) {
        LabelledFormula formula2 = SimplifierFactory.apply(formula, SimplifierFactory.Mode.SYNTACTIC_FIXPOINT);
        ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory(Thread.currentThread().getThreadGroup()));
        Future<Result<?>> automatonFuture = executor.submit(this.callable(formula2, false));
        Future<Result<?>> complementFuture = executor.submit(this.callable(formula2, true));
        try {
            Automaton<?, ParityAcceptance> automaton = null;
            Automaton<?, ParityAcceptance> complement = null;
            do {
                if (automaton == null) {
                    automaton = this.getAutomaton(automatonFuture);
                }
                if (complement != null) continue;
                complement = this.getComplement(complementFuture);
            } while (!this.exitLoop(automaton, complement));
            if (complement == null) {
                assert (automaton != null);
                Automaton<?, ParityAcceptance> automaton2 = automaton;
                return automaton2;
            }
            if (automaton == null) {
                Automaton<?, ParityAcceptance> automaton3 = complement;
                return automaton3;
            }
            if (this.configuration.contains((Object)Configuration.GREEDY)) {
                Automaton<?, ParityAcceptance> automaton4 = formula2.formula() instanceof Conjunction ? complement : automaton;
                return automaton4;
            }
            if (automaton.size() < complement.size()) {
                Automaton<?, ParityAcceptance> automaton5 = automaton;
                return automaton5;
            }
            if (automaton.size() > complement.size()) {
                Automaton<?, ParityAcceptance> automaton6 = complement;
                return automaton6;
            }
            Automaton<?, ParityAcceptance> automaton7 = automaton.acceptance().acceptanceSets() <= complement.acceptance().acceptanceSets() ? automaton : complement;
            return automaton7;
        }
        catch (ExecutionException ex) {
            automatonFuture.cancel(true);
            complementFuture.cancel(true);
            throw new RuntimeException(ex);
        }
        finally {
            executor.shutdown();
        }
    }

    private boolean exitLoop(@Nullable Automaton<?, ?> automaton, @Nullable Automaton<?, ?> complement) {
        if (this.configuration.contains((Object)Configuration.GREEDY)) {
            return automaton != null || complement != null;
        }
        if (this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION)) {
            return automaton != null && complement != null;
        }
        return automaton != null;
    }

    @Nullable
    private Result<?> getResult(Future<Result<?>> future) throws ExecutionException {
        if (!this.configuration.contains((Object)Configuration.GREEDY)) {
            return (Result)Uninterruptibles.getUninterruptibly(future);
        }
        try {
            return future.get(7L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            return null;
        }
    }

    @Nullable
    private Automaton<?, ParityAcceptance> getAutomaton(Future<Result<?>> future) throws ExecutionException {
        Result<?> result = this.getResult(future);
        if (result == null) {
            return null;
        }
        if (this.configuration.contains((Object)Configuration.COMPLETE)) {
            return result.complete();
        }
        return result.automaton;
    }

    @Nullable
    private Automaton<?, ParityAcceptance> getComplement(Future<Result<?>> future) throws ExecutionException {
        Result<?> result = this.getResult(future);
        return result == null ? null : result.complement();
    }

    private Callable<Result<?>> callable(LabelledFormula formula, boolean complement) {
        if (!complement) {
            return this.configuration.contains((Object)Configuration.GUESS_F) ? () -> this.applyBreakpointFree(formula) : () -> this.applyBreakpoint(formula);
        }
        if (this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION)) {
            return this.configuration.contains((Object)Configuration.GUESS_F) ? () -> this.applyBreakpointFree(formula.not()) : () -> this.applyBreakpoint(formula.not());
        }
        return () -> null;
    }

    private Result<?> applyBreakpoint(LabelledFormula formula) {
        LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointState, BuchiAcceptance, GObligations> ldba = this.translatorBreakpoint.apply(formula);
        if (ldba.isDeterministic()) {
            return new Result<DegeneralizedBreakpointState>(Views.viewAs(ldba.acceptingComponent(), ParityAcceptance.class), DegeneralizedBreakpointState.createSink(), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
        }
        EquivalenceClassFactory factory = ldba.initialComponent().onlyInitialState().factory();
        Automaton<FlatRankingState<EquivalenceClass, DegeneralizedBreakpointState>, ParityAcceptance> automaton = FlatRankingAutomaton.of(ldba, new EquivalenceClassLanguageLattice(factory), x -> SafetyDetector.hasSafetyCore(x, this.configuration.contains((Object)Configuration.EXISTS_SAFETY_CORE)), true, this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE));
        return new Result(automaton, FlatRankingState.of(factory.getFalse()), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
    }

    private Result<?> applyBreakpointFree(LabelledFormula formula) {
        LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointFreeState, BuchiAcceptance, FGObligations> ldba = this.translatorBreakpointFree.apply(formula);
        if (ldba.isDeterministic()) {
            return new Result<DegeneralizedBreakpointFreeState>(Views.viewAs(ldba.acceptingComponent(), ParityAcceptance.class), DegeneralizedBreakpointFreeState.createSink(), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
        }
        EquivalenceClassFactory factory = ldba.initialComponent().onlyInitialState().factory();
        Automaton<FlatRankingState<EquivalenceClass, DegeneralizedBreakpointFreeState>, ParityAcceptance> automaton = FlatRankingAutomaton.of(ldba, new BooleanLattice(), x -> SafetyDetector.hasSafetyCore(x, this.configuration.contains((Object)Configuration.EXISTS_SAFETY_CORE)), true, this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE));
        return new Result(automaton, FlatRankingState.of(factory.getFalse()), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
    }

    private static final class Result<T> {
        final Automaton<T, ParityAcceptance> automaton;
        final T sinkState;

        Result(Automaton<T, ParityAcceptance> automaton, T sinkState, boolean compressColours) {
            this.sinkState = sinkState;
            this.automaton = compressColours ? ParityUtil.minimizePriorities(MutableAutomatonUtil.asMutable(automaton)) : automaton;
        }

        Automaton<T, ParityAcceptance> complete() {
            MutableAutomaton<T, ParityAcceptance> automaton = MutableAutomatonUtil.asMutable(this.automaton);
            MutableAutomatonUtil.complete(automaton, this.sinkState);
            return automaton;
        }

        Automaton<T, ParityAcceptance> complement() {
            if (this.automaton instanceof MutableAutomaton || this.automaton.acceptance().parity() != ParityAcceptance.Parity.MIN_ODD) {
                return ParityUtil.complement(MutableAutomatonUtil.asMutable(this.automaton), this.sinkState);
            }
            assert (this.automaton.acceptance().parity() == ParityAcceptance.Parity.MIN_ODD);
            return AutomatonUtil.cast(Views.complement(this.automaton, this.sinkState), ParityAcceptance.class);
        }
    }

    public static enum Configuration {
        OPTIMISE_INITIAL_STATE,
        OPTIMISED_STATE_STRUCTURE,
        COMPLEMENT_CONSTRUCTION,
        EXISTS_SAFETY_CORE,
        COMPLETE,
        GUESS_F,
        GREEDY,
        COMPRESS_COLOURS;

    }
}

