/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import java.util.EnumSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2dra.LTL2DRAFunction;
import owl.translations.ltl2ldba.AbstractLTL2LDBAModule;

public final class LTL2DRACliParser
implements OwlModuleParser.TransformerParser {
    public static final LTL2DRACliParser INSTANCE = new LTL2DRACliParser();
    private static final Option DEGENERALIZE = new Option("d", "degeneralize", false, "Construct a Rabin automaton instead of a generalised-Rabin automaton (smaller than general-purpose degeneralization).");

    private LTL2DRACliParser() {
    }

    @Override
    public String getKey() {
        return "ltl2dra";
    }

    @Override
    public String getDescription() {
        return "Translates LTL to deterministic (generalized) Rabin automata, using an LDBA construction";
    }

    @Override
    public Options getOptions() {
        return new Options().addOption(AbstractLTL2LDBAModule.simple()).addOption(DEGENERALIZE);
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        EnumSet<LTL2DRAFunction.Configuration> configuration = commandLine.hasOption(AbstractLTL2LDBAModule.simple().getOpt()) ? EnumSet.noneOf(LTL2DRAFunction.Configuration.class) : EnumSet.of(LTL2DRAFunction.Configuration.EXISTS_SAFETY_CORE, LTL2DRAFunction.Configuration.OPTIMISED_STATE_STRUCTURE, LTL2DRAFunction.Configuration.OPTIMISE_INITIAL_STATE);
        if (commandLine.hasOption(DEGENERALIZE.getOpt())) {
            configuration.add(LTL2DRAFunction.Configuration.DEGENERALIZE);
        }
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, new LTL2DRAFunction(environment, configuration));
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("ltl2dra").reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).addTransformer(Transformers.MINIMIZER).writer(OutputWriters.HOA).build());
    }
}

