/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpoint;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2ldba.breakpoint.GObligations;
import owl.util.StringUtil;

public final class DegeneralizedBreakpointState {
    @Nullable
    final EquivalenceClass current;
    final int index;
    final EquivalenceClass[] next;
    @Nullable
    final GObligations obligations;
    @Nullable
    final EquivalenceClass safety;
    @Nullable
    private EquivalenceClass label = null;
    private int hashCode = 0;

    DegeneralizedBreakpointState(int index, @Nullable EquivalenceClass safety, @Nullable EquivalenceClass current, EquivalenceClass[] next, @Nullable GObligations obligations) {
        assert (obligations == null || obligations.obligations().size() == 0 && obligations.liveness().size() == 0 && index == 0 || -obligations.liveness().size() <= index && index < obligations.obligations().size());
        this.index = index;
        this.current = current;
        this.obligations = obligations;
        this.safety = safety;
        this.next = next;
    }

    public static DegeneralizedBreakpointState createSink() {
        return new DegeneralizedBreakpointState(0, null, null, EquivalenceClass.EMPTY_ARRAY, null);
    }

    EquivalenceClass getLabel() {
        if (this.label == null) {
            assert (this.safety != null && this.current != null && this.obligations != null);
            this.label = this.safety.and(this.current);
            for (EquivalenceClass clazz : this.next) {
                this.label = this.label.and(clazz);
            }
            for (EquivalenceClass clazz : this.obligations.obligations()) {
                this.label = this.label.and(clazz);
            }
            for (EquivalenceClass clazz : this.obligations.liveness()) {
                this.label = this.label.and(clazz);
            }
        }
        return this.label;
    }

    public GObligations getObligations() {
        assert (this.obligations != null);
        return this.obligations;
    }

    public String toString() {
        return this.obligations + StringUtil.join(this.safety == null || this.safety.isTrue() ? null : "GWR=" + this.safety, this.index == 0 ? null : "i=" + this.index, this.current == null || this.current.isTrue() ? null : "C=" + this.current, this.next.length <= 0 ? null : "N=" + Arrays.toString(this.next));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DegeneralizedBreakpointState other = (DegeneralizedBreakpointState)o;
        return (this.hashCode == 0 || other.hashCode == 0 || other.hashCode == this.hashCode) && this.index == other.index && Objects.equals(this.safety, other.safety) && Objects.equals(this.current, other.current) && Arrays.equals(this.next, other.next) && Objects.equals(this.obligations, other.obligations);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.current, this.obligations, this.safety, this.index, Arrays.hashCode(this.next));
        }
        return this.hashCode;
    }
}

