/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpoint;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.factories.Factories;
import owl.ltl.EquivalenceClass;
import owl.ltl.SyntacticFragment;
import owl.translations.ltl2ldba.AbstractAcceptingComponentBuilder;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.breakpoint.GObligations;
import owl.translations.ltl2ldba.breakpoint.GeneralizedBreakpointState;

public final class GeneralizedAcceptingComponentBuilder
extends AbstractAcceptingComponentBuilder<GeneralizedBreakpointState, GeneralizedBuchiAcceptance, GObligations> {
    @Nonnegative
    private int acceptanceSets = 1;

    public GeneralizedAcceptingComponentBuilder(Factories factories, Set<LTL2LDBAFunction.Configuration> optimisations) {
        super(optimisations, factories);
    }

    @Override
    public MutableAutomaton<GeneralizedBreakpointState, GeneralizedBuchiAcceptance> build() {
        return MutableAutomatonFactory.create(GeneralizedBuchiAcceptance.of(this.acceptanceSets), this.factories.vsFactory, this.anchors, this::getSuccessor, this::getSensitiveAlphabet);
    }

    @Override
    public GeneralizedBreakpointState createState(EquivalenceClass remainder, GObligations obligations) {
        int i;
        EquivalenceClass theRemainder = remainder;
        int length = obligations.obligations().size() + obligations.liveness().size();
        if (length > this.acceptanceSets) {
            this.acceptanceSets = length;
        }
        EquivalenceClass safety = obligations.safety();
        if (theRemainder.modalOperators().stream().allMatch(SyntacticFragment.FINITE::contains)) {
            safety = theRemainder.and(safety);
            theRemainder = this.factories.eqFactory.getTrue();
        }
        if (length == 0) {
            if (theRemainder.isTrue()) {
                return GeneralizedBreakpointState.of(obligations, safety, EquivalenceClass.EMPTY_ARRAY, EquivalenceClass.EMPTY_ARRAY);
            }
            return GeneralizedBreakpointState.of(obligations, safety, new EquivalenceClass[]{theRemainder}, EquivalenceClass.EMPTY_ARRAY);
        }
        EquivalenceClass[] currentBuilder = new EquivalenceClass[length];
        currentBuilder[0] = obligations.obligations().size() > 0 ? this.factory.getInitial(theRemainder.and(obligations.obligations().get(0)), new EquivalenceClass[0]) : this.factory.getInitial(theRemainder.and(obligations.liveness().get(0)), new EquivalenceClass[0]);
        for (i = 1; i < obligations.obligations().size(); ++i) {
            currentBuilder[i] = this.factory.getInitial(obligations.obligations().get(i), new EquivalenceClass[0]);
        }
        for (i = Math.max(1, obligations.obligations().size()); i < length; ++i) {
            currentBuilder[i] = this.factory.getInitial(obligations.liveness().get(i - obligations.obligations().size()), new EquivalenceClass[0]);
        }
        Object[] next = new EquivalenceClass[obligations.obligations().size()];
        Arrays.fill(next, this.factories.eqFactory.getTrue());
        return GeneralizedBreakpointState.of(obligations, safety, currentBuilder, (EquivalenceClass[])next);
    }

    @Nonnull
    private BitSet getSensitiveAlphabet(GeneralizedBreakpointState state) {
        BitSet sensitiveAlphabet = this.factory.getSensitiveAlphabet(state.safety);
        for (EquivalenceClass clazz : state.current) {
            sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(clazz));
        }
        for (EquivalenceClass clazz : state.next) {
            sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(clazz));
        }
        return sensitiveAlphabet;
    }

    @Nullable
    public Edge<GeneralizedBreakpointState> getSuccessor(GeneralizedBreakpointState state, BitSet valuation) {
        EquivalenceClass currentSuccessor;
        int i;
        EquivalenceClass nextSafety = this.factory.getSuccessor(state.safety, valuation, new EquivalenceClass[0]).and(state.obligations.safety());
        if (nextSafety.isFalse()) {
            return null;
        }
        if (state.obligations.obligations().isEmpty() && state.obligations.liveness().isEmpty()) {
            return this.getSuccessorPureSafety(state, nextSafety, valuation);
        }
        int length = state.current.length;
        EquivalenceClass[] currentSuccessors = new EquivalenceClass[length];
        EquivalenceClass[] nextSuccessors = new EquivalenceClass[state.next.length];
        BitSet bs = new BitSet();
        bs.set(length, this.acceptanceSets);
        for (i = 0; i < state.next.length; ++i) {
            currentSuccessor = this.factory.getSuccessor(state.current[i], valuation, nextSafety);
            if (currentSuccessor.isFalse()) {
                return null;
            }
            EquivalenceClass assumptions = currentSuccessor.and(nextSafety);
            EquivalenceClass nextSuccessor = this.factory.getSuccessor(state.next[i], valuation, assumptions);
            if (nextSuccessor.isFalse()) {
                return null;
            }
            nextSuccessor = nextSuccessor.and(this.factory.getInitial(state.obligations.obligations().get(i), assumptions));
            if (currentSuccessor.isTrue()) {
                bs.set(i);
                currentSuccessors[i] = nextSuccessor;
                nextSuccessors[i] = this.factories.eqFactory.getTrue();
                continue;
            }
            currentSuccessors[i] = currentSuccessor;
            nextSuccessors[i] = nextSuccessor;
        }
        for (i = state.next.length; i < length; ++i) {
            currentSuccessor = this.factory.getSuccessor(state.current[i], valuation, nextSafety);
            if (currentSuccessor.isFalse()) {
                return null;
            }
            if (currentSuccessor.isTrue()) {
                bs.set(i);
                currentSuccessors[i] = this.factory.getInitial(state.obligations.liveness().get(i - state.next.length), new EquivalenceClass[0]);
                continue;
            }
            currentSuccessors[i] = currentSuccessor;
        }
        return Edge.of(GeneralizedBreakpointState.of(state.obligations, nextSafety, currentSuccessors, nextSuccessors), bs);
    }

    @Nullable
    private Edge<GeneralizedBreakpointState> getSuccessorPureSafety(GeneralizedBreakpointState state, EquivalenceClass nextSafety, BitSet valuation) {
        if (state.current.length > 0) {
            EquivalenceClass remainder = this.factory.getSuccessor(state.current[0], valuation, nextSafety);
            if (remainder.isFalse()) {
                return null;
            }
            if (!remainder.isTrue()) {
                return Edge.of(GeneralizedBreakpointState.of(state.obligations, nextSafety, new EquivalenceClass[]{remainder}, EquivalenceClass.EMPTY_ARRAY));
            }
        }
        BitSet acceptance = new BitSet();
        acceptance.set(0, this.acceptanceSets);
        return Edge.of(GeneralizedBreakpointState.of(state.obligations, nextSafety, EquivalenceClass.EMPTY_ARRAY, EquivalenceClass.EMPTY_ARRAY), acceptance);
    }
}

