/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpointfree;

import java.util.BitSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.factories.Factories;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2ldba.AbstractAcceptingComponentBuilder;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.breakpointfree.DegeneralizedBreakpointFreeState;
import owl.translations.ltl2ldba.breakpointfree.FGObligations;

public final class DegeneralizedAcceptingComponentBuilder
extends AbstractAcceptingComponentBuilder<DegeneralizedBreakpointFreeState, BuchiAcceptance, FGObligations> {
    public DegeneralizedAcceptingComponentBuilder(Factories factories, Set<LTL2LDBAFunction.Configuration> optimisations) {
        super(optimisations, factories);
    }

    @Override
    public MutableAutomaton<DegeneralizedBreakpointFreeState, BuchiAcceptance> build() {
        return MutableAutomatonFactory.create(BuchiAcceptance.INSTANCE, this.factories.vsFactory, this.anchors, this::getSuccessor, this::getSensitiveAlphabet);
    }

    @Override
    @Nullable
    protected DegeneralizedBreakpointFreeState createState(EquivalenceClass remainder, FGObligations obligations) {
        EquivalenceClass safety = remainder.and(obligations.safety);
        if (safety.isFalse()) {
            return null;
        }
        EquivalenceClass liveness = obligations.liveness.size() > 0 ? this.factory.getInitial(obligations.liveness.get(0), new EquivalenceClass[0]) : this.factories.eqFactory.getTrue();
        return new DegeneralizedBreakpointFreeState(0, this.factory.getInitial(safety, liveness), liveness, obligations);
    }

    @Nonnull
    public BitSet getSensitiveAlphabet(DegeneralizedBreakpointFreeState state) {
        BitSet sensitiveAlphabet = this.factory.getSensitiveAlphabet(state.liveness);
        sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(state.safety));
        for (EquivalenceClass clazz : state.obligations.liveness) {
            sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(this.factory.getInitial(clazz, new EquivalenceClass[0])));
        }
        return sensitiveAlphabet;
    }

    @Nullable
    public Edge<DegeneralizedBreakpointFreeState> getSuccessor(DegeneralizedBreakpointFreeState state, BitSet valuation) {
        int j;
        EquivalenceClass livenessSuccessor = this.factory.getSuccessor(state.liveness, valuation, new EquivalenceClass[0]);
        EquivalenceClass safetySuccessor = this.factory.getSuccessor(state.safety, valuation, livenessSuccessor);
        if (safetySuccessor.isFalse()) {
            return null;
        }
        int livenessLength = state.obligations.liveness.size();
        boolean acceptingEdge = false;
        boolean obtainNewGoal = false;
        if (livenessSuccessor.isTrue()) {
            obtainNewGoal = true;
            j = this.scan(state, state.index + 1, valuation);
            if (j >= livenessLength) {
                acceptingEdge = true;
                j = this.scan(state, 0, valuation);
                if (j >= livenessLength) {
                    j = 0;
                }
            }
        } else {
            j = state.index;
        }
        if (obtainNewGoal && j < state.obligations.liveness.size()) {
            livenessSuccessor = this.factory.getInitial(state.obligations.liveness.get(j), new EquivalenceClass[0]);
        }
        assert (!livenessSuccessor.isFalse()) : "Liveness property cannot be false.";
        DegeneralizedBreakpointFreeState successor = new DegeneralizedBreakpointFreeState(j, safetySuccessor, livenessSuccessor, state.obligations);
        return acceptingEdge ? Edge.of(successor, 0) : Edge.of(successor);
    }

    @Nonnegative
    private int scan(DegeneralizedBreakpointFreeState state, @Nonnegative int i, BitSet valuation) {
        EquivalenceClass successor;
        int index;
        int livenessLength = state.obligations.liveness.size();
        for (index = i; index < livenessLength && (successor = this.factory.getSuccessor(this.factory.getInitial(state.obligations.liveness.get(index), new EquivalenceClass[0]), valuation, new EquivalenceClass[0])).isTrue(); ++index) {
        }
        return index;
    }
}

