/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2ldba;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.ldba.LimitDeterministicAutomatonBuilder;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.nba2ldba.AcceptingComponentBuilder;

public final class NBA2LDBA
implements Function<Automaton<?, ?>, LimitDeterministicAutomaton<?, ?, BuchiAcceptance, Void>> {
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("nba2ldba").description("Converts a non-deterministic B\u00fcchi automaton into a limit-deterministic B\u00fcchi automaton").parser(settings -> {
        EnumSet<LimitDeterministicAutomatonBuilder.Configuration> ldbaConfiguration = EnumSet.of(LimitDeterministicAutomatonBuilder.Configuration.REMOVE_EPSILON_TRANSITIONS, LimitDeterministicAutomatonBuilder.Configuration.SUPPRESS_JUMPS_FOR_TRANSIENT_STATES);
        NBA2LDBA function = new NBA2LDBA(false, ldbaConfiguration);
        return environment -> (input, context) -> function.apply(AutomatonUtil.cast(input, Object.class, OmegaAcceptance.class));
    }).build();
    private final boolean cutDeterministicAndComplete;
    private final EnumSet<LimitDeterministicAutomatonBuilder.Configuration> ldbaConfiguration;

    public NBA2LDBA(boolean cutDeterministicAndComplete, EnumSet<LimitDeterministicAutomatonBuilder.Configuration> ldbaConfiguration) {
        this.cutDeterministicAndComplete = cutDeterministicAndComplete;
        this.ldbaConfiguration = EnumSet.copyOf(ldbaConfiguration);
    }

    @Override
    public LimitDeterministicAutomaton<?, ?, BuchiAcceptance, Void> apply(Automaton<?, ?> automaton) {
        Automaton<Object, GeneralizedBuchiAcceptance> nba;
        if (automaton.acceptance() instanceof AllAcceptance) {
            Automaton<Set<?>, AllAcceptance> allAutomaton = Views.createPowerSetAutomaton(automaton, AllAcceptance.INSTANCE, true);
            Automaton<Object, AllAcceptance> castedAutomaton = AutomatonUtil.cast(allAutomaton, Object.class, AllAcceptance.class);
            nba = Views.viewAs(castedAutomaton, GeneralizedBuchiAcceptance.class);
        } else if (automaton.acceptance() instanceof GeneralizedBuchiAcceptance) {
            nba = AutomatonUtil.cast(automaton, Object.class, GeneralizedBuchiAcceptance.class);
        } else {
            throw new UnsupportedOperationException(automaton.acceptance() + " is unsupported.");
        }
        if (this.cutDeterministicAndComplete) {
            MutableAutomaton<Set<Object>, NoneAcceptance> initialComponent = MutableAutomatonFactory.copy(Views.createPowerSetAutomaton(nba, NoneAcceptance.INSTANCE, false));
            AcceptingComponentBuilder<Object> acceptingComponentBuilder = new AcceptingComponentBuilder<Object>(nba, true);
            return LimitDeterministicAutomatonBuilder.create(() -> initialComponent, acceptingComponentBuilder, x -> x, x -> null, this.ldbaConfiguration).build();
        }
        Optional<LimitDeterministicAutomaton<AutomatonUtil.InitialComponentState<Object>, Object, GeneralizedBuchiAcceptance, Void>> ldbaOptional = AutomatonUtil.ldbaSplit(nba);
        if (ldbaOptional.isPresent() && ldbaOptional.get().acceptingComponent().acceptance() instanceof BuchiAcceptance) {
            return ldbaOptional.get();
        }
        MutableAutomaton<Object, NoneAcceptance> initialComponent = MutableAutomatonFactory.copy(Views.viewAsLts(nba));
        AcceptingComponentBuilder<Object> acceptingComponentBuilder = new AcceptingComponentBuilder<Object>(nba, false);
        return LimitDeterministicAutomatonBuilder.create(() -> initialComponent, acceptingComponentBuilder, Set::of, x -> null, this.ldbaConfiguration).build();
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("nba2ldba").reader(InputReaders.HOA).addTransformer(CLI).writer(OutputWriters.HOA).build());
    }
}

