/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import de.tum.in.naturals.Indices;
import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.set.NatCartesianProductIterator;
import de.tum.in.naturals.set.NatCartesianProductSet;
import de.tum.in.naturals.set.PowerSetIterator;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.output.HoaPrinter;
import owl.collections.ValuationSet;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.factories.ValuationSetFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Collector;
import owl.ltl.visitors.Converter;
import owl.ltl.visitors.PrintVisitor;
import owl.run.Environment;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MasterStatePartition;
import owl.translations.rabinizer.MonitorAutomaton;
import owl.translations.rabinizer.MonitorBuilder;
import owl.translations.rabinizer.MonitorBuilderNoAcceptance;
import owl.translations.rabinizer.MonitorState;
import owl.translations.rabinizer.RabinizerConfiguration;
import owl.translations.rabinizer.RabinizerProductEdge;
import owl.translations.rabinizer.RabinizerState;
import owl.translations.rabinizer.RabinizerStateFactory;
import owl.translations.rabinizer.RabinizerUtil;
import owl.util.IntBiConsumer;

public final class RabinizerBuilder {
    private static final MonitorAutomaton[] EMPTY_MONITORS = new MonitorAutomaton[0];
    private static final GOperator[] EMPTY_G_OPERATORS = new GOperator[0];
    private static final Logger logger = Logger.getLogger(RabinizerBuilder.class.getName());
    private final RabinizerConfiguration configuration;
    private final EquivalenceClassFactory eqFactory;
    private final EquivalenceClass initialClass;
    private final RabinizerStateFactory.MasterStateFactory masterStateFactory;
    private final RabinizerStateFactory.ProductStateFactory productStateFactory;
    private final ValuationSetFactory vsFactory;

    private RabinizerBuilder(RabinizerConfiguration configuration, Factories factories, Formula formula) {
        EquivalenceClass initialClass = factories.eqFactory.of(formula);
        this.configuration = configuration;
        this.initialClass = initialClass;
        boolean fairnessFragment = configuration.eager() && initialClass.atomicPropositions().isEmpty() && initialClass.modalOperators().stream().allMatch(support -> SyntacticFragments.isInfinitelyOften(support) || SyntacticFragments.isAlmostAll(support));
        this.vsFactory = factories.vsFactory;
        this.eqFactory = factories.eqFactory;
        this.masterStateFactory = new RabinizerStateFactory.MasterStateFactory(configuration.eager(), configuration.completeAutomaton(), fairnessFragment);
        this.productStateFactory = new RabinizerStateFactory.ProductStateFactory(configuration.eager());
    }

    private static ValuationSet[][] computeMonitorPriorities(MonitorAutomaton[] monitors, List<MonitorState> monitorStates, GSet activeSet) {
        int monitorCount = monitors.length;
        ValuationSet[][] monitorPriorities = new ValuationSet[monitorCount][];
        for (int relevantIndex = 0; relevantIndex < monitorStates.size(); ++relevantIndex) {
            MonitorState monitorState = monitorStates.get(relevantIndex);
            Automaton<MonitorState, ParityAcceptance> monitor = monitors[relevantIndex].getAutomaton(activeSet);
            int monitorAcceptanceSets = monitor.acceptance().acceptanceSets();
            ValuationSet[] edgePriorities = new ValuationSet[monitorAcceptanceSets];
            monitor.forEachLabelledEdge(monitorState, (edge, valuations) -> {
                if (!edge.hasAcceptanceSets()) {
                    return;
                }
                int priority = edge.smallestAcceptanceSet();
                assert (priority == edge.largestAcceptanceSet());
                edgePriorities[priority] = edgePriorities[priority] == null ? valuations : valuations.union(edgePriorities[priority]);
            });
            monitorPriorities[relevantIndex] = edgePriorities;
        }
        return monitorPriorities;
    }

    private static boolean isSuspendableScc(Set<EquivalenceClass> scc, Set<GOperator> relevantOperators) {
        BitSet internalAtoms = Collector.collectAtoms(relevantOperators);
        for (EquivalenceClass state : scc) {
            EvaluateVisitor visitor = new EvaluateVisitor(relevantOperators, state);
            EquivalenceClass substitute = state.substitute(visitor);
            BitSet externalAtoms = Collector.collectAtoms(substitute.modalOperators());
            externalAtoms.or(substitute.atomicPropositions());
            if (!externalAtoms.isEmpty() && !externalAtoms.intersects(internalAtoms)) continue;
            return false;
        }
        return true;
    }

    private static String printOperatorSets(ActiveSet[] activeSets) {
        StringBuilder tableBuilder = new StringBuilder(60 + activeSets.length * 20);
        tableBuilder.append("Acceptance mapping (GSet -> Ranking -> Pair):");
        for (ActiveSet activeSet : activeSets) {
            GSet subset = activeSet.set;
            tableBuilder.append("\n ").append(subset);
            Iterator<int[]> rankingIterator = activeSet.rankings.iterator();
            int index = 0;
            while (rankingIterator.hasNext()) {
                GeneralizedRabinAcceptance.RabinPair pair = activeSet.getPairForRanking(index);
                tableBuilder.append("\n  ").append(RabinizerUtil.printRanking(rankingIterator.next())).append(" -> ").append(pair);
                ++index;
            }
        }
        return tableBuilder.toString();
    }

    public static MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> build(LabelledFormula formula, Environment environment, RabinizerConfiguration configuration) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables());
        Formula phiNormalized = SyntacticFragments.normalize(formula.formula(), SyntacticFragment.FGMU);
        String formulaString = PrintVisitor.toString(phiNormalized, factories.eqFactory.variables());
        logger.log(Level.FINE, "Creating rabinizer automaton for formula {0}", formulaString);
        MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> rabinizerAutomaton = new RabinizerBuilder(configuration, factories, phiNormalized).build();
        rabinizerAutomaton.name("Rabinizer automaton for " + formulaString);
        rabinizerAutomaton.trim();
        return rabinizerAutomaton;
    }

    private MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> build() {
        ActiveSet[] activeSets;
        EquivalenceClass initialClass = this.masterStateFactory.getInitialState(this.initialClass);
        MutableAutomaton<EquivalenceClass, AllAcceptance> masterAutomaton = MutableAutomatonFactory.create(AllAcceptance.INSTANCE, this.vsFactory, Set.of(initialClass), this.masterStateFactory::getSuccessor, this.masterStateFactory::getClassSensitiveAlphabet);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Master automaton for {0}:\n{1}", new Object[]{this.initialClass, HoaPrinter.toString(masterAutomaton)});
        } else {
            logger.log(Level.FINE, "Master automaton for {0} has {1} states", new Object[]{this.initialClass, masterAutomaton.size()});
        }
        MasterStatePartition masterSccPartition = MasterStatePartition.create(masterAutomaton);
        logger.log(Level.FINER, masterSccPartition::toString);
        int partitionSize = masterSccPartition.partitionSize();
        Set[] sccRelevantGList = new Set[partitionSize];
        Indices.forEachIndexed(masterSccPartition.sccs, (index, stateSubset) -> {
            sccRelevantGList[index] = stateSubset.stream().map(this::relevantSubFormulas).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        });
        Set<GOperator> allRelevantGFormulas = Arrays.stream(sccRelevantGList).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        logger.log(Level.FINE, "Identified relevant sub-formulas: {0}", allRelevantGFormulas);
        int numberOfGFormulas = allRelevantGFormulas.size();
        GOperator[] gFormulas = allRelevantGFormulas.toArray(EMPTY_G_OPERATORS);
        MonitorAutomaton[] monitors = new MonitorAutomaton[numberOfGFormulas];
        Arrays.setAll(monitors, gIndex -> this.buildMonitor(gFormulas[gIndex]));
        boolean computeAcceptance = this.configuration.computeAcceptance();
        GeneralizedRabinAcceptance.Builder builder = new GeneralizedRabinAcceptance.Builder();
        Set relevantSets = Sets.powerSet(allRelevantGFormulas);
        assert (relevantSets.contains(Set.of()));
        if (computeAcceptance) {
            int gSetCount = relevantSets.size() - 1;
            activeSets = new ActiveSet[gSetCount];
            int activeSetIndex = 0;
            for (Set subset : relevantSets) {
                if (subset.isEmpty()) continue;
                GSet gSet = new GSet(subset, this.eqFactory);
                activeSets[activeSetIndex] = ActiveSet.create(gFormulas, gSet, monitors, builder);
                ++activeSetIndex;
            }
        } else {
            activeSets = null;
        }
        MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> rabinizerAutomaton = MutableAutomatonFactory.create(builder.build(), this.vsFactory);
        List<Set<EquivalenceClass>> partition = masterSccPartition.sccs;
        HashMultimap statesPerClass = HashMultimap.create();
        for (int sccIndex = 0; sccIndex < partition.size(); ++sccIndex) {
            boolean[] relevantFormulas;
            MonitorAutomaton[] sccMonitors;
            boolean suspendable;
            Set<EquivalenceClass> scc = partition.get(sccIndex);
            Set sccRelevantOperators = sccRelevantGList[sccIndex];
            boolean bl = suspendable = this.configuration.suspendableFormulaDetection() && RabinizerBuilder.isSuspendableScc(scc, sccRelevantOperators);
            if (suspendable) {
                sccMonitors = EMPTY_MONITORS;
                relevantFormulas = BooleanArrays.EMPTY_ARRAY;
                logger.log(Level.FINE, "Suspending all Gs on SCC {0}", sccIndex);
            } else {
                relevantFormulas = new boolean[numberOfGFormulas];
                sccMonitors = new MonitorAutomaton[sccRelevantOperators.size()];
                int subsetRelevantIndex = 0;
                for (int gIndex2 = 0; gIndex2 < numberOfGFormulas; ++gIndex2) {
                    boolean indexRelevant;
                    relevantFormulas[gIndex2] = indexRelevant = sccRelevantOperators.contains(gFormulas[gIndex2]);
                    if (!indexRelevant) continue;
                    sccMonitors[subsetRelevantIndex] = monitors[gIndex2];
                    ++subsetRelevantIndex;
                }
                logger.log(Level.FINE, "Building product of SCC {0}, size: {1}, formulas: {2}", new Object[]{sccIndex, scc.size(), sccRelevantOperators});
            }
            Map<RabinizerState, Map<RabinizerProductEdge, ValuationSet>> transitionSystem = this.exploreTransitionSystem(scc, masterAutomaton, sccMonitors);
            if (!computeAcceptance || sccRelevantOperators.isEmpty()) {
                transitionSystem.forEach((arg_0, arg_1) -> this.lambda$build$4((Multimap)statesPerClass, rabinizerAutomaton, arg_0, arg_1));
                continue;
            }
            logger.log(Level.FINER, "Computing acceptance on SCC {0}", sccIndex);
            transitionSystem.forEach((arg_0, arg_1) -> this.lambda$build$8(relevantFormulas, activeSets, sccMonitors, (Multimap)statesPerClass, rabinizerAutomaton, arg_0, arg_1));
        }
        logger.log(Level.FINE, "Connecting the SCCs");
        masterSccPartition.transientStates.forEach(arg_0 -> RabinizerBuilder.lambda$build$9((Multimap)statesPerClass, arg_0));
        Function<EquivalenceClass, RabinizerState> getAnyState = arg_0 -> RabinizerBuilder.lambda$build$10(masterSccPartition, (Multimap)statesPerClass, arg_0);
        masterSccPartition.outgoingTransitions.rowMap().forEach((arg_0, arg_1) -> this.lambda$build$12((Multimap)statesPerClass, getAnyState, rabinizerAutomaton, arg_0, arg_1));
        rabinizerAutomaton.initialStates(Set.of(getAnyState.apply(initialClass)));
        rabinizerAutomaton.trim();
        RabinizerState trueState = RabinizerState.empty(this.eqFactory.getTrue());
        if (rabinizerAutomaton.states().contains(trueState)) {
            assert (Objects.equals(Iterables.getOnlyElement(rabinizerAutomaton.successors(trueState)), trueState));
            GeneralizedRabinAcceptance.RabinPair truePair = builder.add(1);
            rabinizerAutomaton.removeEdge(trueState, rabinizerAutomaton.factory().universe(), trueState);
            rabinizerAutomaton.addEdge(trueState, this.vsFactory.universe(), Edge.of(trueState, truePair.infSet()));
            rabinizerAutomaton.acceptance(builder.build());
            rabinizerAutomaton.trim();
        }
        logger.log(Level.FINER, () -> String.format("Result:%n%s", HoaPrinter.toString(rabinizerAutomaton)));
        if (activeSets != null) {
            logger.log(Level.FINER, () -> RabinizerBuilder.printOperatorSets(activeSets));
        }
        return rabinizerAutomaton;
    }

    private MonitorAutomaton buildMonitor(GOperator gOperator) {
        logger.log(Level.FINE, "Building monitor for sub-formula {0}", gOperator);
        EquivalenceClass operand = this.eqFactory.of(gOperator.operand);
        Set<GOperator> relevantOperators = this.relevantSubFormulas(operand);
        Set powerSets = Sets.powerSet(relevantOperators);
        ArrayList<GSet> relevantGSets = new ArrayList<GSet>(powerSets.size());
        powerSets.forEach(gSet -> relevantGSets.add(new GSet((Collection<GOperator>)gSet, this.eqFactory)));
        MonitorAutomaton monitor = this.configuration.computeAcceptance() ? MonitorBuilder.create(gOperator, operand, relevantGSets, this.vsFactory, this.configuration.eager()) : MonitorBuilderNoAcceptance.create(gOperator, operand, relevantGSets, this.vsFactory, this.configuration.eager());
        logger.log(Level.FINER, () -> String.format("Monitor for %s:%n%s", gOperator, HoaPrinter.toString(monitor)));
        if (logger.isLoggable(Level.FINEST)) {
            monitor.getAutomata().forEach((set, automaton) -> logger.log(Level.FINEST, "For set {0}\n{1}", new Object[]{set, HoaPrinter.toString(automaton)}));
        }
        return monitor;
    }

    private void createEdges(RabinizerState state, Map<RabinizerProductEdge, ValuationSet> successors, MutableAutomaton<RabinizerState, ?> rabinizerAutomaton) {
        rabinizerAutomaton.addState(state);
        BitSet sensitiveAlphabet = this.productStateFactory.getSensitiveAlphabet(state);
        successors.forEach((cache, valuations) -> {
            RabinizerState rabinizerSuccessor = cache.getRabinizerSuccessor();
            ValuationSet[] acceptanceCache = cache.getSuccessorAcceptance();
            valuations.forEach(sensitiveAlphabet, valuation -> {
                int acceptanceIndices = acceptanceCache.length;
                BitSet edgeAcceptanceSet = new BitSet(acceptanceIndices);
                for (int acceptanceIndex = 0; acceptanceIndex < acceptanceIndices; ++acceptanceIndex) {
                    ValuationSet acceptanceValuations = acceptanceCache[acceptanceIndex];
                    if (acceptanceValuations == null || !acceptanceValuations.contains((BitSet)valuation)) continue;
                    edgeAcceptanceSet.set(acceptanceIndex);
                }
                Edge<RabinizerState> rabinizerEdge = Edge.of(rabinizerSuccessor, edgeAcceptanceSet);
                ValuationSet edgeValuation = this.vsFactory.of((BitSet)valuation, sensitiveAlphabet);
                rabinizerAutomaton.addEdge(state, edgeValuation, rabinizerEdge);
            });
        });
    }

    private Map<RabinizerState, Map<RabinizerProductEdge, ValuationSet>> exploreTransitionSystem(Set<EquivalenceClass> stateSubset, Automaton<EquivalenceClass, ?> masterAutomaton, MonitorAutomaton[] monitors) {
        int relevantFormulaCount = monitors.length;
        EquivalenceClass masterInitialState = stateSubset.iterator().next();
        MonitorState[] monitorInitialStates = new MonitorState[relevantFormulaCount];
        Arrays.setAll(monitorInitialStates, i -> (MonitorState)monitors[i].onlyInitialState());
        RabinizerState initialState = RabinizerState.of(masterInitialState, monitorInitialStates);
        HashMap<RabinizerState, Map<RabinizerProductEdge, ValuationSet>> transitionSystem = new HashMap<RabinizerState, Map<RabinizerProductEdge, ValuationSet>>();
        HashSet exploredStates = Sets.newHashSet((Object[])new RabinizerState[]{initialState});
        ArrayDeque<RabinizerState> workQueue = new ArrayDeque<RabinizerState>(exploredStates);
        while (!workQueue.isEmpty()) {
            RabinizerState currentState = (RabinizerState)workQueue.remove();
            logger.log(Level.FINEST, "Exploring {0}", currentState);
            assert (currentState.monitorStates().size() == relevantFormulaCount);
            assert (!transitionSystem.containsKey(currentState));
            EquivalenceClass masterState = currentState.masterState();
            List<MonitorState> monitorStates = currentState.monitorStates();
            Set<EquivalenceClass> masterSuccessors = masterAutomaton.successors(masterState);
            if (masterSuccessors.isEmpty()) {
                transitionSystem.put(currentState, Map.of());
                continue;
            }
            HashMap<RabinizerProductEdge, ValuationSet> rabinizerSuccessors = new HashMap<RabinizerProductEdge, ValuationSet>();
            transitionSystem.put(currentState, rabinizerSuccessors);
            MonitorState[][] monitorSuccessorMatrix = new MonitorState[relevantFormulaCount][];
            ValuationSet[][] monitorValuationMatrix = new ValuationSet[relevantFormulaCount][];
            int[] successorCounts = new int[relevantFormulaCount];
            for (int monitorIndex = 0; monitorIndex < relevantFormulaCount; ++monitorIndex) {
                MonitorState monitorState = monitorStates.get(monitorIndex);
                HashMap successors = new HashMap();
                monitors[monitorIndex].forEachLabelledEdge(monitorState, (edge, valuations) -> successors.merge((MonitorState)edge.successor(), valuations, ValuationSet::union));
                int monitorSuccessorCount = successors.size();
                successorCounts[monitorIndex] = monitorSuccessorCount - 1;
                MonitorState[] successorStates = new MonitorState[monitorSuccessorCount];
                ValuationSet[] successorValuations = new ValuationSet[monitorSuccessorCount];
                Indices.forEachIndexed(successors.entrySet(), (successorIndex, entry) -> {
                    successorStates[successorIndex] = (MonitorState)entry.getKey();
                    successorValuations[successorIndex] = (ValuationSet)entry.getValue();
                });
                monitorSuccessorMatrix[monitorIndex] = successorStates;
                monitorValuationMatrix[monitorIndex] = successorValuations;
            }
            BitSet sensitiveAlphabet = this.productStateFactory.getSensitiveAlphabet(currentState);
            long powerSetSize = 1L << sensitiveAlphabet.size() + 2;
            long totalSuccessorCounts = (long)masterSuccessors.size() * NatCartesianProductSet.numberOfElements((int[])successorCounts);
            if (totalSuccessorCounts > 1L << (int)(powerSetSize + 2L)) {
                for (BitSet valuation : BitSets.powerSet((BitSet)sensitiveAlphabet)) {
                    EquivalenceClass masterSuccessor;
                    Edge<EquivalenceClass> masterEdge = masterAutomaton.edge(masterState, valuation);
                    if (masterEdge == null || !stateSubset.contains(masterSuccessor = masterEdge.successor())) continue;
                    MonitorState[] monitorSuccessors = new MonitorState[monitorStates.size()];
                    Arrays.setAll(monitorSuccessors, relevantIndex -> {
                        MonitorState currentMonitorState = (MonitorState)monitorStates.get(relevantIndex);
                        MonitorAutomaton monitor = monitors[relevantIndex];
                        return monitor.successor(currentMonitorState, valuation);
                    });
                    RabinizerState rabinizerSuccessor = RabinizerState.of(masterSuccessor, monitorSuccessors);
                    rabinizerSuccessors.merge(new RabinizerProductEdge(rabinizerSuccessor), this.vsFactory.of(valuation, sensitiveAlphabet), ValuationSet::union);
                    if (!exploredStates.add(rabinizerSuccessor)) continue;
                    workQueue.add(rabinizerSuccessor);
                }
                continue;
            }
            masterAutomaton.forEachLabelledEdge(masterState, (edge, valuationSet) -> {
                if (!stateSubset.contains(edge.successor())) {
                    return;
                }
                NatCartesianProductIterator productIterator = new NatCartesianProductIterator(successorCounts);
                block0: while (productIterator.hasNext()) {
                    int[] successorSelection = productIterator.next();
                    ValuationSet productValuation = valuationSet;
                    MonitorState[] monitorSuccessors = new MonitorState[monitorStates.size()];
                    for (int monitorIndex = 0; monitorIndex < relevantFormulaCount; ++monitorIndex) {
                        MonitorState currentMonitorState = (MonitorState)monitorStates.get(monitorIndex);
                        assert (currentMonitorState != null);
                        int monitorMatrixIndex = successorSelection[monitorIndex];
                        monitorSuccessors[monitorIndex] = monitorSuccessorMatrix[monitorIndex][monitorMatrixIndex];
                        ValuationSet monitorSuccessorValuation = monitorValuationMatrix[monitorIndex][monitorMatrixIndex];
                        if ((productValuation = productValuation.intersection(monitorSuccessorValuation)).isEmpty()) continue block0;
                    }
                    RabinizerState successor = RabinizerState.of((EquivalenceClass)edge.successor(), monitorSuccessors);
                    rabinizerSuccessors.merge(new RabinizerProductEdge(successor), productValuation, ValuationSet::union);
                    if (!exploredStates.add(successor)) continue;
                    workQueue.add(successor);
                }
            });
        }
        return transitionSystem;
    }

    private Set<GOperator> relevantSubFormulas(EquivalenceClass equivalenceClass) {
        return this.configuration.supportBasedRelevantFormulaAnalysis() ? RabinizerUtil.getSupportSubFormulas(equivalenceClass) : RabinizerUtil.getRelevantSubFormulas(equivalenceClass);
    }

    private /* synthetic */ void lambda$build$12(Multimap statesPerClass, Function getAnyState, MutableAutomaton rabinizerAutomaton, EquivalenceClass masterState, Map masterSuccessors) {
        assert (!masterSuccessors.isEmpty());
        Collection rabinizerStates = statesPerClass.get((Object)masterState);
        masterSuccessors.forEach((masterSuccessor, valuations) -> {
            assert (this.configuration.completeAutomaton() || !masterSuccessor.isFalse());
            Edge<RabinizerState> edge = Edge.of((RabinizerState)getAnyState.apply(masterSuccessor));
            for (RabinizerState state : rabinizerStates) {
                rabinizerAutomaton.addState(state);
                rabinizerAutomaton.addEdge(state, (ValuationSet)valuations, edge);
            }
        });
    }

    private static /* synthetic */ RabinizerState lambda$build$10(MasterStatePartition masterSccPartition, Multimap statesPerClass, EquivalenceClass masterState) {
        return masterSccPartition.transientStates.contains(masterState) ? RabinizerState.empty(masterState) : (RabinizerState)statesPerClass.get((Object)masterState).iterator().next();
    }

    private static /* synthetic */ void lambda$build$9(Multimap statesPerClass, EquivalenceClass state) {
        statesPerClass.put((Object)state, (Object)RabinizerState.empty(state));
    }

    private /* synthetic */ void lambda$build$8(boolean[] relevantFormulas, ActiveSet[] activeSets, MonitorAutomaton[] sccMonitors, Multimap statesPerClass, MutableAutomaton rabinizerAutomaton, RabinizerState state, Map successors) {
        Set<GOperator> stateRelevantSubFormulas = this.relevantSubFormulas(state.masterState());
        logger.log(Level.FINEST, "Product transitions for {0}: {1}; relevant formulas: {2}", new Object[]{state, successors, stateRelevantSubFormulas});
        BitSet sensitiveAlphabet = this.productStateFactory.getSensitiveAlphabet(state);
        PowerSetIterator activeSubFormulasIterator = new PowerSetIterator(relevantFormulas);
        boolean[] empty = activeSubFormulasIterator.next();
        assert (Booleans.countTrue((boolean[])empty) == 0);
        while (activeSubFormulasIterator.hasNext()) {
            boolean[] activeSubFormulas = activeSubFormulasIterator.next();
            ActiveSet activeSet = activeSets[activeSubFormulasIterator.currentIndex() - 1];
            GSet activeSubFormulasSet = activeSet.set;
            ValuationSet[][] monitorPriorities = RabinizerBuilder.computeMonitorPriorities(sccMonitors, state.monitorStates(), activeSubFormulasSet);
            Iterator<int[]> rankingIterator = activeSet.rankings.iterator();
            int rankingIndex = -1;
            while (rankingIterator.hasNext()) {
                ++rankingIndex;
                int[] ranking = rankingIterator.next();
                assert (ranking.length == Booleans.countTrue((boolean[])activeSubFormulas));
                GeneralizedRabinAcceptance.RabinPair pair = activeSet.getPairForRanking(rankingIndex);
                GSetRanking rankingPair = new GSetRanking(relevantFormulas, activeSubFormulas, activeSubFormulasSet, pair, ranking, this.eqFactory, monitorPriorities);
                if (!this.configuration.eager() && !rankingPair.monitorsEntail(state)) {
                    int finiteIndex = pair.finSet();
                    successors.forEach((transition, valuations) -> transition.addAcceptance((ValuationSet)valuations, finiteIndex));
                    continue;
                }
                successors.forEach((transition, valuations) -> valuations.forEach(sensitiveAlphabet, valuation -> {
                    ValuationSet edgeValuation = this.vsFactory.of((BitSet)valuation, sensitiveAlphabet);
                    if (this.configuration.eager() && !rankingPair.monitorsEntailEager(state, (BitSet)valuation)) {
                        transition.addAcceptance(edgeValuation, pair.finSet());
                    } else {
                        IntSet edgeAcceptance = rankingPair.getAcceptance((BitSet)valuation);
                        transition.addAcceptance(edgeValuation, edgeAcceptance);
                    }
                }));
            }
        }
        statesPerClass.put((Object)state.masterState(), (Object)state);
        this.createEdges(state, successors, rabinizerAutomaton);
        successors.clear();
    }

    private /* synthetic */ void lambda$build$4(Multimap statesPerClass, MutableAutomaton rabinizerAutomaton, RabinizerState state, Map successors) {
        statesPerClass.put((Object)state.masterState(), (Object)state);
        this.createEdges(state, successors, rabinizerAutomaton);
    }

    static final class EvaluateVisitor
    extends Converter {
        private final EquivalenceClass environment;
        private final EquivalenceClassFactory factory;

        EvaluateVisitor(Collection<GOperator> gMonitors, EquivalenceClass label) {
            super(SyntacticFragment.FGMU.classes());
            this.factory = label.factory();
            this.environment = label.and(this.factory.of(Conjunction.of(Stream.concat(gMonitors.stream(), gMonitors.stream().map(x -> x.operand)))));
        }

        private boolean isImplied(Formula formula) {
            return this.environment.implies(this.factory.of(formula));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (this.isImplied(disjunction)) {
                return BooleanConstant.TRUE;
            }
            return Disjunction.of(disjunction.map(e -> e.accept(this)));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            if (this.isImplied(fOperator)) {
                return BooleanConstant.TRUE;
            }
            return FOperator.of(fOperator.operand.accept(this));
        }

        @Override
        public Formula visit(GOperator gOperator) {
            if (this.isImplied(gOperator)) {
                return BooleanConstant.TRUE;
            }
            return BooleanConstant.of(BooleanConstant.TRUE == gOperator.operand.accept(this));
        }

        @Override
        public Formula visit(Literal literal) {
            return this.isImplied(literal) ? BooleanConstant.TRUE : literal;
        }

        @Override
        public Formula visit(MOperator mOperator) {
            if (this.isImplied(mOperator)) {
                return BooleanConstant.TRUE;
            }
            return MOperator.of(mOperator.left.accept(this), mOperator.right.accept(this));
        }

        @Override
        public Formula visit(UOperator uOperator) {
            if (this.isImplied(uOperator)) {
                return BooleanConstant.TRUE;
            }
            return UOperator.of(uOperator.left.accept(this), uOperator.right.accept(this));
        }

        @Override
        public Formula visit(XOperator xOperator) {
            if (this.isImplied(xOperator)) {
                return BooleanConstant.TRUE;
            }
            return XOperator.of(xOperator.operand.accept(this));
        }
    }

    private static final class GSetRanking {
        final GSet activeFormulaSet;
        final GeneralizedRabinAcceptance.RabinPair pair;
        final int[] ranking;
        private final boolean[] activeFormulas;
        private final EquivalenceClassFactory eqFactory;
        private final ValuationSet[][] monitorPriorities;
        private final boolean[] relevantFormulas;

        GSetRanking(boolean[] relevantFormulas, boolean[] activeFormulas, GSet activeFormulaSet, GeneralizedRabinAcceptance.RabinPair pair, int[] ranking, EquivalenceClassFactory eqFactory, ValuationSet[][] monitorPriorities) {
            assert (activeFormulas.length == relevantFormulas.length);
            this.activeFormulaSet = activeFormulaSet;
            this.pair = pair;
            this.ranking = ranking;
            this.eqFactory = eqFactory;
            this.monitorPriorities = monitorPriorities;
            this.activeFormulas = activeFormulas;
            this.relevantFormulas = relevantFormulas;
        }

        private void forEachRelevantAndActive(IntBiConsumer action) {
            int relevantIndex = -1;
            int activeIndex = -1;
            for (int gIndex = 0; gIndex < this.activeFormulas.length; ++gIndex) {
                if (!this.relevantFormulas[gIndex]) continue;
                ++relevantIndex;
                if (!this.activeFormulas[gIndex]) continue;
                action.accept(relevantIndex, ++activeIndex);
            }
        }

        IntSet getAcceptance(BitSet valuation) {
            IntOpenHashSet edgeAcceptanceSet = null;
            int relevantIndex = -1;
            int activeIndex = -1;
            for (int gIndex = 0; gIndex < this.activeFormulas.length; ++gIndex) {
                if (!this.relevantFormulas[gIndex]) continue;
                ++relevantIndex;
                if (!this.activeFormulas[gIndex]) continue;
                ++activeIndex;
                int priority = -1;
                ValuationSet[] monitorEdgePriorities = this.monitorPriorities[relevantIndex];
                for (int i = 0; i < monitorEdgePriorities.length; ++i) {
                    ValuationSet priorityValuation = monitorEdgePriorities[i];
                    if (priorityValuation == null || !priorityValuation.contains(valuation)) continue;
                    priority = i;
                    break;
                }
                if (priority == -1) continue;
                if (priority == 0) {
                    return IntSets.singleton((int)this.pair.finSet());
                }
                int succeedPriority = 2 * this.ranking[activeIndex] + 1;
                if (priority > succeedPriority) continue;
                if (priority % 2 == 0) {
                    return IntSets.singleton((int)this.pair.finSet());
                }
                if (priority != succeedPriority) continue;
                if (edgeAcceptanceSet == null) {
                    edgeAcceptanceSet = new IntOpenHashSet();
                }
                edgeAcceptanceSet.add(this.pair.infSet(activeIndex));
            }
            return edgeAcceptanceSet == null ? IntSets.EMPTY_SET : edgeAcceptanceSet;
        }

        boolean monitorsEntail(RabinizerState state) {
            return this.monitorsEntail(state.monitorStates(), null, state.masterState());
        }

        private boolean monitorsEntail(List<MonitorState> monitorStates, @Nullable BitSet valuation, EquivalenceClass consequent) {
            boolean eager = valuation != null;
            AtomicReference<EquivalenceClass> antecedent = new AtomicReference<EquivalenceClass>(this.eqFactory.getTrue());
            this.forEachRelevantAndActive((relevantIndex, activeIndex) -> {
                int rank;
                MonitorState monitorState = (MonitorState)monitorStates.get(relevantIndex);
                List<EquivalenceClass> monitorStateRanking = monitorState.formulaRanking();
                for (int stateIndex = rank = this.ranking[activeIndex]; stateIndex < monitorStateRanking.size(); ++stateIndex) {
                    EquivalenceClass rankEntry = monitorStateRanking.get(stateIndex);
                    EquivalenceClass state = eager ? rankEntry.temporalStep(valuation) : rankEntry;
                    antecedent.updateAndGet(clazz -> clazz.and(state));
                }
            });
            if (eager) {
                antecedent.updateAndGet(clazz -> clazz.and(this.activeFormulaSet.operatorConjunction()));
            }
            Function<Formula, Formula> strengthening = formula -> formula instanceof GOperator ? BooleanConstant.of(this.activeFormulaSet.contains(formula)) : formula;
            EquivalenceClass strengthenedAntecedent = antecedent.get().substitute(strengthening);
            Function<Formula, Formula> weakening = formula -> formula instanceof GOperator && this.activeFormulaSet.contains(formula) ? BooleanConstant.TRUE : formula;
            EquivalenceClass testedConsequent = eager ? consequent.temporalStep(valuation) : consequent;
            EquivalenceClass weakenedConsequent = testedConsequent.substitute(weakening);
            boolean result = strengthenedAntecedent.implies(weakenedConsequent);
            if (logger.isLoggable(Level.FINEST)) {
                ArrayList activeMonitorStates = new ArrayList(this.activeFormulaSet.size());
                this.forEachRelevantAndActive((relevantIndex, activeIndex) -> {
                    int rank = this.ranking[activeIndex];
                    List<EquivalenceClass> monitorStateRanking = ((MonitorState)monitorStates.get(relevantIndex)).formulaRanking();
                    int size = monitorStateRanking.size();
                    if (rank <= size) {
                        activeMonitorStates.addAll(monitorStateRanking.subList(rank, size));
                    }
                });
                String rankingString = RabinizerUtil.printRanking(this.ranking);
                String log = String.format("Subset %s, ranking %s, and monitor states %s (strengthened: %s), valuation %s; entails %s (weakened: %s): %s", this.activeFormulaSet, rankingString, activeMonitorStates, strengthenedAntecedent, valuation, consequent, weakenedConsequent, result);
                logger.log(Level.FINEST, log);
            }
            return result;
        }

        boolean monitorsEntailEager(RabinizerState state, BitSet valuation) {
            return this.monitorsEntail(state.monitorStates(), valuation, state.masterState());
        }
    }

    private static final class ActiveSet {
        final GSet set;
        final Set<int[]> rankings;
        private final GeneralizedRabinAcceptance.RabinPair[] rankingPairs;

        ActiveSet(GSet set, Set<int[]> rankings, GeneralizedRabinAcceptance.RabinPair[] rankingPairs) {
            this.set = set;
            this.rankings = rankings;
            this.rankingPairs = rankingPairs;
        }

        static ActiveSet create(GOperator[] operators, GSet subset, MonitorAutomaton[] monitors, GeneralizedRabinAcceptance.Builder builder) {
            int gCount = operators.length;
            int[] maximalRanks = new int[subset.size()];
            int relevantIndex = 0;
            for (int gIndex = 0; gIndex < gCount; ++gIndex) {
                if (!subset.contains(operators[gIndex])) continue;
                MonitorAutomaton monitor = monitors[gIndex];
                Automaton<MonitorState, ParityAcceptance> gSetMonitor = monitor.getAutomaton(subset);
                int acceptanceSets = gSetMonitor.acceptance().acceptanceSets();
                maximalRanks[relevantIndex] = acceptanceSets == 0 ? 0 : (acceptanceSets - 1) / 2;
                ++relevantIndex;
            }
            NatCartesianProductSet rankings = new NatCartesianProductSet(maximalRanks);
            GeneralizedRabinAcceptance.RabinPair[] rankingPairs = new GeneralizedRabinAcceptance.RabinPair[rankings.size()];
            Arrays.setAll(rankingPairs, i -> builder.add(subset.size()));
            return new ActiveSet(subset, (Set<int[]>)rankings, rankingPairs);
        }

        GeneralizedRabinAcceptance.RabinPair getPairForRanking(int rankingIndex) {
            return this.rankingPairs[rankingIndex];
        }
    }
}

