/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.set.AbstractNatBitSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

class SimpleNatBitSet
extends AbstractNatBitSet {
    private final BitSet bitSet;

    SimpleNatBitSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    @Override
    public void and(IntCollection indices) {
        if (indices instanceof SimpleNatBitSet) {
            SimpleNatBitSet other = (SimpleNatBitSet)indices;
            this.bitSet.and(other.bitSet);
        } else {
            super.and(indices);
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        if (indices instanceof SimpleNatBitSet) {
            SimpleNatBitSet other = (SimpleNatBitSet)indices;
            this.bitSet.andNot(other.bitSet);
        } else {
            super.andNot(indices);
        }
    }

    @Override
    public void clear(int index) {
        this.bitSet.clear(index);
    }

    @Override
    public void clear(int from, int to) {
        this.bitSet.clear(from, to);
    }

    public void clear() {
        this.bitSet.clear();
    }

    @Override
    public SimpleNatBitSet clone() {
        return new SimpleNatBitSet((BitSet)this.bitSet.clone());
    }

    public boolean contains(int index) {
        return 0 <= index && this.bitSet.get(index);
    }

    public boolean containsAll(IntCollection indices) {
        if (indices instanceof SimpleNatBitSet) {
            SimpleNatBitSet other = (SimpleNatBitSet)indices;
            BitSet clone = (BitSet)other.bitSet.clone();
            clone.andNot(this.bitSet);
            return clone.isEmpty();
        }
        return super.containsAll(indices);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleNatBitSet) {
            SimpleNatBitSet other = (SimpleNatBitSet)o;
            return this.bitSet.equals(other.bitSet);
        }
        return super.equals(o);
    }

    @Override
    public void flip(int index) {
        this.bitSet.flip(index);
    }

    @Override
    public void flip(int from, int to) {
        this.bitSet.flip(from, to);
    }

    public void forEach(IntConsumer consumer) {
        BitSets.forEach(this.bitSet, consumer);
    }

    BitSet getBitSet() {
        return this.bitSet;
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    @Override
    public IntStream intStream() {
        return this.bitSet.stream();
    }

    @Override
    public boolean intersects(IntCollection indices) {
        if (indices instanceof SimpleNatBitSet) {
            SimpleNatBitSet other = (SimpleNatBitSet)indices;
            return this.bitSet.intersects(other.bitSet);
        }
        return super.intersects(indices);
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return BitSets.iterator(this.bitSet);
    }

    @Override
    public int lastInt() {
        int lastSet = this.bitSet.length() - 1;
        if (lastSet == -1) {
            throw new NoSuchElementException();
        }
        return lastSet;
    }

    @Override
    public int nextAbsentIndex(int index) {
        return this.bitSet.nextClearBit(index);
    }

    @Override
    public int nextPresentIndex(int index) {
        return this.bitSet.nextSetBit(index);
    }

    @Override
    public void or(IntCollection indices) {
        if (indices instanceof SimpleNatBitSet) {
            SimpleNatBitSet other = (SimpleNatBitSet)indices;
            this.bitSet.or(other.bitSet);
        } else {
            super.or(indices);
        }
    }

    @Override
    public int previousAbsentIndex(int index) {
        return this.bitSet.previousClearBit(index);
    }

    @Override
    public int previousPresentIndex(int index) {
        return this.bitSet.previousSetBit(index);
    }

    @Override
    public void set(int i) {
        this.bitSet.set(i);
    }

    @Override
    public void set(int index, boolean value) {
        this.bitSet.set(index, value);
    }

    @Override
    public void set(int from, int to) {
        this.bitSet.set(from, to);
    }

    public int size() {
        return this.bitSet.cardinality();
    }

    @Override
    public void xor(IntCollection indices) {
        if (indices instanceof SimpleNatBitSet) {
            SimpleNatBitSet other = (SimpleNatBitSet)indices;
            this.bitSet.xor(other.bitSet);
        } else {
            super.xor(indices);
        }
    }
}

