/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import owl.automaton.Automaton;
import owl.automaton.edge.Edge;

@FunctionalInterface
public interface SuccessorFunction<S>
extends Function<S, Collection<S>> {
    @Override
    default public Collection<S> apply(S s) {
        return this.successors(s);
    }

    public Collection<S> successors(S var1);

    public static <S> SuccessorFunction<S> filter(Automaton<S, ?> automaton, Set<S> states) {
        return SuccessorFunction.filter(automaton, states, e -> true);
    }

    public static <S> SuccessorFunction<S> filter(Automaton<S, ?> automaton, Set<S> states, Predicate<Edge<S>> edgeFilter) {
        return state -> {
            if (!states.contains(state)) {
                return List.of();
            }
            ArrayList successors = new ArrayList();
            automaton.edges(state).forEach(edge -> {
                if (edgeFilter.test((Edge)edge) && states.contains(edge.successor())) {
                    successors.add(edge.successor());
                }
            });
            return successors;
        };
    }
}

