/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import it.unimi.dsi.fastutil.ints.IntIterators;
import java.io.Serializable;
import java.util.Objects;
import java.util.PrimitiveIterator;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.Immutable;
import owl.automaton.edge.Edge;

@Immutable
final class EdgeSingleton<S>
extends Edge<S> {
    private static final int EMPTY_ACCEPTANCE = -1;
    private final int acceptance;

    EdgeSingleton(S successor) {
        super(successor);
        this.acceptance = -1;
    }

    EdgeSingleton(S successor, @Nonnegative int acceptance) {
        super(successor);
        Objects.checkIndex(acceptance, Integer.MAX_VALUE);
        this.acceptance = acceptance;
    }

    @Override
    public PrimitiveIterator.OfInt acceptanceSetIterator() {
        return this.hasAcceptanceSets() ? IntIterators.singleton((int)this.acceptance) : IntIterators.EMPTY_ITERATOR;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeSingleton)) {
            return false;
        }
        EdgeSingleton other = (EdgeSingleton)o;
        return this.acceptance == other.acceptance && this.successor.equals(other.successor);
    }

    @Override
    public boolean hasAcceptanceSets() {
        return this.acceptance != -1;
    }

    public int hashCode() {
        return 31 * (31 + this.successor.hashCode()) + this.acceptance;
    }

    @Override
    public boolean inSet(@Nonnegative int i) {
        Objects.checkIndex(i, Integer.MAX_VALUE);
        return i == this.acceptance;
    }

    @Override
    public int largestAcceptanceSet() {
        return this.hasAcceptanceSets() ? this.acceptance : -1;
    }

    @Override
    public int smallestAcceptanceSet() {
        return this.hasAcceptanceSets() ? this.acceptance : Integer.MAX_VALUE;
    }

    @Override
    public String toString() {
        return "-> " + this.successor + " {" + (Serializable)(this.hasAcceptanceSets() ? Integer.valueOf(this.acceptance) : "") + "}";
    }

    @Override
    public Edge<S> withAcceptance(int acceptance) {
        Objects.checkIndex(acceptance, Integer.MAX_VALUE);
        return this.acceptance == acceptance ? this : new EdgeSingleton<Object>(this.successor, acceptance);
    }

    @Override
    public Edge<S> withoutAcceptance() {
        return this.hasAcceptanceSets() ? new EdgeSingleton<Object>(this.successor) : this;
    }

    @Override
    public <T> EdgeSingleton<T> withSuccessor(T successor) {
        return this.hasAcceptanceSets() ? new EdgeSingleton<T>(successor, this.acceptance) : new EdgeSingleton<T>(successor);
    }
}

