/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import owl.ltl.BooleanConstant;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.PropositionalFormula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;
import owl.util.annotation.CEntryPoint;

public final class Conjunction
extends PropositionalFormula {
    private Conjunction(Formula[] conjuncts) {
        super(Conjunction.class, Set.of(conjuncts));
    }

    @CEntryPoint
    public static Formula of(Formula left, Formula right) {
        return Conjunction.of(Arrays.asList(left, right));
    }

    public static Formula of(Formula ... formulas) {
        return Conjunction.of(Arrays.asList(formulas));
    }

    public static Formula of(Iterable<? extends Formula> iterable) {
        return Conjunction.of(iterable.iterator());
    }

    public static Formula of(Stream<? extends Formula> stream) {
        return Conjunction.of(stream.iterator());
    }

    public static Formula of(Iterator<? extends Formula> iterator) {
        HashSet<Formula> set = new HashSet<Formula>();
        while (iterator.hasNext()) {
            Formula child = iterator.next();
            assert (child != null);
            if (BooleanConstant.FALSE.equals(child)) {
                return BooleanConstant.FALSE;
            }
            if (BooleanConstant.TRUE.equals(child)) continue;
            if (child instanceof Conjunction) {
                set.addAll(((Conjunction)child).children);
                continue;
            }
            set.add(child);
        }
        if (set.isEmpty()) {
            return BooleanConstant.TRUE;
        }
        if (set.size() == 1) {
            return (Formula)set.iterator().next();
        }
        return new Conjunction((Formula[])set.toArray(Formula[]::new));
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public Formula nnf() {
        return Conjunction.of(this.map(Formula::nnf));
    }

    @Override
    public Formula not() {
        return Disjunction.of(this.map(Formula::not));
    }

    @Override
    public Formula substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
        return Conjunction.of(this.map(c -> c.substitute(substitution)));
    }

    @Override
    protected String operatorSymbol() {
        return "&";
    }
}

