/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.collections.Collections3;
import owl.collections.UpwardClosedSet;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.PropositionalFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.PropositionalVisitor;

public final class NormalForms {
    public static final Function<PropositionalFormula, Set<Formula>> SYNTHETIC_CO_SAFETY_LITERAL = x -> x.children.stream().filter(SyntacticFragment.CO_SAFETY::contains).collect(Collectors.toSet());
    public static final Function<PropositionalFormula, Set<Formula>> SYNTHETIC_SAFETY_LITERAL = x -> x.children.stream().filter(SyntacticFragment.SAFETY::contains).collect(Collectors.toSet());

    private NormalForms() {
    }

    public static Formula toCnfFormula(Formula formula) {
        return NormalForms.toCnf(formula).stream().map(Disjunction::of).reduce(BooleanConstant.TRUE, Conjunction::of);
    }

    public static Set<Set<Formula>> toCnf(Formula formula) {
        return NormalForms.toCnf(formula, x -> Set.of());
    }

    public static Set<Set<Formula>> toCnf(Formula formula, Function<? super Formula, ? extends Collection<Formula>> syntheticLiteralFactory) {
        ConjunctiveNormalFormVisitor visitor = new ConjunctiveNormalFormVisitor(syntheticLiteralFactory);
        List<BitSet> cnf = formula.accept(visitor).representatives();
        return new ClausesView(cnf, visitor.literals());
    }

    public static Formula toDnfFormula(Formula formula) {
        return NormalForms.toDnf(formula).stream().map(Conjunction::of).reduce(BooleanConstant.FALSE, Disjunction::of);
    }

    public static Set<Set<Formula>> toDnf(Formula formula) {
        return NormalForms.toDnf(formula, x -> Set.of());
    }

    public static Set<Set<Formula>> toDnf(Formula formula, Function<? super PropositionalFormula, ? extends Collection<Formula>> syntheticLiteralFactory) {
        DisjunctiveNormalFormVisitor visitor = new DisjunctiveNormalFormVisitor(syntheticLiteralFactory);
        List<BitSet> dnf = formula.accept(visitor).representatives();
        return new ClausesView(dnf, visitor.literals());
    }

    private static final class ClausesView
    extends AbstractSet<Set<Formula>> {
        private final List<BitSet> clauses;
        private final List<Formula> literals;

        private ClausesView(List<BitSet> clauses, List<Formula> literals) {
            this.clauses = clauses;
            this.literals = List.copyOf(literals);
            assert (Collections3.isDistinct(this.clauses));
        }

        @Override
        public Iterator<Set<Formula>> iterator() {
            return new Iterator<Set<Formula>>(){
                Iterator<BitSet> internalIterator;
                {
                    this.internalIterator = clauses.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.internalIterator.hasNext();
                }

                @Override
                public Set<Formula> next() {
                    return new ClauseView(this.internalIterator.next());
                }

                @Override
                public void remove() {
                    this.internalIterator.remove();
                }

                @Override
                public void forEachRemaining(Consumer<? super Set<Formula>> action) {
                    this.internalIterator.forEachRemaining((? super E element) -> action.accept(new ClauseView((BitSet)element)));
                }
            };
        }

        @Override
        public int size() {
            return this.clauses.size();
        }

        @Override
        public Stream<Set<Formula>> stream() {
            return this.clauses.stream().map(x$0 -> new ClauseView((BitSet)x$0));
        }

        private final class ClauseView
        extends AbstractSet<Formula> {
            private final BitSet clause;

            private ClauseView(BitSet clause) {
                this.clause = clause;
            }

            @Override
            public Iterator<Formula> iterator() {
                return this.stream().iterator();
            }

            @Override
            public int size() {
                return this.clause.cardinality();
            }

            @Override
            public Stream<Formula> stream() {
                return this.clause.stream().mapToObj(ClausesView.this.literals::get);
            }
        }
    }

    private static final class DisjunctiveNormalFormVisitor
    extends AbstractNormalFormVisitor {
        private DisjunctiveNormalFormVisitor(Function<? super PropositionalFormula, ? extends Collection<Formula>> syntheticLiteralFactory) {
            super(syntheticLiteralFactory);
        }

        @Override
        public UpwardClosedSet visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? UpwardClosedSet.of(new BitSet()) : UpwardClosedSet.of();
        }

        @Override
        public UpwardClosedSet visit(Conjunction conjunction) {
            Collection syntheticLiteral = (Collection)this.syntheticLiteralFactory.apply(conjunction);
            UpwardClosedSet set = syntheticLiteral.isEmpty() ? UpwardClosedSet.of(new BitSet()) : this.singleton(Conjunction.of(syntheticLiteral));
            for (Formula x : conjunction.children) {
                if (syntheticLiteral.contains(x)) continue;
                set = set.intersection(x.accept(this));
            }
            return set;
        }

        @Override
        public UpwardClosedSet visit(Disjunction disjunction) {
            Collection syntheticLiteral = (Collection)this.syntheticLiteralFactory.apply(disjunction);
            UpwardClosedSet set = syntheticLiteral.isEmpty() ? UpwardClosedSet.of() : this.singleton(Disjunction.of(syntheticLiteral));
            for (Formula x : disjunction.children) {
                if (syntheticLiteral.contains(x)) continue;
                set = set.union(x.accept(this));
            }
            return set;
        }
    }

    private static final class ConjunctiveNormalFormVisitor
    extends AbstractNormalFormVisitor {
        private ConjunctiveNormalFormVisitor(Function<? super PropositionalFormula, ? extends Collection<Formula>> syntheticLiteralFactory) {
            super(syntheticLiteralFactory);
        }

        @Override
        public UpwardClosedSet visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? UpwardClosedSet.of() : UpwardClosedSet.of(new BitSet());
        }

        @Override
        public UpwardClosedSet visit(Conjunction conjunction) {
            Collection syntheticLiteral = (Collection)this.syntheticLiteralFactory.apply(conjunction);
            UpwardClosedSet set = syntheticLiteral.isEmpty() ? UpwardClosedSet.of() : this.singleton(Conjunction.of(syntheticLiteral));
            for (Formula x : conjunction.children) {
                if (syntheticLiteral.contains(x)) continue;
                set = set.union(x.accept(this));
            }
            return set;
        }

        @Override
        public UpwardClosedSet visit(Disjunction disjunction) {
            Collection syntheticLiteral = (Collection)this.syntheticLiteralFactory.apply(disjunction);
            UpwardClosedSet set = syntheticLiteral.isEmpty() ? UpwardClosedSet.of(new BitSet()) : this.singleton(Disjunction.of(syntheticLiteral));
            for (Formula x : disjunction.children) {
                if (syntheticLiteral.contains(x)) continue;
                set = set.intersection(x.accept(this));
            }
            return set;
        }
    }

    private static abstract class AbstractNormalFormVisitor
    extends PropositionalVisitor<UpwardClosedSet> {
        final Function<? super PropositionalFormula, ? extends Collection<Formula>> syntheticLiteralFactory;
        private final Map<Formula, Integer> literals = new LinkedHashMap<Formula, Integer>();

        private AbstractNormalFormVisitor(Function<? super PropositionalFormula, ? extends Collection<Formula>> syntheticLiteralFactory) {
            this.syntheticLiteralFactory = syntheticLiteralFactory;
        }

        List<Formula> literals() {
            return new ArrayList<Formula>(this.literals.keySet());
        }

        UpwardClosedSet singleton(Formula literal) {
            BitSet bitSet = new BitSet();
            bitSet.set(this.literals.computeIfAbsent(literal, x -> this.literals.size()));
            return UpwardClosedSet.of(bitSet);
        }

        @Override
        protected UpwardClosedSet visit(Formula.TemporalOperator literal) {
            return this.singleton(literal);
        }
    }
}

