/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.run.Environment;
import owl.run.Pipeline;
import owl.run.PipelineRunner;
import owl.util.DaemonThreadFactory;

public class ServerRunner
implements Callable<Void> {
    static final Logger logger = Logger.getLogger(ServerRunner.class.getName());
    private final Supplier<Environment> environmentSupplier;
    private final InetAddress address;
    private final Pipeline execution;
    private final int port;

    public ServerRunner(Pipeline execution, Supplier<Environment> environmentConstructor, int port) {
        this.execution = execution;
        this.environmentSupplier = environmentConstructor;
        this.address = InetAddress.getLoopbackAddress();
        this.port = port;
    }

    @Override
    public Void call() {
        logger.log(Level.INFO, "Starting server on {0}:{1}", new Object[]{this.address, this.port});
        ExecutorService connectionExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory(Thread.currentThread().getThreadGroup()));
        InetSocketAddress bindAddress = new InetSocketAddress(this.address, this.port);
        try (ServerSocketChannel socket = ServerSocketChannel.open().bind(bindAddress);){
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                logger.log(Level.INFO, "Received shutdown signal, closing socket {0}", socket);
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e, () -> "Error while closing server socket " + socket);
                }
            }));
            while (socket.isOpen()) {
                try {
                    SocketChannel connection = socket.accept();
                    logger.log(Level.FINE, "New connection from {0}", socket);
                    Environment environment = this.environmentSupplier.get();
                    connectionExecutor.submit(new ConnectionHandler(connection, environment, this.execution));
                }
                catch (IOException e) {
                    if (socket.isOpen()) {
                        logger.log(Level.SEVERE, "Unexpected IO exception while waiting for connections", e);
                        continue;
                    }
                    logger.log(Level.FINE, "Server socket {0} closed, awaiting termination", socket);
                }
            }
            logger.log(Level.FINER, "Waiting for remaining tasks to finish");
            connectionExecutor.shutdown();
            while (!connectionExecutor.isTerminated()) {
                try {
                    connectionExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.log(Level.FINE, "Finished all remaining tasks");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unexpected IO exception while waiting for connections", e);
            connectionExecutor.shutdownNow();
        }
        return null;
    }

    private static final class ConnectionHandler
    implements Runnable {
        private final SocketChannel connection;
        private final Environment environment;
        private final Pipeline pipeline;

        ConnectionHandler(SocketChannel connection, Environment environment, Pipeline pipeline) {
            this.connection = connection;
            this.environment = environment;
            this.pipeline = pipeline;
        }

        @Override
        public void run() {
            try (SocketChannel socketChannel = this.connection;){
                PipelineRunner.run(this.pipeline, this.environment, this.connection, 0);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Error while handling connection", t);
                Throwables.throwIfUnchecked((Throwable)t);
            }
        }
    }
}

