/*
 * Decompiled with CFR 0.152.
 */
package owl.run.parser;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.ParseException;
import owl.run.ImmutablePipeline;
import owl.run.Pipeline;
import owl.run.modules.InputReader;
import owl.run.modules.OutputWriter;
import owl.run.modules.OwlModule;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.OwlModuleRegistry;
import owl.run.modules.Transformer;
import owl.run.parser.ParseUtil;

public final class PipelineParser {
    private PipelineParser() {
    }

    public static Pipeline parse(List<ModuleDescription> arguments, CommandLineParser parser, OwlModuleRegistry registry) throws OwlModuleRegistry.OwlModuleNotFoundException, ModuleParseException {
        Iterator<ModuleDescription> iterator = arguments.iterator();
        ImmutablePipeline.Builder pipelineSpecificationBuilder = ImmutablePipeline.builder();
        ModuleDescription readerDescription = iterator.next();
        OwlModuleParser.ReaderParser readerParser = registry.reader(readerDescription.name);
        InputReader reader = PipelineParser.parseModule(parser, readerParser, readerDescription);
        pipelineSpecificationBuilder.input(reader);
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("No output specified");
        }
        ModuleDescription currentDescription = iterator.next();
        while (iterator.hasNext()) {
            OwlModuleParser.TransformerParser transformerParser = registry.transformer(currentDescription.name);
            Transformer transformer = PipelineParser.parseModule(parser, transformerParser, currentDescription);
            pipelineSpecificationBuilder.addTransformers(transformer);
            currentDescription = iterator.next();
        }
        ModuleDescription output = currentDescription;
        OwlModuleParser.WriterParser writerParser = registry.writer(output.name);
        OutputWriter writer = PipelineParser.parseModule(parser, writerParser, currentDescription);
        pipelineSpecificationBuilder.output(writer);
        return pipelineSpecificationBuilder.build();
    }

    static List<ModuleDescription> split(List<String> arguments, Predicate<String> separator) {
        if (arguments.isEmpty()) {
            return List.of();
        }
        Iterator<String> iterator = arguments.iterator();
        if (separator.test(arguments.get(0))) {
            iterator.next();
        }
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        while (iterator.hasNext()) {
            String next;
            String moduleName = iterator.next();
            Preconditions.checkArgument((!separator.test(moduleName) ? 1 : 0) != 0, (Object)("Empty module description " + moduleName));
            ArrayList<String> moduleArguments = new ArrayList<String>();
            while (iterator.hasNext() && !separator.test(next = iterator.next())) {
                moduleArguments.add(next);
            }
            result.add(new ModuleDescription(moduleName, ParseUtil.toArray(moduleArguments)));
        }
        return result;
    }

    static <T extends OwlModule> T parseModule(CommandLineParser parser, OwlModuleParser<T> settings, ModuleDescription description) throws ModuleParseException {
        T result;
        try {
            CommandLine commandLine = parser.parse(settings.getOptions(), description.arguments);
            result = settings.parse(commandLine);
            List argList = commandLine.getArgList();
            if (!argList.isEmpty()) {
                ParseException parseException = new ParseException("Unmatched arguments " + argList);
                throw new ModuleParseException(parseException, settings);
            }
        }
        catch (ParseException e) {
            throw new ModuleParseException(e, settings);
        }
        return result;
    }

    public static class ModuleParseException
    extends Exception {
        public final OwlModuleParser<?> settings;

        public ModuleParseException(ParseException cause, OwlModuleParser<?> settings) {
            super(cause.getMessage(), cause);
            this.settings = settings;
        }

        @Override
        public ParseException getCause() {
            return (ParseException)super.getCause();
        }
    }

    static final class ModuleDescription {
        public final String name;
        public final String[] arguments;

        public ModuleDescription(String name, String[] arguments) {
            this.name = name;
            this.arguments = (String[])arguments.clone();
        }
    }
}

