/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.automaton.AbstractCachedStatesAutomaton;
import owl.automaton.EdgeTreeAutomatonMixin;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.Collections3;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.factories.ValuationSetFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.PropositionalFormula;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.NormalForms;
import owl.ltl.rewriter.SimplifierFactory;
import owl.ltl.visitors.Converter;
import owl.ltl.visitors.PropositionalVisitor;
import owl.translations.canonical.RoundRobinState;
import owl.translations.canonical.Util;

public final class NonDeterministicConstructions {
    private NonDeterministicConstructions() {
    }

    public static final class GfCoSafety
    extends Base<RoundRobinState<Formula>, GeneralizedBuchiAcceptance> {
        private final GeneralizedBuchiAcceptance acceptance;
        private final RoundRobinState<Formula> initialState;
        private final ValuationTree<Util.Pair<List<RoundRobinState<Formula>>, BitSet>> initialStatesSuccessorTree;

        /*
         * WARNING - void declaration
         */
        public GfCoSafety(Factories factories, Set<? extends Formula> formulas, boolean generalized) {
            super(factories);
            void var7_9;
            Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
            ArrayList<FOperator> automata = new ArrayList<FOperator>();
            ArrayList<Formula> singletonAutomata = new ArrayList<Formula>();
            for (Formula formula : formulas) {
                Preconditions.checkArgument((boolean)SyntacticFragments.isGfCoSafety(formula));
                Formula unwrapped = Util.unwrap(Util.unwrap(formula));
                if (generalized && SyntacticFragment.SINGLE_STEP.contains(unwrapped)) {
                    singletonAutomata.add(unwrapped);
                    continue;
                }
                automata.add(new FOperator(unwrapped));
            }
            singletonAutomata.sort(Comparator.naturalOrder());
            if (automata.isEmpty()) {
                automata.add(new FOperator((Formula)singletonAutomata.remove(0)));
            } else {
                automata.sort(Comparator.naturalOrder());
            }
            ValuationTree initialStatesSuccessorTree = ValuationTree.of(Set.of(List.of()));
            boolean bl = false;
            while (var7_9 < automata.size()) {
                void j = var7_9++;
                FOperator initialState = (FOperator)automata.get((int)j);
                ValuationTree initialStateSuccessorTree = this.successorTreeInternal(initialState, arg_0 -> GfCoSafety.lambda$new$1((int)j, arg_0));
                initialStatesSuccessorTree = ValuationTrees.cartesianProduct(initialStatesSuccessorTree, initialStateSuccessorTree, Collections3::add);
            }
            this.acceptance = GeneralizedBuchiAcceptance.of(singletonAutomata.size() + 1);
            this.initialState = RoundRobinState.of(0, (Formula)automata.get(0));
            this.initialStatesSuccessorTree = ValuationTrees.cartesianProduct(initialStatesSuccessorTree, Util.singleStepTree(singletonAutomata), (x, y) -> Util.Pair.of(List.copyOf(x), y));
        }

        @Override
        public GeneralizedBuchiAcceptance acceptance() {
            return this.acceptance;
        }

        @Override
        public Set<RoundRobinState<Formula>> initialStates() {
            return Edges.successors(this.edges(this.initialState, new BitSet()));
        }

        @Override
        public Set<Edge<RoundRobinState<Formula>>> edges(RoundRobinState<Formula> state, BitSet valuation) {
            HashSet<Edge<RoundRobinState<Formula>>> edges = new HashSet<Edge<RoundRobinState<Formula>>>();
            for (Formula leftSet : this.successorsInternal(state.state(), valuation, Function.identity())) {
                for (Util.Pair<List<RoundRobinState<Formula>>, BitSet> rightSet : this.initialStatesSuccessorTree.get(valuation)) {
                    edges.add(this.buildEdge(state.index(), leftSet, rightSet));
                }
            }
            return edges;
        }

        @Override
        public ValuationTree<Edge<RoundRobinState<Formula>>> edgeTree(RoundRobinState<Formula> state) {
            ValuationTree successorTree = this.successorTreeInternal(state.state(), Function.identity());
            return ValuationTrees.cartesianProduct(successorTree, this.initialStatesSuccessorTree, (x, y) -> this.buildEdge(state.index(), (Formula)x, (Util.Pair<List<RoundRobinState<Formula>>, BitSet>)y));
        }

        private Edge<RoundRobinState<Formula>> buildEdge(int index, Formula successor, Util.Pair<List<RoundRobinState<Formula>>, BitSet> initialStateSuccessors) {
            if (!BooleanConstant.TRUE.equals(successor)) {
                return Edge.of(RoundRobinState.of(index, successor), initialStateSuccessors.b());
            }
            int size = initialStateSuccessors.a().size();
            List<RoundRobinState<Formula>> latterSuccessors = initialStateSuccessors.a().subList(index + 1, size);
            for (RoundRobinState<Formula> initialStateSuccessor : latterSuccessors) {
                if (BooleanConstant.TRUE.equals(initialStateSuccessor.state())) continue;
                return Edge.of(initialStateSuccessor, initialStateSuccessors.b());
            }
            BitSet acceptance = (BitSet)initialStateSuccessors.b().clone();
            acceptance.set(0);
            List<RoundRobinState<Formula>> earlierSuccessors = initialStateSuccessors.a().subList(0, index + 1);
            for (RoundRobinState<Formula> initialStateSuccessor : earlierSuccessors) {
                if (BooleanConstant.TRUE.equals(initialStateSuccessor.state())) continue;
                return Edge.of(initialStateSuccessor, acceptance);
            }
            return Edge.of(this.initialState, acceptance);
        }
    }

    public static final class FgSafety
    extends Terminal<BuchiAcceptance> {
        private final FOperator initialState;
        private final ValuationTree<Formula> initialStateSuccessorTree;

        public FgSafety(Factories factories, Formula formula) {
            super(factories);
            Preconditions.checkArgument((boolean)SyntacticFragments.isFgSafety(formula));
            this.initialState = (FOperator)formula;
            this.initialStateSuccessorTree = this.successorTreeInternal(this.initialState.operand, Function.identity());
        }

        @Override
        public BuchiAcceptance acceptance() {
            return BuchiAcceptance.INSTANCE;
        }

        @Override
        public Set<Formula> initialStates() {
            return Set.of(this.initialState);
        }

        @Override
        public Set<Edge<Formula>> edges(Formula state, BitSet valuation) {
            Sets.SetView successors = this.initialState.equals(state) ? Sets.union(this.initialStateSuccessorTree.get(valuation), this.initialStates()) : this.successorsInternal(state, valuation, Function.identity());
            return this.successorToEdge((Set<Formula>)successors);
        }

        @Override
        public ValuationTree<Edge<Formula>> edgeTree(Formula state) {
            return this.initialState.equals(state) ? this.initialStateSuccessorTree.map(x -> this.successorToEdge((Set<Formula>)Sets.union((Set)x, this.initialStates()))) : this.successorTreeInternal(state, this::successorToEdge);
        }

        @Override
        protected Edge<Formula> buildEdge(Formula successor) {
            return this.initialState.equals(successor) ? Edge.of(successor) : Edge.of(successor, 0);
        }
    }

    public static final class Tracking
    extends NonLooping<NoneAcceptance> {
        public Tracking(Factories factories, Formula formula) {
            super(factories, formula);
        }

        @Override
        public NoneAcceptance acceptance() {
            return NoneAcceptance.INSTANCE;
        }

        @Override
        Edge<Formula> buildEdge(Formula clause) {
            return Edge.of(clause);
        }
    }

    public static final class Safety
    extends NonLooping<AllAcceptance> {
        public Safety(Factories factories, Formula formula) {
            super(factories, formula);
            Preconditions.checkArgument((boolean)SyntacticFragment.SAFETY.contains(formula));
        }

        @Override
        public AllAcceptance acceptance() {
            return AllAcceptance.INSTANCE;
        }

        @Override
        protected Edge<Formula> buildEdge(Formula successor) {
            return Edge.of(successor);
        }

        public Set<Formula> initialStatesWithRemainder(Formula remainder) {
            return this.toCompactDnf(Conjunction.of(this.formula, remainder));
        }
    }

    public static final class CoSafety
    extends NonLooping<BuchiAcceptance> {
        public CoSafety(Factories factories, Formula formula) {
            super(factories, formula);
            Preconditions.checkArgument((boolean)SyntacticFragment.CO_SAFETY.contains(formula));
        }

        @Override
        public BuchiAcceptance acceptance() {
            return BuchiAcceptance.INSTANCE;
        }

        @Override
        protected Edge<Formula> buildEdge(Formula successor) {
            return BooleanConstant.TRUE.equals(successor) ? Edge.of(successor, 0) : Edge.of(successor);
        }
    }

    private static abstract class NonLooping<A extends OmegaAcceptance>
    extends Terminal<A> {
        protected final Formula formula;

        private NonLooping(Factories factories, Formula formula) {
            super(factories);
            this.formula = formula;
        }

        @Override
        public final Set<Formula> initialStates() {
            return this.toCompactDnf(this.formula);
        }

        @Override
        public final Set<Edge<Formula>> edges(Formula state, BitSet valuation) {
            return this.successorsInternal(state, valuation, this::successorToEdge);
        }

        @Override
        public final ValuationTree<Edge<Formula>> edgeTree(Formula state) {
            return this.successorTreeInternal(state, this::successorToEdge);
        }
    }

    private static abstract class Terminal<A extends OmegaAcceptance>
    extends Base<Formula, A> {
        private Terminal(Factories factories) {
            super(factories);
        }

        Set<Edge<Formula>> successorToEdge(Set<Formula> successors) {
            return successors.stream().map(this::buildEdge).collect(Collectors.toUnmodifiableSet());
        }

        abstract Edge<Formula> buildEdge(Formula var1);
    }

    static abstract class Base<S, A extends OmegaAcceptance>
    extends AbstractCachedStatesAutomaton<S, A>
    implements EdgeTreeAutomatonMixin<S, A> {
        final EquivalenceClassFactory factory;
        final ValuationSetFactory valuationSetFactory;

        Base(Factories factories) {
            this.factory = factories.eqFactory;
            this.valuationSetFactory = factories.vsFactory;
        }

        @Override
        public final ValuationSetFactory factory() {
            return this.valuationSetFactory;
        }

        @Override
        public abstract Set<S> initialStates();

        @Override
        public abstract Set<Edge<S>> edges(S var1, BitSet var2);

        @Override
        public abstract ValuationTree<Edge<S>> edgeTree(S var1);

        private static Formula unfoldWithSuspension(Formula formula) {
            return formula.accept(UnfoldWithSuspension.INSTANCE);
        }

        <T> Set<T> successorsInternal(Formula state, BitSet valuation, Function<? super Set<Formula>, ? extends Set<T>> mapper) {
            return mapper.apply(this.toCompactDnf(Base.unfoldWithSuspension(state).temporalStep(valuation)));
        }

        <T> ValuationTree<T> successorTreeInternal(Formula state, Function<? super Set<Formula>, ? extends Set<T>> mapper) {
            return this.successorTreeInternalRecursive(Base.unfoldWithSuspension(state), mapper);
        }

        private <T> ValuationTree<T> successorTreeInternalRecursive(Formula clause, Function<? super Set<Formula>, ? extends Set<T>> mapper) {
            int nextVariable = clause.atomicPropositions(false).nextSetBit(0);
            if (nextVariable == -1) {
                return ValuationTree.of((Collection)mapper.apply(this.toCompactDnf(clause.temporalStep())));
            }
            ValuationTree<T> trueChild = this.successorTreeInternalRecursive(clause.temporalStep(nextVariable, true), mapper);
            ValuationTree<T> falseChild = this.successorTreeInternalRecursive(clause.temporalStep(nextVariable, false), mapper);
            return ValuationTree.of(nextVariable, trueChild, falseChild);
        }

        Set<Formula> toCompactDnf(Formula formula) {
            if (formula instanceof Disjunction) {
                Set<Formula> dnf = ((Disjunction)formula).children.stream().flatMap(x -> this.toCompactDnf((Formula)x).stream()).collect(Collectors.toSet());
                HashSet finiteLtl = new HashSet();
                dnf.removeIf(x -> {
                    if (((Boolean)IsLiteralOrXVisitor.INSTANCE.apply((Formula)x)).booleanValue()) {
                        finiteLtl.add(x);
                        return true;
                    }
                    return false;
                });
                Formula finiteDisjunction = SimplifierFactory.apply(Disjunction.of(finiteLtl), SimplifierFactory.Mode.SYNTACTIC_FIXPOINT);
                if (finiteDisjunction.equals(BooleanConstant.TRUE)) {
                    return Set.of(BooleanConstant.TRUE);
                }
                if (finiteDisjunction.equals(BooleanConstant.FALSE)) {
                    return dnf;
                }
                dnf.add(finiteDisjunction);
                return dnf;
            }
            Function<PropositionalFormula, Set> syntheticLiteralFactory = x -> {
                if (x instanceof Conjunction) {
                    return Set.of();
                }
                HashSet finiteLtl = new HashSet();
                HashSet nonFiniteLtl = new HashSet();
                x.children.forEach(y -> {
                    if (((Boolean)IsLiteralOrXVisitor.INSTANCE.apply((Formula)x)).booleanValue()) {
                        finiteLtl.add(y);
                    } else {
                        nonFiniteLtl.add(y);
                    }
                });
                for (Formula finiteFormula : finiteLtl) {
                    if (!nonFiniteLtl.stream().noneMatch(z -> z.anyMatch(finiteFormula::equals))) continue;
                    return x.children;
                }
                return Set.of();
            };
            Set compactDnf = NormalForms.toDnf(formula, syntheticLiteralFactory).stream().flatMap(this::compact).collect(Collectors.toSet());
            if (compactDnf.contains(Set.of())) {
                return Set.of(BooleanConstant.TRUE);
            }
            return compactDnf.stream().map(Conjunction::of).collect(Collectors.toSet());
        }

        private Stream<Set<Formula>> compact(Set<Formula> clause) {
            EquivalenceClass clauseClazz = this.factory.of(Conjunction.of(clause).unfold());
            if (clauseClazz.isTrue()) {
                return Stream.of(Set.of());
            }
            if (clauseClazz.isFalse()) {
                return Stream.empty();
            }
            Set gOperators = clause.stream().filter(GOperator.class::isInstance).map(GOperator.class::cast).collect(Collectors.toSet());
            Set clause2 = clause.stream().filter(x -> !gOperators.contains(new GOperator((Formula)x))).collect(Collectors.toSet());
            EquivalenceClass temporalOperatorsClazz = this.factory.of(Conjunction.of(clause2.stream().filter(Formula.TemporalOperator.class::isInstance)));
            HashSet<Formula> retainedFacts = new HashSet<Formula>();
            for (Formula literal : clause2) {
                if (clause2.contains(literal.not())) {
                    return Stream.empty();
                }
                if (literal instanceof Formula.TemporalOperator) {
                    retainedFacts.add(literal);
                    continue;
                }
                if (temporalOperatorsClazz.implies(this.factory.of(literal))) {
                    assert (literal instanceof Disjunction);
                    continue;
                }
                retainedFacts.add(literal);
            }
            if (clause2.size() == retainedFacts.size()) {
                return Stream.of(clause2);
            }
            return Stream.of(Set.of((Formula[])retainedFacts.toArray(Formula[]::new)));
        }

        private static class UnfoldWithSuspension
        extends Converter {
            private static final UnfoldWithSuspension INSTANCE = new UnfoldWithSuspension();

            private UnfoldWithSuspension() {
                super(SyntacticFragment.NNF);
            }

            @Override
            public Formula visit(FOperator fOperator) {
                return fOperator.isSuspendable() ? fOperator : Disjunction.of((Formula)fOperator, fOperator.operand.accept(this));
            }

            @Override
            public Formula visit(GOperator gOperator) {
                return gOperator.isSuspendable() ? gOperator : Conjunction.of((Formula)gOperator, gOperator.operand.accept(this));
            }

            @Override
            public Formula visit(MOperator mOperator) {
                return Conjunction.of(mOperator.right.accept(this), Disjunction.of(mOperator.left.accept(this), (Formula)mOperator));
            }

            @Override
            public Formula visit(ROperator rOperator) {
                return Conjunction.of(rOperator.right.accept(this), Disjunction.of(rOperator.left.accept(this), (Formula)rOperator));
            }

            @Override
            public Formula visit(UOperator uOperator) {
                return Disjunction.of(uOperator.right.accept(this), Conjunction.of(uOperator.left.accept(this), (Formula)uOperator));
            }

            @Override
            public Formula visit(WOperator wOperator) {
                return Disjunction.of(wOperator.right.accept(this), Conjunction.of(wOperator.left.accept(this), (Formula)wOperator));
            }

            @Override
            public Formula visit(XOperator xOperator) {
                return xOperator;
            }
        }

        private static final class IsLiteralOrXVisitor
        extends PropositionalVisitor<Boolean> {
            private static final IsLiteralOrXVisitor INSTANCE = new IsLiteralOrXVisitor();

            private IsLiteralOrXVisitor() {
            }

            @Override
            protected Boolean visit(Formula.TemporalOperator formula) {
                return formula instanceof XOperator || formula instanceof Literal;
            }

            @Override
            public Boolean visit(Conjunction conjunction) {
                for (Formula x : conjunction.children) {
                    if (x.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Boolean visit(Disjunction disjunction) {
                for (Formula x : disjunction.children) {
                    if (x.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

