/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.optimizations.ParityAcceptanceOptimizations;
import owl.automaton.transformations.ParityUtil;
import owl.automaton.util.AnnotatedStateOptimisation;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.run.Environment;
import owl.translations.ltl2dpa.AsymmetricDPAConstruction;
import owl.translations.ltl2dpa.AsymmetricRankingState;
import owl.translations.ltl2dpa.SymmetricDPAConstruction;
import owl.translations.ltl2dpa.SymmetricRankingState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricLDBAConstruction;
import owl.translations.ltl2ldba.AsymmetricProductState;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;
import owl.translations.mastertheorem.Selector;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;
import owl.util.DaemonThreadFactory;

public class LTL2DPAFunction
implements Function<LabelledFormula, Automaton<?, ParityAcceptance>> {
    public static final Set<Configuration> RECOMMENDED_ASYMMETRIC_CONFIG = Set.of(Configuration.OPTIMISE_INITIAL_STATE, Configuration.COMPLEMENT_CONSTRUCTION_EXACT, Configuration.COMPRESS_COLOURS);
    public static final Set<Configuration> RECOMMENDED_SYMMETRIC_CONFIG = Set.of(Configuration.SYMMETRIC, Configuration.OPTIMISE_INITIAL_STATE, Configuration.COMPLEMENT_CONSTRUCTION_EXACT, Configuration.COMPRESS_COLOURS);
    private final EnumSet<Configuration> configuration;
    private final Environment environment;
    private final AsymmetricLDBAConstruction<BuchiAcceptance> asymmetricTranslator;
    private final SymmetricLDBAConstruction<BuchiAcceptance> symmetricTranslator;

    public LTL2DPAFunction(Environment environment, Set<Configuration> configuration) {
        this.configuration = EnumSet.copyOf(configuration);
        Preconditions.checkArgument((!configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_EXACT) || !configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC) ? 1 : 0) != 0, (Object)"COMPLEMENT_CONSTRUCTION_EXACT and HEURISTIC cannot be used together.");
        this.environment = environment;
        this.symmetricTranslator = SymmetricLDBAConstruction.of(environment, BuchiAcceptance.class);
        this.asymmetricTranslator = AsymmetricLDBAConstruction.of(environment, BuchiAcceptance.class);
    }

    @Override
    public Automaton<?, ParityAcceptance> apply(LabelledFormula formula) {
        Callable<Result> complementCallable;
        Callable<Result> automatonCallable;
        ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory(Thread.currentThread().getThreadGroup()));
        if (this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC)) {
            int negationFixpoints;
            int fixpoints = this.configuration.contains((Object)Configuration.SYMMETRIC) ? Selector.selectSymmetric(formula.formula(), false).size() : Selector.selectAsymmetric(formula.formula(), false).size();
            int n = negationFixpoints = this.configuration.contains((Object)Configuration.SYMMETRIC) ? Selector.selectSymmetric(formula.formula().not(), false).size() : Selector.selectAsymmetric(formula.formula().not(), false).size();
            if (fixpoints <= negationFixpoints) {
                automatonCallable = this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> this.symmetricConstruction(formula) : () -> this.asymmetricConstruction(formula);
                complementCallable = () -> null;
            } else {
                automatonCallable = () -> null;
                complementCallable = this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> this.symmetricConstruction(formula.not()) : () -> this.asymmetricConstruction(formula.not());
            }
        } else {
            Callable<Result> callable = automatonCallable = this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> this.symmetricConstruction(formula) : () -> this.asymmetricConstruction(formula);
            complementCallable = this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_EXACT) ? (this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> this.symmetricConstruction(formula.not()) : () -> this.asymmetricConstruction(formula.not())) : () -> null;
        }
        Future<Result<?>> automatonFuture = executor.submit(automatonCallable);
        Future<Result<?>> complementFuture = executor.submit(complementCallable);
        try {
            Automaton<?, ParityAcceptance> automaton = null;
            Automaton<?, ParityAcceptance> complement = null;
            do {
                if (automaton == null) {
                    automaton = LTL2DPAFunction.getAutomaton(automatonFuture);
                }
                if (complement != null) continue;
                complement = LTL2DPAFunction.getComplement(complementFuture);
            } while (!this.exitLoop(automaton, complement));
            if (complement == null) {
                assert (automaton != null);
                Automaton<?, ParityAcceptance> automaton2 = automaton;
                return automaton2;
            }
            if (automaton == null) {
                Automaton<?, ParityAcceptance> automaton3 = complement;
                return automaton3;
            }
            if (automaton.size() < complement.size()) {
                Automaton<?, ParityAcceptance> automaton4 = automaton;
                return automaton4;
            }
            if (automaton.size() > complement.size()) {
                Automaton<?, ParityAcceptance> automaton5 = complement;
                return automaton5;
            }
            Automaton<?, ParityAcceptance> automaton6 = automaton.acceptance().acceptanceSets() <= complement.acceptance().acceptanceSets() ? automaton : complement;
            return automaton6;
        }
        catch (ExecutionException ex) {
            automatonFuture.cancel(true);
            complementFuture.cancel(true);
            throw new RuntimeException(ex);
        }
        finally {
            executor.shutdown();
        }
    }

    private boolean exitLoop(@Nullable Automaton<?, ?> automaton, @Nullable Automaton<?, ?> complement) {
        if (this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC)) {
            return automaton != null || complement != null;
        }
        if (this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_EXACT)) {
            return automaton != null && complement != null;
        }
        return automaton != null;
    }

    @Nullable
    private static Automaton<?, ParityAcceptance> getAutomaton(Future<Result<?>> future) throws ExecutionException {
        Result result = (Result)Uninterruptibles.getUninterruptibly(future);
        return result == null ? null : result.automaton;
    }

    @Nullable
    private static Automaton<?, ParityAcceptance> getComplement(Future<Result<?>> future) throws ExecutionException {
        Result result = (Result)Uninterruptibles.getUninterruptibly(future);
        return result == null ? null : result.complement();
    }

    private Result<AsymmetricRankingState> asymmetricConstruction(LabelledFormula formula) {
        AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, BuchiAcceptance, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> ldba = this.asymmetricTranslator.apply(formula);
        if (ldba.initialComponent().initialStates().isEmpty()) {
            EquivalenceClassFactory factory = this.environment.factorySupplier().getEquivalenceClassFactory(formula.variables());
            Automaton dpa = AutomatonFactory.empty(ldba.factory(), new ParityAcceptance(3, ParityAcceptance.Parity.MIN_ODD));
            return new Result<AsymmetricRankingState>(dpa, AsymmetricRankingState.of(factory.getFalse()), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
        }
        Automaton<AsymmetricRankingState, ParityAcceptance> dpa = AsymmetricDPAConstruction.of(ldba);
        Automaton<AsymmetricRankingState, ParityAcceptance> optimisedDpa = this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE) ? MutableAutomatonUtil.asMutable(AnnotatedStateOptimisation.optimizeInitialState(dpa)) : dpa;
        return new Result<AsymmetricRankingState>(optimisedDpa, AsymmetricRankingState.of(ldba.initialComponent().onlyInitialState().factory().getFalse()), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
    }

    private Result<SymmetricRankingState> symmetricConstruction(LabelledFormula formula) {
        AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, BuchiAcceptance, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba = this.symmetricTranslator.apply(formula);
        if (ldba.initialComponent().initialStates().isEmpty()) {
            Automaton dpa = AutomatonFactory.empty(ldba.factory(), new ParityAcceptance(3, ParityAcceptance.Parity.MIN_ODD));
            return new Result<SymmetricRankingState>(dpa, SymmetricRankingState.of(Map.of()), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
        }
        Automaton<SymmetricRankingState, ParityAcceptance> dpa = SymmetricDPAConstruction.of(ldba);
        Automaton<SymmetricRankingState, ParityAcceptance> optimisedDpa = this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE) ? MutableAutomatonUtil.asMutable(AnnotatedStateOptimisation.optimizeInitialState(dpa)) : dpa;
        return new Result<SymmetricRankingState>(optimisedDpa, SymmetricRankingState.of(Map.of()), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
    }

    private static final class Result<T> {
        final Automaton<T, ParityAcceptance> automaton;
        final T sinkState;

        Result(Automaton<T, ParityAcceptance> automaton, T sinkState, boolean compressColours) {
            this.sinkState = sinkState;
            this.automaton = compressColours ? ParityAcceptanceOptimizations.minimizePriorities(MutableAutomatonUtil.asMutable(automaton)) : automaton;
        }

        Automaton<T, ParityAcceptance> complement() {
            if (this.automaton instanceof MutableAutomaton || this.automaton.acceptance().parity() != ParityAcceptance.Parity.MIN_ODD) {
                return ParityUtil.complement(MutableAutomatonUtil.asMutable(this.automaton), this.sinkState);
            }
            assert (this.automaton.acceptance().parity() == ParityAcceptance.Parity.MIN_ODD);
            return AutomatonUtil.cast(Views.complement(this.automaton, this.sinkState), ParityAcceptance.class);
        }
    }

    public static enum Configuration {
        SYMMETRIC,
        COMPLEMENT_CONSTRUCTION_EXACT,
        COMPLEMENT_CONSTRUCTION_HEURISTIC,
        OPTIMISE_INITIAL_STATE,
        COMPRESS_COLOURS;

    }
}

