/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.util.AnnotatedStateOptimisation;
import owl.collections.Collections3;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.run.Environment;
import owl.translations.SafetyCoreDetector;
import owl.translations.ltl2dra.SymmetricRankingState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class SymmetricDRAConstruction<R extends GeneralizedRabinAcceptance>
implements Function<LabelledFormula, Automaton<SymmetricRankingState, R>> {
    private final boolean optimizeInitialState;
    private final Class<? extends R> acceptanceClass;
    private final SymmetricLDBAConstruction<?> translation;

    private SymmetricDRAConstruction(Environment environment, Class<? extends R> acceptanceClass, boolean optimizeInitialState) {
        assert (acceptanceClass.equals(GeneralizedRabinAcceptance.class) || acceptanceClass.equals(RabinAcceptance.class));
        Class buchiAcceptance = acceptanceClass.equals(GeneralizedRabinAcceptance.class) ? GeneralizedBuchiAcceptance.class : BuchiAcceptance.class;
        this.acceptanceClass = acceptanceClass;
        this.optimizeInitialState = optimizeInitialState;
        this.translation = SymmetricLDBAConstruction.of(environment, buchiAcceptance);
    }

    public static <R extends GeneralizedRabinAcceptance> SymmetricDRAConstruction<R> of(Environment environment, Class<? extends R> clazz, boolean optimizeInitialState) {
        return new SymmetricDRAConstruction<R>(environment, clazz, optimizeInitialState);
    }

    @Override
    public Automaton<SymmetricRankingState, R> apply(LabelledFormula formula) {
        AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, ?, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba = this.translation.apply(formula);
        Builder builder = new Builder(ldba);
        Automaton automaton = AutomatonFactory.create(ldba.factory(), Collections3.ofNullable(builder.initialState), builder.acceptance, builder::edge);
        return this.optimizeInitialState ? AnnotatedStateOptimisation.optimizeInitialState(automaton) : automaton;
    }

    class Builder {
        final R acceptance;
        final Map<SymmetricEvaluatedFixpoints, GeneralizedRabinAcceptance.RabinPair> pairs;
        final GeneralizedRabinAcceptance.RabinPair safetyRabinPair;
        @Nullable
        final SymmetricRankingState initialState;
        final List<Set<Map<Integer, EquivalenceClass>>> initialComponentSccs;
        final AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, ?, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba;

        private Builder(AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, ?, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba) {
            this.initialComponentSccs = SccDecomposition.computeSccs(ldba.initialComponent());
            this.ldba = ldba;
            this.pairs = new HashMap<SymmetricEvaluatedFixpoints, GeneralizedRabinAcceptance.RabinPair>();
            Map<Integer, EquivalenceClass> ldbaInitialState = ldba.initialComponent().initialStates().isEmpty() ? Map.of() : ldba.initialComponent().onlyInitialState();
            List<SymmetricEvaluatedFixpoints> fixpoints = ldba.annotation().stream().filter(Predicate.not(SymmetricEvaluatedFixpoints::isEmpty)).sorted(SymmetricEvaluatedFixpoints::compareTo).collect(Collectors.toList());
            if (SymmetricDRAConstruction.this.acceptanceClass.equals(RabinAcceptance.class)) {
                RabinAcceptance.Builder builder = new RabinAcceptance.Builder();
                fixpoints.forEach(x -> this.pairs.put((SymmetricEvaluatedFixpoints)x, builder.add()));
                this.safetyRabinPair = builder.add();
                this.acceptance = (GeneralizedRabinAcceptance)SymmetricDRAConstruction.this.acceptanceClass.cast(builder.build());
            } else {
                assert (SymmetricDRAConstruction.this.acceptanceClass.equals(GeneralizedRabinAcceptance.class));
                GeneralizedRabinAcceptance.Builder builder = new GeneralizedRabinAcceptance.Builder();
                int infSets = ((GeneralizedBuchiAcceptance)ldba.acceptance()).acceptanceSets();
                fixpoints.forEach(x -> this.pairs.put((SymmetricEvaluatedFixpoints)x, builder.add(infSets)));
                this.safetyRabinPair = builder.add(infSets);
                this.acceptance = (GeneralizedRabinAcceptance)SymmetricDRAConstruction.this.acceptanceClass.cast(builder.build());
            }
            this.initialState = ldbaInitialState.isEmpty() ? null : this.edge(ldbaInitialState, (Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState>)ImmutableTable.of(), 0, -1, null).successor();
        }

        Edge<SymmetricRankingState> edge(Map<Integer, EquivalenceClass> successor, Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState> previousTable, int safetyBucket, int safetyBucketIndex, @Nullable BitSet valuation) {
            for (EquivalenceClass clazz2 : successor.values()) {
                if (!SafetyCoreDetector.safetyCoreExists(clazz2)) continue;
                if (this.safetyRabinPair.hasInfSet()) {
                    BitSet acceptanceSets = new BitSet();
                    this.safetyRabinPair.infSetIterator().forEachRemaining(acceptanceSets::set);
                    return Edge.of(SymmetricRankingState.of(successor), acceptanceSets);
                }
                return Edge.of(SymmetricRankingState.of(successor));
            }
            TreeMap safetySuccessorMap = new TreeMap();
            HashBasedTable successorMap = HashBasedTable.create();
            successor.forEach((index, clazz) -> {
                for (SymmetricProductState x : this.ldba.stateAnnotation().apply((Integer)index, (EquivalenceClass)clazz)) {
                    SymmetricProductState oldCell;
                    if (!this.ldba.acceptingComponent().states().contains(x)) continue;
                    if (x.evaluatedFixpoints.isSafety()) {
                        safetySuccessorMap.putIfAbsent((Integer)index, new TreeMap());
                        oldCell = ((TreeMap)safetySuccessorMap.get(index)).put(x.evaluatedFixpoints, x);
                        assert (oldCell == null);
                        continue;
                    }
                    oldCell = (SymmetricProductState)successorMap.put(index, (Object)x.evaluatedFixpoints, (Object)x);
                    assert (oldCell == null);
                }
            });
            BitSet acceptance = new BitSet();
            boolean activeSafetyComponent = false;
            HashSet<SymmetricEvaluatedFixpoints> seenEvaluatedFixpoints = new HashSet<SymmetricEvaluatedFixpoints>();
            for (Table.Cell entry : previousTable.cellSet()) {
                GeneralizedRabinAcceptance.RabinPair pair;
                SymmetricEvaluatedFixpoints fixpoints = (SymmetricEvaluatedFixpoints)entry.getColumnKey();
                SymmetricProductState state = (SymmetricProductState)entry.getValue();
                Integer index2 = (Integer)entry.getRowKey();
                assert (valuation != null) : "Valuation is only allowed to be null for empty rankings.";
                assert (fixpoints != null && state != null && index2 != null) : "Malformed internal data-structure";
                Edge<SymmetricProductState> edge = this.ldba.acceptingComponent().edge(state, valuation);
                GeneralizedRabinAcceptance.RabinPair rabinPair = pair = fixpoints.isEmpty() ? this.safetyRabinPair : this.pairs.get(fixpoints);
                assert (fixpoints.isSafety() || seenEvaluatedFixpoints.add(fixpoints)) : "Non-safety fixpoint already encountered: " + fixpoints;
                if (edge == null || !fixpoints.isSafety() && !successorMap.contains((Object)index2, (Object)fixpoints)) {
                    acceptance.set(pair.finSet());
                    continue;
                }
                successorMap.put((Object)index2, (Object)fixpoints, (Object)edge.successor());
                edge.acceptanceSetIterator().forEachRemaining(i -> acceptance.set(pair.infSet(i)));
                if (!fixpoints.isSafety()) continue;
                activeSafetyComponent = true;
                assert (safetyBucket > 0 && safetyBucketIndex >= 0);
            }
            int successorSafetyBucket = 0;
            int successorSafetyBucketIndex = -1;
            if (activeSafetyComponent) {
                successorSafetyBucket = safetyBucket;
                successorSafetyBucketIndex = safetyBucketIndex;
            } else {
                Map.Entry bucketEntry;
                Map.Entry safetyStateEntry;
                acceptance.set(this.safetyRabinPair.finSet());
                TreeMap bucket = (TreeMap)safetySuccessorMap.get(safetyBucket);
                if (bucket != null) {
                    SymmetricEvaluatedFixpoints evaluatedFixpoints = (SymmetricEvaluatedFixpoints)Iterables.get((Iterable)this.ldba.annotation(), (int)safetyBucketIndex);
                    safetyStateEntry = bucket.tailMap(evaluatedFixpoints, false).firstEntry();
                    if (safetyStateEntry == null) {
                        bucket = null;
                    } else {
                        successorSafetyBucket = safetyBucket;
                        successorSafetyBucketIndex = this.ldba.annotation().headSet(safetyStateEntry.getKey()).size();
                        successorMap.put((Object)0, (Object)safetyStateEntry.getKey(), (Object)((SymmetricProductState)safetyStateEntry.getValue()));
                    }
                }
                if (bucket == null && (bucketEntry = (Map.Entry)Iterables.getFirst((Iterable)Iterables.concat(safetySuccessorMap.tailMap(safetyBucket, false).entrySet(), safetySuccessorMap.headMap(safetyBucket, true).entrySet()), null)) != null) {
                    safetyStateEntry = ((TreeMap)bucketEntry.getValue()).firstEntry();
                    successorSafetyBucket = (Integer)bucketEntry.getKey();
                    successorSafetyBucketIndex = this.ldba.annotation().headSet(safetyStateEntry.getKey()).size();
                    successorMap.put((Object)0, (Object)safetyStateEntry.getKey(), (Object)((SymmetricProductState)safetyStateEntry.getValue()));
                }
            }
            return Edge.of(SymmetricRankingState.of(successor, (Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState>)successorMap, successorSafetyBucket, successorSafetyBucketIndex), acceptance);
        }

        @Nullable
        Edge<SymmetricRankingState> edge(SymmetricRankingState state, BitSet valuation) {
            Map<Integer, EquivalenceClass> successor = this.ldba.initialComponent().successor((Map<Integer, EquivalenceClass>)state.state(), valuation);
            if (successor == null) {
                return null;
            }
            if (this.initialComponentSccs.stream().anyMatch(x -> x.contains(state.state()) && !x.contains(successor))) {
                return this.edge(successor, (Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState>)ImmutableTable.of(), 0, -1, valuation).withoutAcceptance();
            }
            return this.edge(successor, state.table(), state.safetyBucket(), state.safetyBucketIndex(), valuation);
        }
    }
}

