/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2dpa;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.automaton.AbstractCachedStatesAutomaton;
import owl.automaton.Automaton;
import owl.automaton.AutomatonOperations;
import owl.automaton.AutomatonUtil;
import owl.automaton.EdgesAutomatonMixin;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithms.LanguageContainment;
import owl.automaton.edge.Edge;
import owl.factories.ValuationSetFactory;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.nba2dpa.RankingState;
import owl.translations.nba2ldba.NBA2LDBA;

public final class NBA2DPA
implements Function<Automaton<?, ?>, Automaton<?, ParityAcceptance>> {
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("nba2dpa").description("Converts a non-deterministic generalized B\u00fcchi automaton into a deterministic parity automaton.").parser(settings -> environment -> (input, context) -> new NBA2DPA().apply(AutomatonUtil.cast(input))).build();

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("nba2dpa").reader(InputReaders.HOA).addTransformer(CLI).writer(OutputWriters.HOA).build());
    }

    @Override
    public Automaton<RankingState<Object>, ParityAcceptance> apply(Automaton<?, ?> nba) {
        return new RankingAutomaton<Object>(NBA2LDBA.applyLDBA(nba));
    }

    private static final class RankingAutomaton<S>
    extends AbstractCachedStatesAutomaton<RankingState<S>, ParityAcceptance>
    implements EdgesAutomatonMixin<RankingState<S>, ParityAcceptance> {
        private final Automaton<S, BuchiAcceptance> nba;
        private final Set<S> intialComponent;
        private final ParityAcceptance acceptance;
        private final RankingState<S> initialState;
        private final LoadingCache<Map.Entry<Set<S>, S>, Boolean> greaterOrEqualCache;

        RankingAutomaton(NBA2LDBA.LDBA<S> ldba) {
            this.nba = ldba.automaton();
            this.intialComponent = Set.copyOf(ldba.initialComponent());
            this.greaterOrEqualCache = CacheBuilder.newBuilder().maximumSize(500000L).expireAfterAccess(60L, TimeUnit.SECONDS).build(new CacheLoader<Map.Entry<Set<S>, S>, Boolean>(){

                public Boolean load(Map.Entry<Set<S>, S> entry) {
                    return LanguageContainment.contains(Views.replaceInitialState(nba, Set.of(entry.getValue())), AutomatonUtil.cast(AutomatonOperations.union(entry.getKey().stream().map(x -> Views.replaceInitialState(nba, Set.of(x))).collect(Collectors.toList())), BuchiAcceptance.class));
                }
            });
            this.initialState = RankingState.of(this.onlyInitialComponent(this.nba.initialStates()), List.copyOf(this.onlyAcceptingComponent(this.nba.initialStates())));
            this.acceptance = new ParityAcceptance(2 * Math.max(1, this.nba.states().size() - this.intialComponent.size()) + 1, ParityAcceptance.Parity.MIN_ODD);
        }

        @Override
        public ParityAcceptance acceptance() {
            return this.acceptance;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.nba.factory();
        }

        @Override
        public Set<RankingState<S>> initialStates() {
            return Set.of(this.initialState);
        }

        @Override
        public Set<Edge<RankingState<S>>> edges(RankingState<S> state, BitSet valuation) {
            HashSet<S> initialComponentSuccessors = new HashSet<S>();
            HashSet<S> acceptingComponentSuccessors = new HashSet<S>();
            for (S initialComponentState : state.initialComponentStates()) {
                Set<S> successors = this.nba.successors(initialComponentState, valuation);
                initialComponentSuccessors.addAll(this.onlyInitialComponent(successors));
                acceptingComponentSuccessors.addAll(this.onlyAcceptingComponent(successors));
            }
            int edgeColor = 2 * state.acceptingComponentStates().size();
            ArrayList<Object> ranking = new ArrayList<Object>(state.acceptingComponentStates().size());
            ListIterator<S> iterator = state.acceptingComponentStates().listIterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)Iterables.getOnlyElement(this.nba.edges(iterator.next(), valuation), null);
                if (edge == null) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                Object successor = edge.successor();
                if (this.languageContainedIn(successor, ranking)) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                ranking.add(successor);
                if (!edge.inSet(0)) continue;
                edgeColor = Math.min(2 * iterator.previousIndex() + 1, edgeColor);
            }
            for (Object accState : acceptingComponentSuccessors) {
                if (this.languageContainedIn(accState, ranking)) continue;
                ranking.add(accState);
            }
            if (initialComponentSuccessors.isEmpty() && ranking.isEmpty()) {
                return Set.of();
            }
            Edge dpaEdge = Edge.of(RankingState.of(initialComponentSuccessors, ranking), edgeColor);
            assert (dpaEdge.largestAcceptanceSet() < this.acceptance.acceptanceSets());
            return Set.of(dpaEdge);
        }

        private boolean languageContainedIn(S language2, List<S> language1) {
            if (language1.contains(language2)) {
                return true;
            }
            if (language1.isEmpty()) {
                return false;
            }
            return (Boolean)this.greaterOrEqualCache.getUnchecked(Map.entry(Set.copyOf(language1), language2));
        }

        private Set<S> onlyInitialComponent(Set<S> states) {
            return Sets.intersection(states, this.intialComponent);
        }

        private Set<S> onlyAcceptingComponent(Set<S> states) {
            return Sets.difference(states, this.intialComponent);
        }
    }
}

