/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals;

import it.unimi.dsi.fastutil.doubles.Double2IntFunction;
import it.unimi.dsi.fastutil.doubles.Double2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.PrimitiveIterator;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntUnaryOperator;

public final class Indices {
    private Indices() {
    }

    public static IntUnaryOperator elementToIndexMap(IntCollection ints) {
        return Indices.elementToIndexMap((PrimitiveIterator.OfInt)ints.iterator());
    }

    public static IntUnaryOperator elementToIndexMap(PrimitiveIterator.OfInt iterator) {
        Int2IntLinkedOpenHashMap indexMap = new Int2IntLinkedOpenHashMap();
        indexMap.defaultReturnValue(-1);
        int index = 0;
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            assert (!indexMap.containsKey(next));
            indexMap.put(next, index);
            ++index;
        }
        return arg_0 -> Indices.lambda$elementToIndexMap$0((Int2IntFunction)indexMap, arg_0);
    }

    public static DoubleToIntFunction elementToIndexMap(DoubleCollection doubles) {
        return Indices.elementToIndexMap((PrimitiveIterator.OfDouble)doubles.iterator());
    }

    public static DoubleToIntFunction elementToIndexMap(PrimitiveIterator.OfDouble iterator) {
        Double2IntLinkedOpenHashMap indexMap = new Double2IntLinkedOpenHashMap();
        indexMap.defaultReturnValue(-1);
        int index = 0;
        while (iterator.hasNext()) {
            double next = iterator.nextDouble();
            assert (!indexMap.containsKey(next));
            indexMap.put(next, index);
            ++index;
        }
        return arg_0 -> Indices.lambda$elementToIndexMap$1((Double2IntFunction)indexMap, arg_0);
    }

    public static int[] indexMap(boolean[] elements) {
        int elementCount = 0;
        for (boolean element : elements) {
            if (!element) continue;
            ++elementCount;
        }
        if (elementCount == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        int[] indexArray = new int[elementCount];
        int index = 0;
        for (int globalIndex = 0; globalIndex < elements.length; ++globalIndex) {
            if (!elements[globalIndex]) continue;
            indexArray[index] = globalIndex;
            ++index;
        }
        return indexArray;
    }

    public static <E> void forEachIndexed(Iterable<E> elements, IndexConsumer<E> action) {
        int index = 0;
        for (E element : elements) {
            action.accept(index, element);
            ++index;
        }
    }

    public static void forEachIndexed(IntIterable elements, IntIndexConsumer action) {
        int index = 0;
        IntIterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            action.accept(index, iterator.nextInt());
            ++index;
        }
    }

    private static /* synthetic */ int lambda$elementToIndexMap$1(Double2IntFunction indexMap, double element) {
        assert (indexMap.containsKey(element));
        return indexMap.get(element);
    }

    private static /* synthetic */ int lambda$elementToIndexMap$0(Int2IntFunction indexMap, int element) {
        assert (indexMap.containsKey(element));
        return indexMap.get(element);
    }

    @FunctionalInterface
    public static interface IntIndexConsumer {
        public void accept(int var1, int var2);
    }

    @FunctionalInterface
    public static interface IndexConsumer<E> {
        public void accept(int var1, E var2);
    }
}

