/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.bitset.SparseBitSets;
import de.tum.in.naturals.set.BoundedMutableSingletonNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.BoundedWrapper;
import de.tum.in.naturals.set.FixedSizeNatBitSet;
import de.tum.in.naturals.set.LongBoundedNatBitSet;
import de.tum.in.naturals.set.LongNatBitSet;
import de.tum.in.naturals.set.MutableSingletonNatBitSet;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSetComplementIterator;
import de.tum.in.naturals.set.NatBitSetComplementReverseIterator;
import de.tum.in.naturals.set.PowerNatBitSet;
import de.tum.in.naturals.set.ReverseRangeIterator;
import de.tum.in.naturals.set.SimpleBoundedNatBitSet;
import de.tum.in.naturals.set.SimpleNatBitSet;
import de.tum.in.naturals.set.SparseBoundedNatBitSet;
import de.tum.in.naturals.set.SparseNatBitSet;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.BitSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnegative;

public final class NatBitSets {
    public static final int UNKNOWN_LENGTH = -1;
    public static final int UNKNOWN_SIZE = -1;
    private static final int SPARSE_THRESHOLD = 8192;

    private NatBitSets() {
    }

    public static BoundedNatBitSet asBounded(NatBitSet set, @Nonnegative int domainSize) {
        assert (domainSize >= 0);
        if (!set.isEmpty() && set.lastInt() >= domainSize) {
            throw new IndexOutOfBoundsException();
        }
        if (set instanceof BoundedNatBitSet) {
            BoundedNatBitSet boundedSet = (BoundedNatBitSet)set;
            int oldDomainSize = boundedSet.domainSize();
            if (oldDomainSize != domainSize) {
                throw new IllegalArgumentException(String.format("Given set has domain size %d, expected %d", boundedSet.domainSize(), domainSize));
            }
            return boundedSet;
        }
        if (set instanceof SimpleNatBitSet) {
            SimpleNatBitSet simpleSet = (SimpleNatBitSet)set;
            return new SimpleBoundedNatBitSet(simpleSet.getBitSet(), domainSize);
        }
        if (set instanceof SparseNatBitSet) {
            SparseNatBitSet sparseSet = (SparseNatBitSet)set;
            return new SparseBoundedNatBitSet(sparseSet.getSparseBitSet(), domainSize);
        }
        if (set instanceof LongNatBitSet) {
            LongNatBitSet longSet = (LongNatBitSet)set;
            return new LongBoundedNatBitSet(longSet.getStore(), domainSize);
        }
        if (set instanceof MutableSingletonNatBitSet) {
            MutableSingletonNatBitSet singletonSet = (MutableSingletonNatBitSet)set;
            return singletonSet.isEmpty() ? new BoundedMutableSingletonNatBitSet(domainSize) : new BoundedMutableSingletonNatBitSet(singletonSet.firstInt(), domainSize);
        }
        return new BoundedWrapper(set, domainSize);
    }

    public static NatBitSet asSet(BitSet bitSet) {
        return new SimpleNatBitSet(bitSet);
    }

    public static BoundedNatBitSet boundedFilledSet(int domainSize) {
        return NatBitSets.boundedFilledSet(domainSize, -1);
    }

    public static BoundedNatBitSet boundedFilledSet(int domainSize, int expectedSize) {
        return NatBitSets.boundedSet(domainSize, expectedSize).complement();
    }

    public static BoundedNatBitSet boundedLongSet(int domainSize) {
        return new LongBoundedNatBitSet(domainSize);
    }

    public static BoundedNatBitSet boundedSet(int domainSize) {
        return NatBitSets.boundedSet(domainSize, -1);
    }

    public static BoundedNatBitSet boundedSet(int domainSize, int expectedSize) {
        if (domainSize <= LongBoundedNatBitSet.maximalSize()) {
            return new LongBoundedNatBitSet(domainSize);
        }
        return NatBitSets.useSparse(expectedSize, domainSize) ? new SparseBoundedNatBitSet(new SparseBitSet(domainSize), domainSize) : new SimpleBoundedNatBitSet(new BitSet(), domainSize);
    }

    public static BoundedNatBitSet boundedSimpleSet(int domainSize) {
        return new SimpleBoundedNatBitSet(new BitSet(), domainSize);
    }

    public static BoundedNatBitSet boundedSingleton(int domainSize, int element) {
        return new BoundedMutableSingletonNatBitSet(element, domainSize);
    }

    public static BoundedNatBitSet boundedSparseSet(int domainSize) {
        return new SparseBoundedNatBitSet(new SparseBitSet(), domainSize);
    }

    public static NatBitSet compact(NatBitSet set) {
        return NatBitSets.compact(set, false);
    }

    public static NatBitSet compact(NatBitSet set, boolean forceCopy) {
        if (set instanceof MutableSingletonNatBitSet || set instanceof FixedSizeNatBitSet) {
            return set;
        }
        if (set.isEmpty()) {
            return NatBitSets.emptySet();
        }
        if (set.size() == 1) {
            return NatBitSets.singleton(set.firstInt());
        }
        if (set.firstInt() == 0 && set.lastInt() == set.size() - 1) {
            return new FixedSizeNatBitSet(set.lastInt() + 1);
        }
        if (!(set instanceof LongNatBitSet) && set.lastInt() < LongNatBitSet.maximalSize()) {
            LongNatBitSet copy = new LongNatBitSet();
            set.forEach(copy::set);
            return copy;
        }
        return forceCopy ? set.clone() : set;
    }

    public static IntIterator complementIterator(NatBitSet set, @Nonnegative int length) {
        if (set.isEmpty()) {
            return IntIterators.fromTo((int)0, (int)length);
        }
        if (set.firstInt() >= length) {
            throw new IllegalArgumentException();
        }
        if (set instanceof FixedSizeNatBitSet) {
            int size = set.size();
            if (size >= length) {
                return IntIterators.EMPTY_ITERATOR;
            }
            return IntIterators.fromTo((int)size, (int)length);
        }
        if (set instanceof MutableSingletonNatBitSet) {
            int element = set.firstInt();
            if (element == 0) {
                return IntIterators.fromTo((int)1, (int)length);
            }
            if (length <= element + 1) {
                return IntIterators.fromTo((int)0, (int)length);
            }
            return IntIterators.concat((IntIterator[])new IntIterator[]{IntIterators.fromTo((int)0, (int)element), IntIterators.fromTo((int)(element + 1), (int)length)});
        }
        return IntIterators.unmodifiable((IntIterator)new NatBitSetComplementIterator(set, length));
    }

    public static IntIterator complementReverseIterator(NatBitSet set, @Nonnegative int length) {
        if (set.firstInt() >= length) {
            throw new IllegalArgumentException();
        }
        if (set.isEmpty()) {
            return new ReverseRangeIterator(0, length);
        }
        if (set instanceof FixedSizeNatBitSet) {
            int size = set.size();
            if (size >= length) {
                return IntIterators.EMPTY_ITERATOR;
            }
            return new ReverseRangeIterator(size, length);
        }
        if (set instanceof MutableSingletonNatBitSet) {
            int element = set.firstInt();
            if (element == 0) {
                return new ReverseRangeIterator(1, length);
            }
            if (length <= element + 1) {
                return IntIterators.fromTo((int)0, (int)length);
            }
            ReverseRangeIterator firstIterator = new ReverseRangeIterator(element + 1, length);
            ReverseRangeIterator secondIterator = new ReverseRangeIterator(0, element);
            return IntIterators.concat((IntIterator[])new IntIterator[]{firstIterator, secondIterator});
        }
        return IntIterators.unmodifiable((IntIterator)new NatBitSetComplementReverseIterator(set, length));
    }

    public static NatBitSet copyOf(IntCollection indices) {
        NatBitSet copy;
        if (indices.isEmpty()) {
            copy = NatBitSets.emptySet();
        } else if (indices instanceof NatBitSet) {
            copy = ((NatBitSet)indices).clone();
        } else if (indices instanceof IntSortedSet) {
            copy = NatBitSets.set(indices.size(), ((IntSortedSet)indices).lastInt());
            copy.or(indices);
        } else {
            copy = NatBitSets.set(indices.size(), -1);
            copy.or(indices);
        }
        assert (copy.equals(indices instanceof Set ? indices : new IntAVLTreeSet(indices)));
        return copy;
    }

    public static NatBitSet emptySet() {
        return new MutableSingletonNatBitSet();
    }

    public static BoundedNatBitSet emptySet(@Nonnegative int domainSize) {
        return new FixedSizeNatBitSet(domainSize).complement();
    }

    public static BoundedNatBitSet ensureBounded(NatBitSet set, @Nonnegative int domainSize) {
        if (!set.isEmpty() && set.lastInt() >= domainSize) {
            throw new IndexOutOfBoundsException();
        }
        if (set instanceof BoundedNatBitSet) {
            BoundedNatBitSet boundedSet = (BoundedNatBitSet)set;
            int oldDomainSize = boundedSet.domainSize();
            if (oldDomainSize == domainSize) {
                return boundedSet;
            }
            if (set instanceof SimpleBoundedNatBitSet) {
                SimpleBoundedNatBitSet simpleBoundedSet = (SimpleBoundedNatBitSet)set;
                BitSet bitSetCopy = (BitSet)simpleBoundedSet.getBitSet().clone();
                if (simpleBoundedSet.isComplement()) {
                    if (domainSize < oldDomainSize) {
                        bitSetCopy.clear(domainSize, oldDomainSize);
                    } else {
                        bitSetCopy.set(oldDomainSize, domainSize);
                    }
                }
                SimpleBoundedNatBitSet copy = new SimpleBoundedNatBitSet(bitSetCopy, domainSize);
                return simpleBoundedSet.isComplement() ? copy.complement() : copy;
            }
            if (set instanceof SparseBoundedNatBitSet) {
                SparseBoundedNatBitSet sparseBoundedSet = (SparseBoundedNatBitSet)set;
                SparseBitSet bitSetCopy = sparseBoundedSet.getSparseBitSet().clone();
                if (sparseBoundedSet.isComplement()) {
                    if (domainSize < oldDomainSize) {
                        bitSetCopy.clear(domainSize, oldDomainSize);
                    } else {
                        bitSetCopy.set(oldDomainSize, domainSize);
                    }
                }
                SparseBoundedNatBitSet copy = new SparseBoundedNatBitSet(bitSetCopy, domainSize);
                return sparseBoundedSet.isComplement() ? copy.complement() : copy;
            }
            if (set instanceof MutableSingletonNatBitSet) {
                MutableSingletonNatBitSet singletonSet = (MutableSingletonNatBitSet)set;
                return singletonSet.isEmpty() ? new BoundedMutableSingletonNatBitSet(domainSize) : new BoundedMutableSingletonNatBitSet(singletonSet.firstInt(), domainSize);
            }
        }
        BoundedNatBitSet copy = NatBitSets.boundedSet(domainSize, set.size());
        copy.or((IntCollection)set);
        return copy;
    }

    public static NatBitSet ensureModifiable(NatBitSet set) {
        return NatBitSets.isModifiable(set) ? set : NatBitSets.modifiableCopyOf(set);
    }

    public static NatBitSet ensureModifiable(NatBitSet set, @Nonnegative int length) {
        return NatBitSets.isModifiable(set, length) ? set : NatBitSets.modifiableCopyOf(set, length);
    }

    public static NatBitSet ensureModifiable(BoundedNatBitSet set) {
        return NatBitSets.isModifiable(set) ? set : NatBitSets.modifiableCopyOf(set);
    }

    public static BoundedNatBitSet fullSet(@Nonnegative int length) {
        return new FixedSizeNatBitSet(length);
    }

    public static boolean isModifiable(NatBitSet set) {
        return NatBitSets.isModifiable(set, Integer.MAX_VALUE);
    }

    public static boolean isModifiable(BoundedNatBitSet set) {
        return set instanceof SimpleBoundedNatBitSet || set instanceof SparseBoundedNatBitSet || set instanceof LongBoundedNatBitSet;
    }

    public static boolean isModifiable(NatBitSet set, @Nonnegative int length) {
        if (length == 0) {
            return true;
        }
        if (set instanceof BoundedNatBitSet) {
            BoundedNatBitSet boundedSet = (BoundedNatBitSet)set;
            return length <= boundedSet.domainSize() && NatBitSets.isModifiable(boundedSet);
        }
        if (set instanceof LongNatBitSet) {
            return length <= LongNatBitSet.maximalSize();
        }
        return set instanceof SimpleNatBitSet || set instanceof SparseNatBitSet;
    }

    public static NatBitSet longSet() {
        return new LongNatBitSet();
    }

    public static NatBitSet modifiableCopyOf(NatBitSet set) {
        return NatBitSets.modifiableCopyOf(set, Integer.MAX_VALUE);
    }

    public static NatBitSet modifiableCopyOf(NatBitSet set, @Nonnegative int length) {
        if (NatBitSets.isModifiable(set, length)) {
            return set.clone();
        }
        if (set instanceof BoundedNatBitSet && length <= ((BoundedNatBitSet)set).domainSize()) {
            return NatBitSets.modifiableCopyOf((BoundedNatBitSet)set);
        }
        NatBitSet copy = NatBitSets.set(set.size(), length);
        copy.or((IntCollection)set);
        assert (NatBitSets.isModifiable(copy, length) && copy.equals(set));
        return copy;
    }

    public static BoundedNatBitSet modifiableCopyOf(BoundedNatBitSet set) {
        if (NatBitSets.isModifiable(set)) {
            return set.clone();
        }
        BoundedNatBitSet copy = NatBitSets.boundedSet(set.domainSize(), set.size());
        copy.or((IntCollection)set);
        assert (NatBitSets.isModifiable(copy, set.domainSize()) && copy.equals(set));
        return copy;
    }

    public static Set<NatBitSet> powerSet(NatBitSet basis) {
        if (basis.isEmpty()) {
            return Collections.singleton(NatBitSets.emptySet());
        }
        return new PowerNatBitSet(basis);
    }

    public static Set<NatBitSet> powerSet(@Nonnegative int domainSize) {
        return NatBitSets.powerSet(NatBitSets.fullSet(domainSize));
    }

    public static int previousAbsentIndex(SparseBitSet set, @Nonnegative int index) {
        if (!set.get(index)) {
            return index;
        }
        int firstAbsentIndex = set.nextClearBit(0);
        if (firstAbsentIndex > index) {
            return -1;
        }
        int high = index - 1;
        int low = firstAbsentIndex;
        while (true) {
            assert (low <= high);
            int mid = (high + low) / 2;
            int next = set.nextClearBit(mid);
            while (next > index) {
                assert (low <= mid && mid <= high);
                high = mid;
                mid = (high + low) / 2;
                next = set.nextClearBit(mid);
            }
            assert (!set.get(next));
            low = next;
            int nextClear = set.nextClearBit(low + 1);
            if (nextClear > index) {
                return low;
            }
            low = nextClear;
        }
    }

    public static int previousPresentIndex(SparseBitSet set, @Nonnegative int index) {
        if (set.get(index)) {
            return index;
        }
        int firstPresentIndex = set.nextSetBit(0);
        if (firstPresentIndex == -1 || firstPresentIndex > index) {
            return -1;
        }
        int high = index - 1;
        int low = firstPresentIndex;
        while (true) {
            assert (low <= high);
            int mid = (high + low) / 2;
            int next = set.nextSetBit(mid);
            while (next == -1 || next > index) {
                assert (low <= mid && mid <= high);
                high = mid;
                mid = (high + low) / 2;
                next = set.nextSetBit(mid);
            }
            assert (set.get(next));
            low = next;
            int nextSet = set.nextSetBit(low + 1);
            if (nextSet == -1 || nextSet > index) {
                return low;
            }
            low = nextSet;
        }
    }

    public static NatBitSet set(int expectedSize, int expectedLength) {
        if (NatBitSets.useSparse(expectedSize, expectedLength)) {
            SparseBitSet backingSet = expectedLength == -1 ? new SparseBitSet() : new SparseBitSet(expectedLength);
            return new SparseNatBitSet(backingSet);
        }
        return new SimpleNatBitSet(new BitSet());
    }

    public static NatBitSet set() {
        return NatBitSets.set(-1, -1);
    }

    public static NatBitSet setWithExpectedLength(@Nonnegative int expectedLength) {
        return NatBitSets.set(-1, expectedLength);
    }

    public static NatBitSet setWithExpectedSize(@Nonnegative int expectedSize) {
        return NatBitSets.set(expectedSize, -1);
    }

    public static NatBitSet setWithMaximalLength(int maximalLength) {
        if (maximalLength < LongNatBitSet.maximalSize()) {
            return new LongNatBitSet();
        }
        return NatBitSets.set(-1, maximalLength);
    }

    public static NatBitSet simpleSet() {
        return new SimpleNatBitSet(new BitSet());
    }

    public static NatBitSet simpleSet(@Nonnegative int expectedSize) {
        return new SimpleNatBitSet(new BitSet(expectedSize));
    }

    public static NatBitSet singleton(@Nonnegative int element) {
        return new MutableSingletonNatBitSet(element);
    }

    public static NatBitSet sparseSet() {
        return new SparseNatBitSet(new SparseBitSet());
    }

    public static NatBitSet sparseSet(@Nonnegative int expectedSize) {
        return new SparseNatBitSet(new SparseBitSet(expectedSize));
    }

    public static BitSet toBitSet(NatBitSet indices) {
        if (indices.isEmpty()) {
            return new BitSet(0);
        }
        if (indices instanceof SimpleNatBitSet) {
            return (BitSet)((SimpleNatBitSet)indices).getBitSet().clone();
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet boundedSet = (SimpleBoundedNatBitSet)indices;
            BitSet bitSet = (BitSet)boundedSet.getBitSet().clone();
            if (boundedSet.isComplement()) {
                bitSet.flip(0, boundedSet.domainSize());
            }
            return bitSet;
        }
        if (indices instanceof SparseNatBitSet) {
            return BitSets.of(((SparseNatBitSet)indices).getSparseBitSet());
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet boundedSet = (SparseBoundedNatBitSet)indices;
            if (boundedSet.isComplement()) {
                BitSet bitSet = new BitSet(boundedSet.domainSize());
                boundedSet.forEach(bitSet::set);
                return bitSet;
            }
            return BitSets.of(boundedSet.getSparseBitSet());
        }
        BitSet bitSet = new BitSet(indices.lastInt() + 1);
        indices.forEach(bitSet::set);
        return bitSet;
    }

    public static SparseBitSet toSparseBitSet(NatBitSet indices) {
        if (indices.isEmpty()) {
            return new SparseBitSet(1);
        }
        if (indices instanceof SimpleNatBitSet) {
            return SparseBitSets.of(((SimpleNatBitSet)indices).getBitSet());
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet boundedSet = (SimpleBoundedNatBitSet)indices;
            if (boundedSet.isComplement()) {
                SparseBitSet bitSet = new SparseBitSet(boundedSet.domainSize());
                boundedSet.forEach(arg_0 -> ((SparseBitSet)bitSet).set(arg_0));
                return bitSet;
            }
            return SparseBitSets.of(boundedSet.getBitSet());
        }
        if (indices instanceof SparseNatBitSet) {
            return ((SparseNatBitSet)indices).getSparseBitSet().clone();
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet boundedSet = (SparseBoundedNatBitSet)indices;
            SparseBitSet bitSet = boundedSet.getSparseBitSet().clone();
            if (boundedSet.isComplement()) {
                bitSet.flip(0, boundedSet.domainSize());
            }
            return bitSet;
        }
        SparseBitSet bitSet = new SparseBitSet(indices.lastInt() + 1);
        indices.forEach(arg_0 -> ((SparseBitSet)bitSet).set(arg_0));
        return bitSet;
    }

    private static boolean useSparse(int expectedSize, int expectedLength) {
        if (expectedLength == -1) {
            if (expectedSize == -1) {
                return true;
            }
            if (expectedSize > 8192) {
                return true;
            }
        }
        return expectedLength > 8192 || expectedSize != -1 && expectedSize > 8192;
    }
}

