/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import java.util.BitSet;
import java.util.function.Consumer;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import owl.factories.ValuationSetFactory;

public class ValuationSet {
    private final ValuationSetFactory factory;

    protected ValuationSet(ValuationSetFactory factory) {
        this.factory = factory;
    }

    public final ValuationSetFactory getFactory() {
        return this.factory;
    }

    public final boolean isEmpty() {
        return this.equals(this.factory.empty());
    }

    public final boolean isUniverse() {
        return this.equals(this.factory.universe());
    }

    public final BitSet any() {
        return this.factory.any(this);
    }

    public final boolean contains(BitSet valuation) {
        return this.factory.contains(this, valuation);
    }

    public final boolean contains(ValuationSet other) {
        return this.factory.contains(this, other);
    }

    public final boolean intersects(ValuationSet other) {
        return this.factory.intersects(this, other);
    }

    public final void forEach(Consumer<? super BitSet> action) {
        this.factory.forEach(this, action);
    }

    public final void forEach(BitSet restriction, Consumer<? super BitSet> action) {
        this.factory.forEach(this, restriction, action);
    }

    public final ValuationSet complement() {
        return this.factory.complement(this);
    }

    public final ValuationSet union(ValuationSet other) {
        return this.factory.union(this, other);
    }

    public final ValuationSet intersection(ValuationSet other) {
        return this.factory.intersection(this, other);
    }

    public final BooleanExpression<AtomLabel> toExpression() {
        return this.factory.toExpression(this);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(this.factory.alphabetSize() * 10 + 10);
        builder.append('[');
        this.forEach(bitSet -> builder.append(bitSet).append(", "));
        builder.setLength(builder.length() - 2);
        builder.append(']');
        return builder.toString();
    }
}

