/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import owl.collections.Collections3;
import owl.collections.ValuationTree;

public final class ValuationTrees {
    private ValuationTrees() {
    }

    public static <E> ValuationTree<List<E>> cartesianProduct(List<ValuationTree<E>> trees) {
        switch (trees.size()) {
            case 0: {
                return ValuationTree.of(Set.of(List.of()));
            }
            case 1: {
                return trees.get(0).map(x -> x.stream().map(List::of).collect(Collectors.toUnmodifiableSet()));
            }
        }
        Iterator<ValuationTree<E>> iterator = trees.iterator();
        ValuationTree<List<E>> productTree = ValuationTrees.cartesianProduct(iterator.next(), iterator.next(), List::of);
        while (iterator.hasNext()) {
            productTree = ValuationTrees.cartesianProduct(productTree, iterator.next(), Collections3::add);
        }
        return productTree;
    }

    public static <K, V> ValuationTree<Map<K, V>> cartesianProduct(Map<K, ValuationTree<V>> trees) {
        switch (trees.size()) {
            case 0: {
                return ValuationTree.of(Set.of(Map.of()));
            }
            case 1: {
                Map.Entry entry = trees.entrySet().iterator().next();
                return entry.getValue().map(x -> x.stream().map(y -> Map.of(entry.getKey(), y)).collect(Collectors.toUnmodifiableSet()));
            }
        }
        Iterator<Map.Entry<K, ValuationTree<V>>> iterator = trees.entrySet().iterator();
        Map.Entry entry1 = iterator.next();
        Map.Entry entry2 = iterator.next();
        ValuationTree<Map<K, V>> productTree = ValuationTrees.cartesianProduct(entry1.getValue(), entry2.getValue(), (value1, value2) -> Map.of(entry1.getKey(), value1, entry2.getKey(), value2));
        while (iterator.hasNext()) {
            Map.Entry entryN = iterator.next();
            productTree = ValuationTrees.cartesianProduct(productTree, entryN.getValue(), (x, valueN) -> Map.copyOf(Collections3.add(x, entryN.getKey(), valueN)));
        }
        return productTree;
    }

    public static <E> ValuationTree<Set<E>> cartesianProduct(Set<ValuationTree<E>> trees) {
        switch (trees.size()) {
            case 0: {
                return ValuationTree.of(Set.of(Set.of()));
            }
            case 1: {
                return trees.iterator().next().map(x -> x.stream().map(Set::of).collect(Collectors.toUnmodifiableSet()));
            }
        }
        Iterator<ValuationTree<E>> iterator = trees.iterator();
        ValuationTree<Set<E>> productTree = ValuationTrees.cartesianProduct(iterator.next(), iterator.next(), (x, y) -> x.equals(y) ? Set.of(x) : Set.of(x, y));
        while (iterator.hasNext()) {
            productTree = ValuationTrees.cartesianProduct(productTree, iterator.next(), (x, y) -> x.contains(y) ? x : Set.copyOf(Collections3.add(x, y)));
        }
        return productTree;
    }

    public static <L, R, E> ValuationTree<E> cartesianProduct(ValuationTree<L> factor1, ValuationTree<R> factor2, BiFunction<L, R, @Nullable E> combinator) {
        return ValuationTrees.cartesianProduct(factor1, factor2, combinator, new HashMap());
    }

    public static <E> ValuationTree<E> union(Collection<ValuationTree<E>> trees) {
        switch (trees.size()) {
            case 0: {
                return ValuationTree.of();
            }
            case 1: {
                return trees.iterator().next();
            }
        }
        Iterator<ValuationTree<E>> iterator = trees.iterator();
        ValuationTree<E> unionTree = ValuationTrees.union(iterator.next(), iterator.next());
        while (iterator.hasNext()) {
            unionTree = ValuationTrees.union(unionTree, iterator.next());
        }
        return unionTree;
    }

    public static <E> ValuationTree<E> union(ValuationTree<E> tree1, ValuationTree<E> tree2) {
        return ValuationTrees.union(tree1, tree2, new HashMap());
    }

    private static <L, R, E> ValuationTree<E> cartesianProduct(ValuationTree<L> leftTree, ValuationTree<R> rightTree, BiFunction<L, R, @Nullable E> merger, Map<List<ValuationTree<?>>, ValuationTree<E>> memoizedCalls) {
        List<ValuationTree<R>> key = List.of(leftTree, rightTree);
        ValuationTree<E> cartesianProduct = memoizedCalls.get(key);
        if (cartesianProduct != null) {
            return cartesianProduct;
        }
        int variable = ValuationTrees.nextVariable(leftTree, rightTree);
        if (variable == Integer.MAX_VALUE) {
            HashSet<E> elements = new HashSet<E>();
            for (Object leftValue : ((ValuationTree.Leaf)leftTree).value) {
                for (Object rightValue : ((ValuationTree.Leaf)rightTree).value) {
                    E element = merger.apply(leftValue, rightValue);
                    if (element == null) continue;
                    elements.add(element);
                }
            }
            cartesianProduct = ValuationTree.of(elements);
        } else {
            ValuationTree<E> falseCartesianProduct = ValuationTrees.cartesianProduct(ValuationTrees.descendFalseIf(leftTree, variable), ValuationTrees.descendFalseIf(rightTree, variable), merger, memoizedCalls);
            ValuationTree<E> trueCartesianProduct = ValuationTrees.cartesianProduct(ValuationTrees.descendTrueIf(leftTree, variable), ValuationTrees.descendTrueIf(rightTree, variable), merger, memoizedCalls);
            cartesianProduct = ValuationTree.of(variable, trueCartesianProduct, falseCartesianProduct);
        }
        memoizedCalls.put(key, cartesianProduct);
        return cartesianProduct;
    }

    private static <E> ValuationTree<E> union(ValuationTree<E> tree1, ValuationTree<E> tree2, Map<Set<?>, ValuationTree<E>> memoizedCalls) {
        if (tree1.equals(tree2)) {
            return tree1;
        }
        Set<ValuationTree<E>> key = Set.of(tree1, tree2);
        ValuationTree<E> union = memoizedCalls.get(key);
        if (union != null) {
            return union;
        }
        int variable = ValuationTrees.nextVariable(tree1, tree2);
        if (variable == Integer.MAX_VALUE) {
            Set value1 = ((ValuationTree.Leaf)tree1).value;
            Set value2 = ((ValuationTree.Leaf)tree2).value;
            union = value1.isEmpty() ? tree2 : (value2.isEmpty() ? tree1 : ValuationTree.of(Set.copyOf(Sets.union(value1, value2))));
        } else {
            ValuationTree<E> falseUnionProduct = ValuationTrees.union(ValuationTrees.descendFalseIf(tree1, variable), ValuationTrees.descendFalseIf(tree2, variable), memoizedCalls);
            ValuationTree<E> trueUnionProduct = ValuationTrees.union(ValuationTrees.descendTrueIf(tree1, variable), ValuationTrees.descendTrueIf(tree2, variable), memoizedCalls);
            union = ValuationTree.of(variable, trueUnionProduct, falseUnionProduct);
        }
        memoizedCalls.put(key, union);
        return union;
    }

    private static int nextVariable(ValuationTree<?> tree1, ValuationTree<?> tree2) {
        int variable1 = tree1 instanceof ValuationTree.Node ? ((ValuationTree.Node)tree1).variable : Integer.MAX_VALUE;
        int variable2 = tree2 instanceof ValuationTree.Node ? ((ValuationTree.Node)tree2).variable : Integer.MAX_VALUE;
        return Math.min(variable1, variable2);
    }

    private static <E> ValuationTree<E> descendFalseIf(ValuationTree<E> tree, int variable) {
        if (tree instanceof ValuationTree.Node && ((ValuationTree.Node)tree).variable == variable) {
            return ((ValuationTree.Node)tree).falseChild;
        }
        return tree;
    }

    private static <E> ValuationTree<E> descendTrueIf(ValuationTree<E> tree, int variable) {
        if (tree instanceof ValuationTree.Node && ((ValuationTree.Node)tree).variable == variable) {
            return ((ValuationTree.Node)tree).trueChild;
        }
        return tree;
    }
}

