/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.PropositionalFormula;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.Visitor;

class SyntacticFairnessSimplifier
implements UnaryOperator<Formula> {
    static final UnaryOperator<Formula> INSTANCE = new TraverseRewriter(new SyntacticFairnessSimplifier(), SyntacticFairnessSimplifier::isApplicable);
    static final AlmostAllVisitor ALMOST_ALL_VISITOR = new AlmostAllVisitor();
    static final InfinitelyOftenVisitor INFINITELY_OFTEN_VISITOR = new InfinitelyOftenVisitor();

    SyntacticFairnessSimplifier() {
    }

    @Nullable
    static Formula getAlmostAllOperand(Formula formula) {
        if (formula instanceof FOperator) {
            FOperator fOperator = (FOperator)formula;
            if (fOperator.operand instanceof GOperator) {
                return ((GOperator)fOperator.operand).operand;
            }
        }
        return null;
    }

    @Nullable
    static Formula getInfinitelyOftenOperand(Formula formula) {
        if (formula instanceof GOperator) {
            GOperator gOperator = (GOperator)formula;
            if (gOperator.operand instanceof FOperator) {
                return ((FOperator)gOperator.operand).operand;
            }
        }
        return null;
    }

    public static boolean isApplicable(Formula formula) {
        return SyntacticFragment.FGX.contains(formula) && (SyntacticFairnessSimplifier.getAlmostAllOperand(formula) != null || SyntacticFairnessSimplifier.getInfinitelyOftenOperand(formula) != null);
    }

    public static boolean isApplicable2(Formula formula) {
        if (!SyntacticFragment.FGX.contains(formula)) {
            return false;
        }
        if (formula instanceof FOperator) {
            Formula operand = ((FOperator)formula).operand;
            while (operand instanceof XOperator) {
                operand = ((XOperator)operand).operand;
            }
            return operand instanceof GOperator;
        }
        if (formula instanceof GOperator) {
            Formula operand = ((GOperator)formula).operand;
            while (operand instanceof XOperator) {
                operand = ((XOperator)operand).operand;
            }
            return operand instanceof FOperator;
        }
        return false;
    }

    @Override
    public Formula apply(Formula formula) {
        assert (SyntacticFairnessSimplifier.isApplicable(formula));
        Formula almostAll = SyntacticFairnessSimplifier.getAlmostAllOperand(formula);
        if (almostAll != null) {
            return almostAll.accept(ALMOST_ALL_VISITOR);
        }
        Formula infinitelyOften = SyntacticFairnessSimplifier.getInfinitelyOftenOperand(formula);
        if (infinitelyOften != null) {
            return infinitelyOften.accept(INFINITELY_OFTEN_VISITOR);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    static class TraverseRewriter
    implements UnaryOperator<Formula>,
    Visitor<Formula> {
        private final Predicate<Formula> isApplicable;
        private final UnaryOperator<Formula> rewriter;

        TraverseRewriter(UnaryOperator<Formula> rewriter, Predicate<Formula> applicable) {
            this.rewriter = rewriter;
            this.isApplicable = applicable;
        }

        @Override
        public Formula apply(Formula formula) {
            return formula.accept(this);
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            if (this.isApplicable.test(booleanConstant)) {
                return (Formula)this.rewriter.apply(booleanConstant);
            }
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            if (this.isApplicable.test(conjunction)) {
                return (Formula)this.rewriter.apply(conjunction);
            }
            return Conjunction.of(conjunction.children.stream().map(this));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (this.isApplicable.test(disjunction)) {
                return (Formula)this.rewriter.apply(disjunction);
            }
            return Disjunction.of(disjunction.children.stream().map(this));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            if (this.isApplicable.test(fOperator)) {
                return (Formula)this.rewriter.apply(fOperator);
            }
            return FOperator.of(fOperator.operand.accept(this));
        }

        @Override
        public Formula visit(GOperator gOperator) {
            if (this.isApplicable.test(gOperator)) {
                return (Formula)this.rewriter.apply(gOperator);
            }
            return GOperator.of(gOperator.operand.accept(this));
        }

        @Override
        public Formula visit(Literal literal) {
            if (this.isApplicable.test(literal)) {
                return (Formula)this.rewriter.apply(literal);
            }
            return literal;
        }

        @Override
        public Formula visit(MOperator mOperator) {
            if (this.isApplicable.test(mOperator)) {
                return (Formula)this.rewriter.apply(mOperator);
            }
            return MOperator.of(mOperator.left.accept(this), mOperator.right.accept(this));
        }

        @Override
        public Formula visit(ROperator rOperator) {
            if (this.isApplicable.test(rOperator)) {
                return (Formula)this.rewriter.apply(rOperator);
            }
            return ROperator.of(rOperator.left.accept(this), rOperator.right.accept(this));
        }

        @Override
        public Formula visit(UOperator uOperator) {
            if (this.isApplicable.test(uOperator)) {
                return (Formula)this.rewriter.apply(uOperator);
            }
            return UOperator.of(uOperator.left.accept(this), uOperator.right.accept(this));
        }

        @Override
        public Formula visit(WOperator wOperator) {
            if (this.isApplicable.test(wOperator)) {
                return (Formula)this.rewriter.apply(wOperator);
            }
            return WOperator.of(wOperator.left.accept(this), wOperator.right.accept(this));
        }

        @Override
        public Formula visit(XOperator xOperator) {
            if (this.isApplicable.test(xOperator)) {
                return (Formula)this.rewriter.apply(xOperator);
            }
            return XOperator.of(xOperator.operand.accept(this));
        }
    }

    static final class NormaliseX
    implements BinaryVisitor<Integer, Formula> {
        static final NormaliseX UNGUARDED_INSTANCE = new NormaliseX();
        static final UnaryOperator<Formula> UNGUARDED_OPERATOR = f -> f.accept(UNGUARDED_INSTANCE, 0);
        static final UnaryOperator<Formula> INSTANCE = new TraverseRewriter(UNGUARDED_OPERATOR, SyntacticFairnessSimplifier::isApplicable);

        NormaliseX() {
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant, Integer depth) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction, Integer depth) {
            if (SyntacticFragment.FINITE.contains(conjunction)) {
                return XOperator.of(conjunction, depth);
            }
            return Conjunction.of(conjunction.map(x -> x.accept(this, depth)));
        }

        @Override
        public Formula visit(Disjunction disjunction, Integer depth) {
            if (SyntacticFragment.FINITE.contains(disjunction)) {
                return XOperator.of(disjunction, depth);
            }
            return Disjunction.of(disjunction.map(x -> x.accept(this, depth)));
        }

        @Override
        public Formula visit(FOperator fOperator, Integer depth) {
            return new FOperator(fOperator.operand.accept(this, 0));
        }

        @Override
        public Formula visit(GOperator gOperator, Integer depth) {
            return new GOperator(gOperator.operand.accept(this, 0));
        }

        @Override
        public Formula visit(Literal literal, Integer parameter) {
            return XOperator.of(literal, parameter);
        }

        @Override
        public Formula visit(XOperator xOperator, Integer parameter) {
            return xOperator.operand.accept(this, parameter + 1);
        }
    }

    private static final class InfinitelyOftenVisitor
    implements Visitor<Formula> {
        private InfinitelyOftenVisitor() {
        }

        private static Formula wrap(Formula formula) {
            if (formula instanceof BooleanConstant) {
                return formula;
            }
            return new GOperator(new FOperator(formula));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            if (SyntacticFragment.FINITE.contains(conjunction)) {
                return InfinitelyOftenVisitor.wrap(PropositionalFormula.shortCircuit(conjunction));
            }
            ArrayList<Formula> conjuncts = new ArrayList<Formula>();
            ArrayList xFragment = new ArrayList();
            ArrayList<Set<Formula>> disjuncts = new ArrayList<Set<Formula>>();
            conjunction.children.forEach(child -> {
                if (child instanceof FOperator) {
                    conjuncts.add(((FOperator)child).operand.accept(this));
                } else if (child instanceof GOperator) {
                    conjuncts.add(((GOperator)child).operand.accept(ALMOST_ALL_VISITOR));
                } else if (SyntacticFragment.FINITE.contains((Formula)child)) {
                    xFragment.add(child);
                } else {
                    assert (child instanceof Disjunction);
                    disjuncts.add(((PropositionalFormula)child).children);
                }
            });
            disjuncts.add(Set.of(Conjunction.of(xFragment)));
            Formula disjunction = Disjunction.of(Sets.cartesianProduct(disjuncts).stream().map(Conjunction::of));
            conjuncts.add(disjunction.accept(this));
            return PropositionalFormula.shortCircuit(Conjunction.of(conjuncts));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (SyntacticFragment.FINITE.contains(disjunction)) {
                return InfinitelyOftenVisitor.wrap(PropositionalFormula.shortCircuit(disjunction));
            }
            return PropositionalFormula.shortCircuit(Disjunction.of(disjunction.map(x -> x.accept(this))));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            return fOperator.operand.accept(this);
        }

        @Override
        public Formula visit(GOperator gOperator) {
            return gOperator.operand.accept(ALMOST_ALL_VISITOR);
        }

        @Override
        public Formula visit(Literal literal) {
            return InfinitelyOftenVisitor.wrap(literal);
        }

        @Override
        public Formula visit(XOperator xOperator) {
            return xOperator.operand.accept(this);
        }
    }

    private static final class AlmostAllVisitor
    implements Visitor<Formula> {
        private AlmostAllVisitor() {
        }

        private static Formula wrap(Formula formula) {
            if (formula instanceof BooleanConstant) {
                return formula;
            }
            return new FOperator(new GOperator(formula));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            if (SyntacticFragment.FINITE.contains(conjunction)) {
                return AlmostAllVisitor.wrap(PropositionalFormula.shortCircuit(conjunction));
            }
            return PropositionalFormula.shortCircuit(Conjunction.of(conjunction.map(x -> x.accept(this))));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (SyntacticFragment.FINITE.contains(disjunction)) {
                return AlmostAllVisitor.wrap(PropositionalFormula.shortCircuit(disjunction));
            }
            ArrayList<Formula> disjuncts = new ArrayList<Formula>();
            ArrayList xFragment = new ArrayList();
            ArrayList<Set<Formula>> conjuncts = new ArrayList<Set<Formula>>();
            disjunction.children.forEach(child -> {
                if (child instanceof FOperator) {
                    disjuncts.add(((FOperator)child).operand.accept(INFINITELY_OFTEN_VISITOR));
                } else if (child instanceof GOperator) {
                    disjuncts.add(((GOperator)child).operand.accept(this));
                } else if (SyntacticFragment.FINITE.contains((Formula)child)) {
                    xFragment.add(child);
                } else {
                    assert (child instanceof Conjunction);
                    conjuncts.add(((PropositionalFormula)child).children);
                }
            });
            conjuncts.add(Set.of(Disjunction.of(xFragment)));
            Formula conjunction = Conjunction.of(Sets.cartesianProduct(conjuncts).stream().map(Disjunction::of));
            disjuncts.add(conjunction.accept(this));
            return PropositionalFormula.shortCircuit(Disjunction.of(disjuncts));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            return fOperator.operand.accept(INFINITELY_OFTEN_VISITOR);
        }

        @Override
        public Formula visit(GOperator gOperator) {
            return gOperator.operand.accept(this);
        }

        @Override
        public Formula visit(Literal literal) {
            return AlmostAllVisitor.wrap(literal);
        }

        @Override
        public Formula visit(XOperator xOperator) {
            return xOperator.operand.accept(this);
        }
    }
}

