/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.fgx2dpa;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.PropositionalFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.UnaryModalOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.SimplifierFactory;
import owl.ltl.visitors.PropositionalVisitor;
import owl.ltl.visitors.Visitor;
import owl.run.Environment;
import owl.translations.fgx2dpa.Monitor;
import owl.translations.fgx2dpa.PromisedSet;
import owl.translations.fgx2dpa.State;
import owl.translations.fgx2dpa.StateReduction;

public final class SafetyAutomaton {
    private SafetyAutomaton() {
    }

    public static MutableAutomaton<State, ParityAcceptance> build(Environment env, LabelledFormula labelledFormula2) {
        BigInteger estimateNegation;
        LabelledFormula labelledFormula = labelledFormula2.wrap(SimplifierFactory.apply(labelledFormula2.formula(), SimplifierFactory.Mode.SYNTACTIC_FIXPOINT));
        Preconditions.checkArgument((SyntacticFragment.FGX.contains(labelledFormula.formula()) && SyntacticFragment.NNF.contains(labelledFormula.formula()) ? 1 : 0) != 0, (Object)"Formula is not from the syntactic fgx and nnf fragment.");
        Set<Set<UnaryModalOperator>> promisedSetsFormula = labelledFormula.formula().accept(OutsideGVisitor.INSTANCE);
        int promisedSetCount = promisedSetsFormula.size();
        if (promisedSetCount == 1 && ((Set)Iterables.getOnlyElement(promisedSetsFormula)).isEmpty()) {
            return SafetyAutomaton.construct(labelledFormula, promisedSetsFormula, ParityAcceptance.Parity.MIN_EVEN, env);
        }
        LabelledFormula labelledFormulaNegation = labelledFormula.not();
        Set<Set<UnaryModalOperator>> promisedSetsNegation = labelledFormulaNegation.formula().accept(OutsideGVisitor.INSTANCE);
        int negationPromisedSetCount = promisedSetsNegation.size();
        if (negationPromisedSetCount == 1 && ((Set)Iterables.getOnlyElement(promisedSetsNegation)).isEmpty()) {
            return SafetyAutomaton.construct(labelledFormulaNegation, promisedSetsNegation, ParityAcceptance.Parity.MIN_ODD, env);
        }
        BigInteger estimateFormula = SafetyAutomaton.estimate(promisedSetsFormula);
        int compare = estimateFormula.compareTo(estimateNegation = SafetyAutomaton.estimate(promisedSetsNegation));
        if (compare < 0 || compare == 0 && promisedSetCount <= negationPromisedSetCount) {
            return SafetyAutomaton.construct(labelledFormula, promisedSetsFormula, ParityAcceptance.Parity.MIN_EVEN, env);
        }
        return SafetyAutomaton.construct(labelledFormulaNegation, promisedSetsNegation, ParityAcceptance.Parity.MIN_ODD, env);
    }

    private static BigInteger estimate(Set<Set<UnaryModalOperator>> promisedSets) {
        BigInteger estimatedPermutations = BigInteger.ONE;
        long nonFinalG = promisedSets.stream().filter(l -> l.stream().anyMatch(g -> g instanceof GOperator && g.operand.accept(FinalStateVisitor.INSTANCE) == false)).count();
        for (Set<UnaryModalOperator> list : promisedSets) {
            long count = list.stream().filter(f -> f instanceof FOperator && f.operand.accept(FinalStateVisitor.INSTANCE) == false).count();
            if (count <= 1L) continue;
            estimatedPermutations = estimatedPermutations.multiply(BigInteger.valueOf(count));
        }
        for (long i = nonFinalG; i >= 2L; --i) {
            estimatedPermutations = estimatedPermutations.multiply(BigInteger.valueOf(i));
        }
        return estimatedPermutations;
    }

    private static MutableAutomaton<State, ParityAcceptance> construct(LabelledFormula labelledFormula, Set<Set<UnaryModalOperator>> promisedSets, ParityAcceptance.Parity parity, Environment env) {
        Formula formula = labelledFormula.formula();
        Formula unfolded = formula.unfold();
        HashSet<GOperator> gFormulae = new HashSet<GOperator>();
        HashSet<FOperator> fFormulae = new HashSet<FOperator>();
        for (UnaryModalOperator modal : Iterables.concat(promisedSets)) {
            if (modal instanceof GOperator) {
                gFormulae.add((GOperator)modal);
                continue;
            }
            fFormulae.add((FOperator)modal);
        }
        Set<Monitor<GOperator>> monitorsG = Collections3.transformSet(gFormulae, Monitor::of);
        Set<Monitor<FOperator>> monitorsF = Collections3.transformSet(fFormulae, Monitor::of);
        List<Object> initialPermutation = new ArrayList(promisedSets.size());
        for (Set<UnaryModalOperator> set : promisedSets) {
            Set<GOperator> formulaeG = set.stream().filter(GOperator.class::isInstance).map(GOperator.class::cast).collect(Collectors.toUnmodifiableSet());
            List<FOperator> formulaeF = set.stream().filter(FOperator.class::isInstance).map(FOperator.class::cast).sorted(Comparator.comparingInt(f -> f.operand.accept(FinalStateVisitor.INSTANCE) != false ? 1 : 0)).collect(Collectors.toUnmodifiableList());
            initialPermutation.add(PromisedSet.of(formulaeG, formulaeF));
        }
        initialPermutation = initialPermutation.stream().sorted(Comparator.comparingLong(PromisedSet::nonFinalGCount).reversed()).collect(Collectors.toUnmodifiableList());
        Factories factories = env.factorySupplier().getFactories(labelledFormula.variables());
        EquivalenceClassFactory eqFactory = factories.eqFactory;
        int initialPriority = formula.equals(BooleanConstant.TRUE) ? 2 : (formula.equals(BooleanConstant.FALSE) ? 3 : initialPermutation.size() * 2 + 1);
        State initialState = State.of(unfolded, monitorsG, monitorsF, initialPriority, initialPermutation);
        ParityAcceptance acceptance = new ParityAcceptance(initialPermutation.size() * 2 + 2, parity);
        Automaton<State, ParityAcceptance> automaton = AutomatonFactory.create(factories.vsFactory, initialState, acceptance, (state, valuation) -> {
            List<PromisedSet> previousPermutation;
            Set<Monitor<FOperator>> newMonitorsF;
            Set<Monitor<GOperator>> newMonitorsG;
            Formula successor = state.formula().temporalStepUnfold((BitSet)valuation);
            if (successor instanceof BooleanConstant) {
                return Edge.of(State.of((BooleanConstant)successor), state.priority());
            }
            if (successor.equals(state.formula())) {
                newMonitorsG = state.monitorsG().stream().map(s -> s.temporalStep((BitSet)valuation)).collect(Collectors.toUnmodifiableSet());
                newMonitorsF = state.monitorsF().stream().map(s -> s.temporalStep((BitSet)valuation)).collect(Collectors.toUnmodifiableSet());
                previousPermutation = state.permutation();
            } else {
                Set<GOperator> gOperators = state.formula().subformulas(GOperator.class);
                HashSet<FOperator> fOperators = new HashSet<FOperator>();
                for (GOperator g : gOperators) {
                    fOperators.addAll(g.subformulas(FOperator.class));
                }
                Sets.SetView formulas = Sets.union(gOperators, fOperators);
                newMonitorsG = state.monitorsG().stream().filter(s -> gOperators.contains(s.formula())).map(s -> s.temporalStep((BitSet)valuation)).collect(Collectors.toUnmodifiableSet());
                newMonitorsF = state.monitorsF().stream().filter(s -> fOperators.contains(s.formula())).map(s -> s.temporalStep((BitSet)valuation)).collect(Collectors.toUnmodifiableSet());
                previousPermutation = state.permutation().stream().filter(arg_0 -> SafetyAutomaton.lambda$construct$10((Set)formulas, arg_0)).collect(Collectors.toUnmodifiableList());
            }
            int priority = previousPermutation.size() * 2 + 1;
            ArrayList<PromisedSet> currentPermutation = new ArrayList<PromisedSet>(previousPermutation.size());
            ArrayList<PromisedSet> goodOrNeutral = new ArrayList<PromisedSet>();
            for (int promIndex = previousPermutation.size() - 1; promIndex >= 0; --promIndex) {
                PromisedSet promisedSet = previousPermutation.get(promIndex);
                HashSet<Formula> alpha = new HashSet<Formula>();
                if (promisedSet.formulaeF().isEmpty()) {
                    alpha.add(BooleanConstant.TRUE);
                } else {
                    alpha.addAll(promisedSet.formulaeF());
                }
                PromisedSetAcceptanceVisitor violationVisitor = new PromisedSetAcceptanceVisitor(promisedSet, false);
                boolean violation = false;
                for (Formula formula : promisedSet.formulaeG()) {
                    Monitor monitor = newMonitorsG.stream().filter(s -> ((GOperator)s.formula()).equals(g)).findFirst().orElseThrow();
                    if (Iterables.any(monitor.finalStates(), t -> t.accept(violationVisitor))) {
                        violation = true;
                        break;
                    }
                    alpha.add(formula);
                    monitor.nonFinalStates().forEach(t -> alpha.add(t.substitute(f -> {
                        if (f instanceof FOperator) {
                            return promisedSet.formulaeF().contains(f) ? f : BooleanConstant.FALSE;
                        }
                        if (f instanceof GOperator) {
                            return promisedSet.formulaeG().contains(f) ? f : BooleanConstant.FALSE;
                        }
                        return f;
                    })));
                }
                if (violation) {
                    currentPermutation.add(0, promisedSet);
                    priority = Integer.min((previousPermutation.size() - promIndex) * 2 - 1, priority);
                    continue;
                }
                EquivalenceClass conjunctClass = eqFactory.of(Conjunction.of(alpha));
                EquivalenceClass equivalenceClass = eqFactory.of(successor);
                PromisedSetAcceptanceVisitor satisfactionVisitor = new PromisedSetAcceptanceVisitor(promisedSet, true);
                if (conjunctClass.implies(equivalenceClass)) {
                    if (promisedSet.formulaeF().isEmpty()) {
                        goodOrNeutral.add(0, promisedSet);
                        priority = Integer.min((previousPermutation.size() - promIndex) * 2, priority);
                        continue;
                    }
                    boolean reset = false;
                    Formula currentFirstF = promisedSet.formulaeF().get(0);
                    ArrayDeque<FOperator> deque = new ArrayDeque<FOperator>(promisedSet.formulaeF());
                    do {
                        FOperator fFormula = (FOperator)deque.pollFirst();
                        Set<Formula> finalTokens = newMonitorsF.stream().filter(s -> ((FOperator)s.formula()).equals(fFormula)).findFirst().orElseThrow().finalStates();
                        if (Iterables.any(finalTokens, t -> t.accept(satisfactionVisitor))) {
                            deque.addLast(fFormula);
                            if (!((FOperator)deque.peekFirst()).equals(promisedSet.firstF())) continue;
                            reset = true;
                            continue;
                        }
                        deque.addFirst(fFormula);
                        break;
                    } while (!currentFirstF.equals(deque.peekFirst()));
                    goodOrNeutral.add(0, PromisedSet.of(promisedSet.formulaeG(), new ArrayList<FOperator>(deque), promisedSet.firstF()));
                    if (!reset) continue;
                    priority = Integer.min((previousPermutation.size() - promIndex) * 2, priority);
                    continue;
                }
                goodOrNeutral.add(0, promisedSet);
            }
            currentPermutation.addAll(goodOrNeutral);
            State newState = State.of(successor, newMonitorsG, newMonitorsF, priority, currentPermutation);
            return Edge.of(newState, state.priority());
        });
        HashMap reduction = new HashMap();
        HashMap reductionMap = new HashMap();
        Automaton.EdgeMapVisitor<State> visitor = (state, edgeMap) -> {
            Map<State, ValuationSet> successors = Collections3.transformMap(edgeMap, Edge::successor);
            reductionMap.put(state, reduction.computeIfAbsent(StateReduction.of(state, successors), k -> state));
        };
        automaton.accept(visitor);
        Automaton<State, ParityAcceptance> reducedAutomaton = AutomatonFactory.create(factories.vsFactory, (State)reductionMap.get(initialState), acceptance, (state, valuation) -> {
            State successor = automaton.successor((State)state, (BitSet)valuation);
            assert (successor != null);
            return Edge.of((State)reductionMap.get(successor), successor.priority());
        });
        return MutableAutomatonUtil.asMutable(reducedAutomaton);
    }

    private static /* synthetic */ boolean lambda$construct$10(Set formulas, PromisedSet p) {
        return formulas.containsAll(p.union());
    }

    private static final class PromisedSetAcceptanceVisitor
    implements Visitor<Boolean> {
        private final PromisedSet promisedSet;
        private final boolean satisfaction;

        PromisedSetAcceptanceVisitor(PromisedSet promisedSet, boolean satisfaction) {
            this.promisedSet = promisedSet;
            this.satisfaction = satisfaction;
        }

        @Override
        public Boolean visit(Literal literal) {
            return false;
        }

        @Override
        public Boolean visit(XOperator xOperator) {
            return false;
        }

        @Override
        public Boolean visit(BooleanConstant constant) {
            return constant.equals(this.satisfaction ? BooleanConstant.TRUE : BooleanConstant.FALSE);
        }

        @Override
        public Boolean visit(Conjunction conjunction) {
            return this.satisfaction ? Iterables.all((Iterable)conjunction.children, x -> x.accept(this)) : Iterables.any((Iterable)conjunction.children, x -> x.accept(this));
        }

        @Override
        public Boolean visit(Disjunction disjunction) {
            return this.satisfaction ? Iterables.any((Iterable)disjunction.children, x -> x.accept(this)) : Iterables.all((Iterable)disjunction.children, x -> x.accept(this));
        }

        @Override
        public Boolean visit(FOperator fOperator) {
            return this.satisfaction == this.promisedSet.formulaeF().contains(fOperator);
        }

        @Override
        public Boolean visit(GOperator gOperator) {
            return this.satisfaction == this.promisedSet.formulaeG().contains(gOperator);
        }
    }

    private static final class InsideGVisitor
    extends PromisedSetVisitor {
        static final InsideGVisitor INSTANCE = new InsideGVisitor();

        private InsideGVisitor() {
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(FOperator fOperator) {
            Set<Set<UnaryModalOperator>> sets = fOperator.operand.accept(this);
            sets.forEach(s -> s.add(fOperator));
            return sets;
        }
    }

    private static final class OutsideGVisitor
    extends PromisedSetVisitor {
        static final OutsideGVisitor INSTANCE = new OutsideGVisitor();

        private OutsideGVisitor() {
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(FOperator fOperator) {
            return fOperator.operand.accept(this);
        }
    }

    private static abstract class PromisedSetVisitor
    implements Visitor<Set<Set<UnaryModalOperator>>> {
        private PromisedSetVisitor() {
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(BooleanConstant booleanConstant) {
            return Set.of(new HashSet());
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(Conjunction conjunction) {
            return conjunction.map(c -> c.accept(this)).reduce((firstSet, secondSet) -> {
                HashSet innerSets = new HashSet();
                firstSet.forEach(f -> secondSet.forEach(s -> innerSets.add(new HashSet(Sets.union((Set)f, (Set)s)))));
                return innerSets;
            }).orElseThrow();
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(Disjunction disjunction) {
            return disjunction.map(x -> x.accept(this)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(GOperator gOperator) {
            Set<Set<UnaryModalOperator>> sets = gOperator.operand.accept(InsideGVisitor.INSTANCE);
            sets.forEach(s -> s.add(gOperator));
            return sets;
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(Literal literal) {
            return Set.of(new HashSet());
        }

        @Override
        public Set<Set<UnaryModalOperator>> visit(XOperator xOperator) {
            return xOperator.operand.accept(this);
        }
    }

    static final class FinalStateVisitor
    extends PropositionalVisitor<Boolean> {
        static final FinalStateVisitor INSTANCE = new FinalStateVisitor();

        private FinalStateVisitor() {
        }

        @Override
        public Boolean visit(Formula.TemporalOperator formula) {
            return !(formula instanceof Literal) && !(formula instanceof XOperator);
        }

        @Override
        public Boolean visit(BooleanConstant booleanConstant) {
            return true;
        }

        @Override
        public Boolean visit(Conjunction conjunction) {
            return this.visitPropositional(conjunction);
        }

        @Override
        public Boolean visit(Disjunction disjunction) {
            return this.visitPropositional(disjunction);
        }

        private Boolean visitPropositional(PropositionalFormula propositionalFormula) {
            return propositionalFormula.children.stream().allMatch(c -> c.accept(this));
        }
    }
}

