/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import org.apache.commons.cli.CommandLine;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.modules.AbstractLTL2LDBAModule;

public final class LTL2LDGBAModule
extends AbstractLTL2LDBAModule {
    public static final LTL2LDGBAModule INSTANCE = new LTL2LDGBAModule();

    private LTL2LDGBAModule() {
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder(INSTANCE.getKey()).reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).writer(OutputWriters.HOA).build());
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        if (commandLine.hasOption(LTL2LDGBAModule.symmetric().getOpt())) {
            return environment -> Transformers.instanceFromFunction(LabelledFormula.class, SymmetricLDBAConstruction.of(environment, GeneralizedBuchiAcceptance.class).andThen(AnnotatedLDBA::copyAsMutable));
        }
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, AsymmetricLDBAConstruction.of(environment, GeneralizedBuchiAcceptance.class).andThen(AnnotatedLDBA::copyAsMutable));
    }

    @Override
    public String getKey() {
        return "ltl2ldgba";
    }

    @Override
    public String getDescription() {
        return "Translate LTL to limit-deterministic generalized B\u00fcchi automata.";
    }
}

