/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.AbstractBoundedNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSetsUtil;
import de.tum.in.naturals.set.ReverseRangeIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;

class BoundedMutableSingletonNatBitSet
extends AbstractBoundedNatBitSet {
    private static final int EMPTY = Integer.MIN_VALUE;
    private final boolean complement;
    private final BoundedMutableSingletonNatBitSet complementView;
    private final int[] store;

    private BoundedMutableSingletonNatBitSet(int element, @Nonnegative int domainSize, boolean complement) {
        super(domainSize);
        this.store = new int[]{element};
        this.complement = complement;
        this.complementView = new BoundedMutableSingletonNatBitSet(this);
    }

    private BoundedMutableSingletonNatBitSet(BoundedMutableSingletonNatBitSet other) {
        super(other.domainSize());
        this.complementView = other;
        this.complement = !other.complement;
        this.store = other.store;
    }

    BoundedMutableSingletonNatBitSet(@Nonnegative int element, @Nonnegative int domainSize) {
        this(element, domainSize, false);
        NatBitSetsUtil.checkNonNegative(element);
    }

    BoundedMutableSingletonNatBitSet(@Nonnegative int domainSize) {
        this(Integer.MIN_VALUE, domainSize, false);
    }

    private static UnsupportedOperationException unsupportedOperation() {
        return new UnsupportedOperationException("Singleton can hold at most one value");
    }

    @Override
    public void clear(int index) {
        this.checkInDomain(index);
        if (this.complement) {
            if (this.isStoreEmpty()) {
                this.setStoreValue(index);
            } else if (index != this.store[0]) {
                throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
            }
        } else {
            assert (index != Integer.MIN_VALUE);
            if (index == this.store[0]) {
                this.setStoreEmpty();
            }
        }
    }

    @Override
    public void clear(int from, int to) {
        this.checkInDomain(from, to);
        if (from == to) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.complement) {
            if (from + 1 != to) {
                throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
            }
            if (this.isStoreEmpty()) {
                this.setStoreValue(from);
            } else if (from != this.store[0]) {
                throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
            }
        } else if (from <= this.store[0] && this.store[0] < to) {
            this.setStoreEmpty();
        }
    }

    public void clear() {
        if (this.complement) {
            if (this.domainSize() > 1) {
                throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
            }
            this.setStoreValue(0);
        } else {
            this.setStoreEmpty();
        }
    }

    @Override
    public BoundedMutableSingletonNatBitSet clone() {
        return (BoundedMutableSingletonNatBitSet)super.clone();
    }

    @Override
    public BoundedNatBitSet complement() {
        return this.complementView;
    }

    public boolean contains(int index) {
        return index >= 0 && (this.complement ? this.store[0] != index : this.store[0] == index);
    }

    @Override
    public int firstInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.complement) {
            return this.store[0] == 0 ? 1 : 0;
        }
        return this.store[0];
    }

    @Override
    public void flip(int index) {
        this.checkInDomain(index);
        if (index == this.store[0]) {
            this.setStoreEmpty();
        } else if (this.isStoreEmpty()) {
            this.setStoreValue(index);
        } else {
            throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
        }
    }

    @Override
    public void flip(int from, int to) {
        this.checkInDomain(from, to);
        if (from == to) {
            return;
        }
        if (from + 1 != to) {
            throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
        }
        this.flip(from);
    }

    @Override
    boolean isComplement() {
        return this.complement;
    }

    public boolean isEmpty() {
        return this.complement ? this.domainSize() == 1 && !this.isStoreEmpty() : this.isStoreEmpty();
    }

    private boolean isStoreEmpty() {
        return this.store[0] == Integer.MIN_VALUE;
    }

    @Override
    public IntIterator iterator() {
        if (this.isStoreEmpty()) {
            return this.complement ? IntIterators.fromTo((int)0, (int)this.domainSize()) : IntIterators.EMPTY_ITERATOR;
        }
        if (this.complement) {
            IntListIterator first = IntIterators.fromTo((int)0, (int)this.store[0]);
            IntListIterator second = IntIterators.fromTo((int)(this.store[0] + 1), (int)this.domainSize());
            return IntIterators.concat((IntIterator[])new IntIterator[]{first, second});
        }
        return IntIterators.singleton((int)this.store[0]);
    }

    @Override
    public int lastInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.complement) {
            int domainSize;
            return domainSize - (this.store[0] == (domainSize = this.domainSize()) - 1 ? 2 : 1);
        }
        return this.store[0];
    }

    @Override
    public int nextAbsentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.complement) {
            return index <= this.store[0] ? this.store[0] : this.domainSize();
        }
        return !this.isEmpty() && index == this.store[0] ? this.store[0] + 1 : index;
    }

    @Override
    public int nextPresentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            return -1;
        }
        if (this.domainSize() <= index) {
            return -1;
        }
        if (this.complement) {
            return index == this.store[0] ? index + 1 : index;
        }
        return index <= this.store[0] ? this.store[0] : -1;
    }

    @Override
    public int previousAbsentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            return index;
        }
        if (this.complement) {
            return index >= this.store[0] ? this.store[0] : -1;
        }
        return index == this.store[0] ? this.store[0] - 1 : index;
    }

    @Override
    public int previousPresentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            return -1;
        }
        if (this.complement) {
            return index == this.store[0] ? this.store[0] - 1 : index;
        }
        return index >= this.store[0] ? this.store[0] : -1;
    }

    @Override
    public IntIterator reverseIterator() {
        if (this.isStoreEmpty()) {
            return this.complement ? new ReverseRangeIterator(0, this.domainSize()) : IntIterators.EMPTY_ITERATOR;
        }
        if (this.complement) {
            ReverseRangeIterator first = new ReverseRangeIterator(this.store[0] + 1, this.domainSize());
            ReverseRangeIterator second = new ReverseRangeIterator(0, this.store[0]);
            return IntIterators.concat((IntIterator[])new IntIterator[]{first, second});
        }
        return IntIterators.singleton((int)this.store[0]);
    }

    @Override
    public void set(int index) {
        this.checkInDomain(index);
        if (this.complement) {
            if (index == this.store[0]) {
                this.setStoreEmpty();
            }
        } else if (this.isStoreEmpty()) {
            this.store[0] = index;
        } else if (index != this.store[0]) {
            throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
        }
    }

    @Override
    public void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    @Override
    public void set(int from, int to) {
        this.checkInDomain(from, to);
        if (from == to) {
            return;
        }
        if (from + 1 != to) {
            throw BoundedMutableSingletonNatBitSet.unsupportedOperation();
        }
        this.set(from);
    }

    private void setStoreEmpty() {
        this.store[0] = Integer.MIN_VALUE;
    }

    private void setStoreValue(int value) {
        assert (value >= 0 && this.isEmpty());
        this.store[0] = value;
    }

    public int size() {
        if (this.complement) {
            return this.isStoreEmpty() ? this.domainSize() : this.domainSize() - 1;
        }
        return this.isStoreEmpty() ? 0 : 1;
    }
}

