/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.ast;

import jhoafparser.ast.Atom;

public class AtomLabel
implements Atom {
    private Type type = null;
    private Integer apIndex = null;
    private String aliasName = null;

    private AtomLabel() {
    }

    public static AtomLabel createAPIndex(Integer apIndex) {
        AtomLabel result = new AtomLabel();
        result.type = Type.AP_INDEX;
        result.apIndex = apIndex;
        return result;
    }

    public static AtomLabel createAlias(String aliasName) {
        AtomLabel result = new AtomLabel();
        result.type = Type.ALIAS;
        result.aliasName = aliasName;
        return result;
    }

    @Override
    public AtomLabel clone() {
        if (this.isAlias()) {
            return AtomLabel.createAlias(this.aliasName);
        }
        return AtomLabel.createAPIndex(this.apIndex);
    }

    public boolean isAlias() {
        return this.type == Type.ALIAS;
    }

    public String getAliasName() {
        if (!this.isAlias()) {
            throw new UnsupportedOperationException(this.toString() + " is not an alias");
        }
        return this.aliasName;
    }

    public int getAPIndex() {
        if (this.isAlias()) {
            throw new UnsupportedOperationException(this.toString() + " is not an AP index");
        }
        return this.apIndex;
    }

    public String toString() {
        switch (this.type) {
            case AP_INDEX: {
                return this.apIndex.toString();
            }
            case ALIAS: {
                return "@" + this.aliasName;
            }
        }
        throw new RuntimeException("Unhandled type");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliasName == null ? 0 : this.aliasName.hashCode());
        result = 31 * result + (this.apIndex == null ? 0 : this.apIndex.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AtomLabel)) {
            return false;
        }
        AtomLabel other = (AtomLabel)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.aliasName == null ? other.aliasName != null : !this.aliasName.equals(other.aliasName)) {
            return false;
        }
        return !(this.apIndex == null ? other.apIndex != null : !this.apIndex.equals(other.apIndex));
    }

    private static enum Type {
        AP_INDEX,
        ALIAS;

    }
}

