/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.consumer;

import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredState;

public class HOAConsumerStore
implements HOAConsumer {
    private StoredAutomaton storedAutomaton = new StoredAutomaton();
    private boolean done = false;

    public StoredAutomaton getStoredAutomaton() {
        if (!this.done) {
            throw new UnsupportedOperationException("Automaton not fully constructed");
        }
        return this.storedAutomaton;
    }

    public void setStoredAutomaton(StoredAutomaton aut) {
        this.storedAutomaton = aut;
    }

    @Override
    public boolean parserResolvesAliases() {
        return false;
    }

    @Override
    public void notifyHeaderStart(String version) throws HOAConsumerException {
    }

    @Override
    public void setNumberOfStates(int numberOfStates) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().setNumberOfStates(numberOfStates);
    }

    @Override
    public void addStartStates(List<Integer> stateConjunction) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().addStartStates(stateConjunction);
    }

    @Override
    public void addAlias(String name, BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().addAlias(name, this.storedAutomaton.findOrAdd(labelExpr));
    }

    @Override
    public void setAPs(List<String> aps) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().setAPs(aps);
    }

    @Override
    public void setAcceptanceCondition(int numberOfSets, BooleanExpression<AtomAcceptance> accExpr) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().setAcceptanceCondition(numberOfSets, accExpr);
    }

    @Override
    public void provideAcceptanceName(String name, List<Object> extraInfo) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().provideAcceptanceName(name, extraInfo);
    }

    @Override
    public void setName(String name) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().setName(name);
    }

    @Override
    public void setTool(String name, String version) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().setTool(name, version);
    }

    @Override
    public void addProperties(List<String> properties) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().addProperties(properties);
    }

    @Override
    public void addMiscHeader(String name, List<Object> content) throws HOAConsumerException {
        this.storedAutomaton.getStoredHeader().addMiscHeader(name, content);
    }

    @Override
    public void notifyBodyStart() throws HOAConsumerException {
    }

    @Override
    public void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, List<Integer> accSignature) throws HOAConsumerException {
        this.storedAutomaton.addState(new StoredState(id, info, this.storedAutomaton.findOrAdd(labelExpr), this.storedAutomaton.findOrAdd(accSignature)));
    }

    @Override
    public void addEdgeImplicit(int stateId, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        this.storedAutomaton.addEdgeImplicit(stateId, new StoredEdgeImplicit(this.storedAutomaton.findOrAdd(conjSuccessors), this.storedAutomaton.findOrAdd(accSignature)));
    }

    @Override
    public void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        this.storedAutomaton.addEdgeWithLabel(stateId, new StoredEdgeWithLabel(this.storedAutomaton.findOrAdd(labelExpr), this.storedAutomaton.findOrAdd(conjSuccessors), this.storedAutomaton.findOrAdd(accSignature)));
    }

    @Override
    public void notifyEndOfState(int stateId) throws HOAConsumerException {
    }

    @Override
    public void notifyEnd() throws HOAConsumerException {
        this.done = true;
    }

    @Override
    public void notifyAbort() {
        this.done = true;
        this.storedAutomaton = null;
    }

    @Override
    public void notifyWarning(String warning) throws HOAConsumerException {
    }
}

