/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BitUtil;
import de.tum.in.jbdd.MathUtil;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

class NodeTable {
    public static final int NODE_IDENTIFIER_BIT_SIZE = 25;
    private static final int CHAIN_REFERENCE_BIT_SIZE = 25;
    private static final int INITIAL_STACK_SIZE = 32;
    private static final long LIST_REFERENCE_MASK = BitUtil.maskLength(25);
    private static final int LOW_OFFSET = 1;
    private static final int REFERENCE_COUNT_BIT_SIZE = 13;
    private static final long MAXIMAL_REFERENCE_COUNT = 8191L;
    private static final long REFERENCE_COUNT_MASK = BitUtil.maskLength(13);
    private static final int REFERENCE_COUNT_OFFSET = 1;
    private static final int CHAIN_NEXT_OFFSET = 14;
    private static final int CHAIN_START_OFFSET = 39;
    private static final int TREE_REFERENCE_BIT_SIZE = 25;
    private static final int HIGH_OFFSET = 26;
    private static final long TREE_REFERENCE_MASK = BitUtil.maskLength(25);
    private static final int VARIABLE_BIT_SIZE = 13;
    private static final long INVALID_NODE_VALUE = BitUtil.maskLength(13);
    private static final int VARIABLE_OFFSET = 51;
    private static final Logger logger = Logger.getLogger(NodeTable.class.getName());
    private final BddConfiguration configuration;
    private int approximateDeadNodeCount = 0;
    private int biggestReferencedNode;
    private int biggestValidNode;
    private int firstFreeNode;
    private int freeNodeCount;
    private int[] markStack;
    private long[] nodeStorage;
    private long[] referenceStorage;
    private int treeSize = 0;
    private int[] workStack;
    private int workStackTos = 0;

    NodeTable(int nodeSize, BddConfiguration configuration) {
        this.configuration = configuration;
        int nodeCount = Math.max(nodeSize, configuration.minimumNodeTableSize());
        this.nodeStorage = new long[nodeCount];
        this.referenceStorage = new long[nodeCount];
        this.firstFreeNode = 2;
        this.freeNodeCount = nodeCount - 2;
        this.biggestReferencedNode = 1;
        this.biggestValidNode = 1;
        Arrays.fill(this.nodeStorage, 2, nodeCount, NodeTable.invalidStore());
        for (int i = 0; i < nodeCount - 1; ++i) {
            this.referenceStorage[i] = NodeTable.startNoneAndNextStore(i + 1);
        }
        this.referenceStorage[nodeCount - 1] = NodeTable.startNoneAndNextStore(0);
        this.nodeStorage[0] = NodeTable.buildNodeStore(INVALID_NODE_VALUE, 0L, 0L);
        this.nodeStorage[1] = NodeTable.buildNodeStore(INVALID_NODE_VALUE, 1L, 1L);
        this.referenceStorage[0] = NodeTable.saturateStore(this.referenceStorage[0]);
        this.referenceStorage[1] = NodeTable.saturateStore(this.referenceStorage[1]);
        this.workStack = new int[32];
        this.markStack = new int[32];
    }

    private static long buildNodeStore(long variable, long low, long high) {
        assert (BitUtil.fits(variable, 13) && BitUtil.fits(low, 25) && BitUtil.fits(high, 25)) : "Bit size exceeded";
        long store = 0L;
        store |= low << 1;
        store |= high << 26;
        return store |= variable << 51;
    }

    private static void checkState(boolean state) {
        if (!state) {
            throw new IllegalStateException("");
        }
    }

    private static void checkState(boolean state, String formatString, Object ... format) {
        if (!state) {
            throw new IllegalStateException(String.format(formatString, format));
        }
    }

    private static long clearChainStartInStore(long referenceStore) {
        return referenceStore & (LIST_REFERENCE_MASK << 39 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long decreaseReferenceCountInStore(long referenceStore) {
        assert (!NodeTable.isStoreSaturated(referenceStore));
        return referenceStore - 2L;
    }

    private static long getChainStartFromStore(long referenceStore) {
        return referenceStore >>> 39 & LIST_REFERENCE_MASK;
    }

    static long getHighFromStore(long nodeStore) {
        return nodeStore >>> 26 & TREE_REFERENCE_MASK;
    }

    static long getLowFromStore(long nodeStore) {
        return nodeStore >>> 1 & TREE_REFERENCE_MASK;
    }

    private static long getMarkFromStore(long nodeStore) {
        return nodeStore & 1L;
    }

    private static int getMarkStackSizeForTreeSize(int treeSize) {
        return treeSize * 4 + 3;
    }

    private static long getNextChainEntryFromStore(long referenceStore) {
        return referenceStore >>> 14 & LIST_REFERENCE_MASK;
    }

    private static long getReferenceCountFromStore(long referenceStore) {
        assert (!NodeTable.isStoreSaturated(referenceStore));
        return referenceStore >>> 1 & REFERENCE_COUNT_MASK;
    }

    static long getVariableFromStore(long nodeStore) {
        return nodeStore >>> 51;
    }

    private static long increaseReferenceCountInStore(long referenceStore) {
        assert (!NodeTable.isStoreSaturated(referenceStore));
        return referenceStore + 2L;
    }

    private static long invalidStore() {
        return INVALID_NODE_VALUE << 51;
    }

    static boolean isNodeStoreMarked(long nodeStore) {
        return NodeTable.getMarkFromStore(nodeStore) != 0L;
    }

    private static boolean isReferencedOrSaturatedNodeStore(long referenceStore) {
        return NodeTable.isStoreSaturated(referenceStore) || NodeTable.getReferenceCountFromStore(referenceStore) > 0L;
    }

    private static boolean isStoreSaturated(long referenceStore) {
        return (referenceStore & 1L) != 0L;
    }

    private static boolean isValidNodeStore(long nodeStore) {
        return nodeStore >>> 51 != INVALID_NODE_VALUE;
    }

    private static boolean nodeStoresEqual(long nodeStore, long otherNodeStore) {
        return nodeStore >>> 1 == otherNodeStore >>> 1;
    }

    private static long saturateStore(long referenceStore) {
        return referenceStore | 1L;
    }

    private static long setChainStartInStore(long referenceStore, long chainStart) {
        assert (0L <= chainStart && BitUtil.fits(chainStart, 25));
        return referenceStore & (LIST_REFERENCE_MASK << 39 ^ 0xFFFFFFFFFFFFFFFFL) | chainStart << 39;
    }

    private static long setMarkInStore(long nodeStore) {
        assert (NodeTable.isValidNodeStore(nodeStore));
        return nodeStore | 1L;
    }

    private static long setNextChainEntryInStore(long referenceStore, long next) {
        assert (0L <= next && BitUtil.fits(next, 25));
        return referenceStore & (LIST_REFERENCE_MASK << 14 ^ 0xFFFFFFFFFFFFFFFFL) | next << 14;
    }

    private static long startNoneAndNextStore(int next) {
        assert (0 <= next && BitUtil.fits(next, 25));
        return (long)next << 14;
    }

    private static long unsetMarkInStore(long nodeStore) {
        assert (NodeTable.isValidNodeStore(nodeStore));
        return nodeStore & 0xFFFFFFFFFFFFFFFEL;
    }

    public final int approximateNodeCount(int node) {
        assert (this.isNodeValidOrRoot(node));
        if (this.isNodeRoot(node)) {
            return 0;
        }
        long bddStore = this.nodeStorage[node];
        return 1 + this.approximateNodeCount((int)NodeTable.getLowFromStore(bddStore)) + this.approximateNodeCount((int)NodeTable.getHighFromStore(bddStore));
    }

    final boolean check() {
        int nextFreeNode;
        int i;
        int i2;
        int i3;
        NodeTable.checkState(this.biggestReferencedNode <= this.biggestValidNode);
        NodeTable.checkState(this.biggestValidNode < 2 || NodeTable.isValidNodeStore(this.nodeStorage[this.biggestValidNode]), "Node (%s) is not valid or root", this.nodeToStringSupplier(this.biggestValidNode));
        for (i3 = this.biggestValidNode + 1; i3 < this.getTableSize(); ++i3) {
            NodeTable.checkState(!NodeTable.isValidNodeStore(this.nodeStorage[i3]), "Node (%s) is valid", this.nodeToStringSupplier(i3));
        }
        NodeTable.checkState(NodeTable.isReferencedOrSaturatedNodeStore(this.referenceStorage[this.biggestReferencedNode]), "Node (%s) is not referenced", this.nodeToStringSupplier(this.biggestReferencedNode));
        for (i3 = this.biggestReferencedNode + 1; i3 < this.getTableSize(); ++i3) {
            NodeTable.checkState(!NodeTable.isReferencedOrSaturatedNodeStore(this.referenceStorage[i3]), "Node (%s) is referenced", this.nodeToStringSupplier(i3));
        }
        for (i3 = 2; i3 <= this.biggestReferencedNode; ++i3) {
            if (!NodeTable.isReferencedOrSaturatedNodeStore(this.referenceStorage[i3])) continue;
            NodeTable.checkState(NodeTable.isValidNodeStore(this.nodeStorage[i3]), "Node (%s) is referenced but invalid", this.nodeToStringSupplier(i3));
        }
        int count = 2;
        for (i2 = 2; i2 <= this.biggestValidNode; ++i2) {
            if (!NodeTable.isValidNodeStore(this.nodeStorage[i2])) continue;
            ++count;
        }
        NodeTable.checkState(count == this.getTableSize() - this.freeNodeCount, "Invalid # of free nodes: #live=%s, size=%s, free=%s", count, this.getTableSize(), this.freeNodeCount);
        for (i2 = 2; i2 <= this.biggestValidNode; ++i2) {
            long nodeStore = this.nodeStorage[i2];
            if (!NodeTable.isValidNodeStore(nodeStore)) continue;
            int low = (int)NodeTable.getLowFromStore(nodeStore);
            int high = (int)NodeTable.getHighFromStore(nodeStore);
            NodeTable.checkState(this.isNodeValidOrRoot(low), "Invalid low entry (%s) -> (%s)", this.nodeToStringSupplier(i2), this.nodeToStringSupplier(low));
            NodeTable.checkState(this.isNodeValidOrRoot(high), "Invalid high entry (%s) -> (%s)", this.nodeToStringSupplier(i2), this.nodeToStringSupplier(high));
            if (!this.isNodeRoot(low)) {
                NodeTable.checkState(NodeTable.getVariableFromStore(nodeStore) < NodeTable.getVariableFromStore(this.nodeStorage[low]), "(%s) -> (%s) does not descend tree", this.nodeToStringSupplier(i2), this.nodeToStringSupplier(low));
            }
            if (this.isNodeRoot(high)) continue;
            NodeTable.checkState(NodeTable.getVariableFromStore(nodeStore) < NodeTable.getVariableFromStore(this.nodeStorage[high]), "(%s) -> (%s) does not descend tree", this.nodeToStringSupplier(i2), this.nodeToStringSupplier(high));
        }
        int maximalNodeCountChecked = 500;
        if (this.getTableSize() < maximalNodeCountChecked) {
            for (int i4 = 2; i4 <= this.biggestValidNode; ++i4) {
                long storeOfI = this.nodeStorage[i4];
                if (!NodeTable.isValidNodeStore(storeOfI)) continue;
                for (int j = i4 + 1; j < this.getTableSize(); ++j) {
                    long storeOfJ = this.nodeStorage[j];
                    if (!NodeTable.isValidNodeStore(storeOfJ)) continue;
                    NodeTable.checkState(!NodeTable.nodeStoresEqual(storeOfI, storeOfJ), "Duplicate entries (%s) and (%s)", this.nodeToStringSupplier(i4), this.nodeToStringSupplier(j));
                }
            }
        }
        for (i = 2; i < this.getTableSize(); ++i) {
            long nodeStore = this.nodeStorage[i];
            if (!NodeTable.isValidNodeStore(nodeStore)) continue;
            int chainPosition = (int)NodeTable.getChainStartFromStore(this.referenceStorage[this.hashNodeStore(nodeStore)]);
            boolean found = false;
            StringBuilder hashChain = new StringBuilder(32);
            while (chainPosition != 0) {
                hashChain.append(' ').append(chainPosition);
                if (chainPosition == i) {
                    found = true;
                    break;
                }
                chainPosition = (int)NodeTable.getNextChainEntryFromStore(this.referenceStorage[chainPosition]);
            }
            NodeTable.checkState(found, "(%s) is not contained in it's hash list: %s", this.nodeToStringSupplier(i), hashChain);
        }
        for (i = 2; i < this.firstFreeNode; ++i) {
            NodeTable.checkState(NodeTable.isValidNodeStore(this.nodeStorage[i]), "Invalid node (%s) smaller than firstFreeNode", this.nodeToStringSupplier(i));
        }
        int currentFreeNode = this.firstFreeNode;
        do {
            NodeTable.checkState(!NodeTable.isValidNodeStore(this.nodeStorage[currentFreeNode]), "Node (%s) in free node chain is valid", this.nodeToStringSupplier(currentFreeNode));
            nextFreeNode = (int)NodeTable.getNextChainEntryFromStore(this.referenceStorage[currentFreeNode]);
            NodeTable.checkState(nextFreeNode == 0 || currentFreeNode < nextFreeNode, "Free node chain is not well ordered, %s <= %s", nextFreeNode, currentFreeNode);
            NodeTable.checkState(nextFreeNode < this.nodeStorage.length, "Next free node points over horizon, %s -> %s (%s)", currentFreeNode, nextFreeNode, this.nodeStorage.length);
        } while ((currentFreeNode = nextFreeNode) != 0);
        return true;
    }

    private void connectHashList(int node, int hash) {
        int hashChainStart;
        assert (this.isNodeValid(node) && 0 <= hash && hash == this.hashNodeStore(this.nodeStorage[node]));
        long hashReferenceStore = this.referenceStorage[hash];
        int currentChainNode = hashChainStart = (int)NodeTable.getChainStartFromStore(hashReferenceStore);
        while (currentChainNode != 0) {
            if (currentChainNode == node) {
                return;
            }
            long currentChainStore = this.referenceStorage[currentChainNode];
            assert ((int)NodeTable.getNextChainEntryFromStore(currentChainStore) != currentChainNode);
            currentChainNode = (int)NodeTable.getNextChainEntryFromStore(currentChainStore);
        }
        this.referenceStorage[node] = NodeTable.setNextChainEntryInStore(this.referenceStorage[node], hashChainStart);
        this.referenceStorage[hash] = NodeTable.setChainStartInStore(this.referenceStorage[hash], node);
    }

    public final int dereference(int node) {
        assert (this.isNodeValidOrRoot(node));
        long referenceStore = this.referenceStorage[node];
        if (NodeTable.isStoreSaturated(referenceStore)) {
            return node;
        }
        assert (NodeTable.getReferenceCountFromStore(referenceStore) > 0L);
        if (NodeTable.getReferenceCountFromStore(referenceStore) == 1L) {
            ++this.approximateDeadNodeCount;
            if (node == this.biggestReferencedNode) {
                for (int i = this.biggestReferencedNode - 1; i >= 0; --i) {
                    if (!NodeTable.isReferencedOrSaturatedNodeStore(this.referenceStorage[i])) continue;
                    this.biggestReferencedNode = i;
                    break;
                }
            }
        }
        this.referenceStorage[node] = NodeTable.decreaseReferenceCountInStore(referenceStore);
        return node;
    }

    private int doGarbageCollection() {
        long nodeStore;
        int i;
        assert (this.check());
        int topOfStack = 0;
        for (i = 0; i < this.workStackTos; ++i) {
            int node = this.workStack[i];
            if (this.isNodeRoot(node) || !this.isNodeValid(node)) continue;
            this.ensureMarkStackSize(topOfStack);
            this.markStack[topOfStack] = node;
            ++topOfStack;
        }
        this.referenceStorage[0] = NodeTable.clearChainStartInStore(this.referenceStorage[0]);
        this.referenceStorage[1] = NodeTable.clearChainStartInStore(this.referenceStorage[1]);
        for (i = 2; i <= this.biggestValidNode; ++i) {
            long referenceStore = this.referenceStorage[i];
            if (i <= this.biggestReferencedNode && NodeTable.isReferencedOrSaturatedNodeStore(referenceStore)) {
                this.ensureMarkStackSize(topOfStack);
                this.markStack[topOfStack] = i;
                ++topOfStack;
            }
            this.referenceStorage[i] = NodeTable.clearChainStartInStore(referenceStore);
        }
        this.markAllOnStack(topOfStack);
        int previousFreeNodes = this.freeNodeCount;
        this.firstFreeNode = 0;
        this.freeNodeCount = this.getTableSize() - (this.biggestValidNode + 1);
        int i2 = this.getTableSize() - 1;
        while (i2 > this.biggestValidNode) {
            this.referenceStorage[i2] = NodeTable.setNextChainEntryInStore(this.referenceStorage[i2], this.firstFreeNode);
            this.firstFreeNode = i2--;
        }
        for (i2 = this.biggestValidNode; i2 >= 2; --i2) {
            nodeStore = this.nodeStorage[i2];
            if (NodeTable.isNodeStoreMarked(nodeStore)) continue;
            this.nodeStorage[i2] = NodeTable.invalidStore();
            this.referenceStorage[i2] = NodeTable.setNextChainEntryInStore(this.referenceStorage[i2], this.firstFreeNode);
            this.firstFreeNode = i2;
            if (i2 == this.biggestValidNode) {
                --this.biggestValidNode;
            }
            ++this.freeNodeCount;
        }
        for (i2 = this.biggestValidNode; i2 >= 2; --i2) {
            nodeStore = this.nodeStorage[i2];
            if (!NodeTable.isNodeStoreMarked(nodeStore)) continue;
            this.nodeStorage[i2] = NodeTable.unsetMarkInStore(nodeStore);
            this.connectHashList(i2, this.hashNodeStore(nodeStore));
        }
        this.approximateDeadNodeCount = 0;
        assert (this.check());
        return this.freeNodeCount - previousFreeNodes;
    }

    private void ensureMarkStackSize(int size) {
        if (size < this.markStack.length) {
            return;
        }
        this.markStack = Arrays.copyOf(this.markStack, Math.max(size, 2 * this.markStack.length));
    }

    private void ensureWorkStackSize(int size) {
        if (size < this.workStack.length) {
            return;
        }
        int newSize = this.workStack.length * 2;
        this.workStack = Arrays.copyOf(this.workStack, newSize);
    }

    public final int forceGc() {
        int freedNodes = this.doGarbageCollection();
        this.notifyGcRun();
        return freedNodes;
    }

    public final int getApproximateDeadNodeCount() {
        return this.approximateDeadNodeCount;
    }

    final BddConfiguration getConfiguration() {
        return this.configuration;
    }

    public final int getFreeNodeCount() {
        return this.freeNodeCount;
    }

    private int getGrowSize(int currentSize) {
        assert (0 <= this.configuration.minimumNodeTableGrowth() && this.configuration.minimumNodeTableGrowth() <= this.configuration.maximumNodeTableGrowth());
        if (currentSize <= this.configuration.nodeTableSmallThreshold()) {
            return currentSize + this.configuration.minimumNodeTableGrowth();
        }
        if (currentSize >= this.configuration.nodeTableBigThreshold()) {
            return currentSize + this.configuration.maximumNodeTableGrowth();
        }
        int growthDiff = this.configuration.maximumNodeTableGrowth() - this.configuration.minimumNodeTableGrowth();
        int thresholdDiff = this.configuration.nodeTableBigThreshold() - this.configuration.nodeTableSmallThreshold();
        int offset = currentSize - this.configuration.nodeTableSmallThreshold();
        int growth = this.configuration.minimumNodeTableGrowth() + offset * growthDiff / thresholdDiff;
        return currentSize + growth;
    }

    public final int getHigh(int node) {
        assert (this.isNodeValid(node));
        return (int)NodeTable.getHighFromStore(this.nodeStorage[node]);
    }

    public final int getLow(int node) {
        assert (this.isNodeValid(node));
        return (int)NodeTable.getLowFromStore(this.nodeStorage[node]);
    }

    final long getNodeStore(int node) {
        assert (this.isNodeValid(node));
        return this.nodeStorage[node];
    }

    public final int getReferenceCount(int node) {
        assert (this.isNodeValidOrRoot(node));
        long referenceStore = this.referenceStorage[node];
        if (NodeTable.isStoreSaturated(referenceStore)) {
            return -1;
        }
        return (int)NodeTable.getReferenceCountFromStore(referenceStore);
    }

    public final int getTableSize() {
        return this.nodeStorage.length;
    }

    public final int getVariable(int node) {
        assert (this.isNodeValid(node));
        return (int)NodeTable.getVariableFromStore(this.nodeStorage[node]);
    }

    final boolean grow() {
        int i;
        assert (this.check());
        logger.log(Level.FINE, "Grow of {0} requested", this);
        if (this.approximateDeadNodeCount > 0 || this.getTableSize() > this.configuration.minimumDeadNodesCountForGcInGrow()) {
            logger.log(Level.FINE, "{0} has size {1} and at least {2} dead nodes", new Object[]{this, this.getTableSize(), this.approximateDeadNodeCount});
            this.doGarbageCollection();
            if (this.isEnoughFreeNodesAfterGc(this.freeNodeCount, this.getTableSize())) {
                this.notifyGcRun();
                return false;
            }
        }
        logger.log(Level.FINER, "Growing the table of {0}", this);
        int oldSize = this.getTableSize();
        int newSize = this.getGrowSize(oldSize);
        assert (oldSize < newSize);
        this.nodeStorage = Arrays.copyOf(this.nodeStorage, newSize);
        this.referenceStorage = Arrays.copyOf(this.referenceStorage, newSize);
        Arrays.fill(this.nodeStorage, oldSize, newSize, NodeTable.invalidStore());
        for (i = 0; i < oldSize; ++i) {
            long referenceStore = this.referenceStorage[i];
            referenceStore = NodeTable.clearChainStartInStore(referenceStore);
            this.referenceStorage[i] = referenceStore = NodeTable.setNextChainEntryInStore(referenceStore, i + 1);
        }
        for (i = oldSize; i < newSize - 1; ++i) {
            this.referenceStorage[i] = NodeTable.startNoneAndNextStore(i + 1);
        }
        this.referenceStorage[newSize - 1] = NodeTable.startNoneAndNextStore(0);
        this.firstFreeNode = oldSize;
        this.freeNodeCount = newSize - oldSize;
        for (i = oldSize - 1; i >= 2; --i) {
            long nodeStore = this.nodeStorage[i];
            if (NodeTable.isValidNodeStore(nodeStore)) {
                this.connectHashList(i, this.hashNodeStore(nodeStore));
                continue;
            }
            assert (!NodeTable.isValidNodeStore(nodeStore));
            this.referenceStorage[i] = NodeTable.setNextChainEntryInStore(this.referenceStorage[i], this.firstFreeNode);
            this.firstFreeNode = i;
            ++this.freeNodeCount;
        }
        assert (this.check());
        this.notifyTableSizeChanged();
        return true;
    }

    final void growTree(int newTreeSize) {
        assert (newTreeSize >= this.treeSize);
        this.treeSize = newTreeSize;
        this.ensureMarkStackSize(NodeTable.getMarkStackSizeForTreeSize(newTreeSize));
        this.ensureWorkStackSize(newTreeSize * 2);
    }

    private int hashNodeStore(long nodeStore) {
        int tableSize = this.getTableSize();
        int hash = MathUtil.hash(nodeStore >>> 1) % tableSize;
        if (hash < 0) {
            return hash + tableSize;
        }
        return hash;
    }

    private boolean isEnoughFreeNodesAfterGc(int freeNodesCount, int nodeCount) {
        return freeNodesCount > this.configuration.minimumFreeNodeCountAfterGc() || freeNodesCount > (int)((float)nodeCount * this.configuration.minimumFreeNodePercentageAfterGc());
    }

    public final boolean isNodeRoot(int node) {
        assert (0 <= node && node < this.getTableSize());
        return node <= 1;
    }

    public final boolean isNodeSaturated(int node) {
        assert (this.isNodeValidOrRoot(node));
        return NodeTable.isStoreSaturated(this.referenceStorage[node]);
    }

    public final boolean isNodeValid(int node) {
        assert (0 <= node && node < this.getTableSize());
        return 2 <= node && node <= this.biggestValidNode && NodeTable.isValidNodeStore(this.nodeStorage[node]);
    }

    public final boolean isNodeValidOrRoot(int node) {
        assert (0 <= node && node < this.getTableSize()) : node + " invalid";
        return node <= this.biggestValidNode && (this.isNodeRoot(node) || NodeTable.isValidNodeStore(this.nodeStorage[node]));
    }

    private boolean isNoneMarked() {
        for (int i = 2; i < this.nodeStorage.length; ++i) {
            if (!NodeTable.isNodeStoreMarked(this.nodeStorage[i])) continue;
            return false;
        }
        return true;
    }

    final boolean isWorkStackEmpty() {
        return this.workStackTos == 0;
    }

    final int makeNode(int variable, int low, int high) {
        if (low == high) {
            return low;
        }
        long nodeStore = NodeTable.buildNodeStore(variable, low, high);
        int hash = this.hashNodeStore(nodeStore);
        int currentLookupNode = (int)NodeTable.getChainStartFromStore(this.referenceStorage[hash]);
        assert (currentLookupNode < this.getTableSize()) : "Invalid previous entry for " + hash;
        while (currentLookupNode != 0) {
            if (NodeTable.nodeStoresEqual(nodeStore, this.nodeStorage[currentLookupNode])) {
                return currentLookupNode;
            }
            long currentLookupNodeReferenceStore = this.referenceStorage[currentLookupNode];
            assert ((int)NodeTable.getNextChainEntryFromStore(currentLookupNodeReferenceStore) != currentLookupNode);
            currentLookupNode = (int)NodeTable.getNextChainEntryFromStore(currentLookupNodeReferenceStore);
        }
        assert (this.freeNodeCount > 0);
        if (this.freeNodeCount == 1 && this.grow()) {
            hash = this.hashNodeStore(nodeStore);
        }
        int freeNode = this.firstFreeNode;
        this.firstFreeNode = (int)NodeTable.getNextChainEntryFromStore(this.referenceStorage[this.firstFreeNode]);
        assert (this.firstFreeNode < this.nodeStorage.length);
        --this.freeNodeCount;
        assert (!NodeTable.isValidNodeStore(this.nodeStorage[freeNode])) : "Overwriting existing node";
        this.nodeStorage[freeNode] = nodeStore;
        if (this.biggestValidNode < freeNode) {
            this.biggestValidNode = freeNode;
        }
        this.connectHashList(freeNode, hash);
        return freeNode;
    }

    private void markAllOnStack(int topOfMarkStack) {
        assert (this.isNoneMarked());
        int currentTopOfStack = topOfMarkStack;
        for (int i = 0; i < currentTopOfStack; ++i) {
            int node = this.markStack[i];
            this.nodeStorage[node] = NodeTable.setMarkInStore(this.nodeStorage[node]);
        }
        this.ensureMarkStackSize(currentTopOfStack + NodeTable.getMarkStackSizeForTreeSize(this.treeSize));
        while (currentTopOfStack > 0) {
            long highStore;
            int high;
            long lowStore;
            int currentNode = this.markStack[--currentTopOfStack];
            long currentNodeStore = this.nodeStorage[currentNode];
            assert (!this.isNodeRoot(currentNode) && NodeTable.isNodeStoreMarked(currentNodeStore));
            int low = (int)NodeTable.getLowFromStore(currentNodeStore);
            if (low > 1 && !NodeTable.isNodeStoreMarked(lowStore = this.nodeStorage[low])) {
                this.nodeStorage[low] = NodeTable.setMarkInStore(lowStore);
                this.markStack[currentTopOfStack] = low;
                ++currentTopOfStack;
            }
            if ((high = (int)NodeTable.getHighFromStore(currentNodeStore)) <= 1 || NodeTable.isNodeStoreMarked(highStore = this.nodeStorage[high])) continue;
            this.nodeStorage[high] = NodeTable.setMarkInStore(highStore);
            this.markStack[currentTopOfStack] = high;
            ++currentTopOfStack;
        }
    }

    final void markNode(int node) {
        assert (this.isNodeValid(node));
        this.nodeStorage[node] = NodeTable.setMarkInStore(this.nodeStorage[node]);
    }

    public final int nodeCount(int node) {
        assert (this.isNodeValidOrRoot(node));
        assert (this.isNoneMarked());
        int result = this.nodeCountRecursive(node);
        if (result > 0) {
            this.unMarkTree(node);
        }
        assert (this.isNoneMarked());
        return result;
    }

    public final int nodeCount() {
        assert (this.isNoneMarked());
        int topOfStack = 0;
        for (int i = 2; i < this.getTableSize(); ++i) {
            long referenceStore;
            long nodeStore = this.nodeStorage[i];
            if (!NodeTable.isValidNodeStore(nodeStore) || !NodeTable.isStoreSaturated(referenceStore = this.referenceStorage[i]) && NodeTable.getReferenceCountFromStore(referenceStore) <= 0L) continue;
            this.ensureMarkStackSize(topOfStack);
            this.markStack[topOfStack] = i;
            ++topOfStack;
        }
        this.markAllOnStack(topOfStack);
        int count = 0;
        for (int i = 2; i < this.getTableSize(); ++i) {
            long unmarkedNodeStore;
            long nodeStore = this.nodeStorage[i];
            if (!NodeTable.isValidNodeStore(nodeStore) || nodeStore == (unmarkedNodeStore = NodeTable.unsetMarkInStore(nodeStore))) continue;
            ++count;
            this.nodeStorage[i] = unmarkedNodeStore;
        }
        assert (this.isNoneMarked());
        return count;
    }

    private int nodeCountRecursive(int node) {
        if (this.isNodeRoot(node)) {
            return 0;
        }
        long bddStore = this.nodeStorage[node];
        if (NodeTable.isNodeStoreMarked(bddStore)) {
            return 0;
        }
        this.nodeStorage[node] = NodeTable.setMarkInStore(bddStore);
        return 1 + this.nodeCountRecursive((int)NodeTable.getLowFromStore(bddStore)) + this.nodeCountRecursive((int)NodeTable.getHighFromStore(bddStore));
    }

    final String nodeToString(int node) {
        long nodeStore = this.nodeStorage[node];
        if (!NodeTable.isValidNodeStore(nodeStore)) {
            return String.format("%5d| == INVALID ==", node);
        }
        long referenceStore = this.referenceStorage[node];
        String referenceCountString = NodeTable.isStoreSaturated(referenceStore) ? "SAT" : String.format("%3d", NodeTable.getReferenceCountFromStore(referenceStore));
        return String.format("%5d|%3d|%5d|%5d|%s", node, NodeTable.getVariableFromStore(nodeStore), NodeTable.getLowFromStore(nodeStore), NodeTable.getHighFromStore(nodeStore), referenceCountString);
    }

    final NodeToStringSupplier nodeToStringSupplier(int node) {
        return new NodeToStringSupplier(this, node);
    }

    void notifyGcRun() {
    }

    void notifyTableSizeChanged() {
    }

    final void popWorkStack() {
        assert (this.workStackTos >= 1);
        --this.workStackTos;
    }

    final void popWorkStack(int amount) {
        assert (this.workStackTos >= amount);
        this.workStackTos -= amount;
    }

    final int pushToWorkStack(int node) {
        assert (this.isNodeValidOrRoot(node));
        this.ensureWorkStackSize(this.workStackTos);
        this.workStack[this.workStackTos] = node;
        ++this.workStackTos;
        return node;
    }

    public final int reference(int node) {
        assert (this.isNodeValidOrRoot(node));
        long referenceStore = this.referenceStorage[node];
        if (NodeTable.isStoreSaturated(referenceStore)) {
            return node;
        }
        assert (0L <= NodeTable.getReferenceCountFromStore(referenceStore));
        this.referenceStorage[node] = NodeTable.getReferenceCountFromStore(referenceStore) == 8191L ? NodeTable.saturateStore(referenceStore) : NodeTable.increaseReferenceCountInStore(referenceStore);
        if (node > this.biggestReferencedNode) {
            this.biggestReferencedNode = node;
        }
        return node;
    }

    public final int referencedNodeCount() {
        int count = 0;
        for (int i = 2; i < this.biggestReferencedNode; ++i) {
            if (!NodeTable.isValidNodeStore(this.nodeStorage[i]) || !NodeTable.isReferencedOrSaturatedNodeStore(this.referenceStorage[i])) continue;
            ++count;
        }
        return count;
    }

    final int saturateNode(int node) {
        assert (this.isNodeValidOrRoot(node));
        if (node > this.biggestReferencedNode) {
            this.biggestReferencedNode = node;
        }
        this.referenceStorage[node] = NodeTable.saturateStore(this.referenceStorage[node]);
        return node;
    }

    public final String treeToString(int node) {
        assert (this.isNodeValidOrRoot(node));
        assert (this.isNoneMarked());
        if (this.isNodeRoot(node)) {
            return String.format("Node %d%n", node);
        }
        StringBuilder builder = new StringBuilder(50).append("Node ").append(node).append('\n').append("  NODE|VAR| LOW | HIGH|REF\n");
        this.treeToStringRecursive(node, builder);
        this.unMarkTree(node);
        return builder.toString();
    }

    private void treeToStringRecursive(int node, StringBuilder builder) {
        if (this.isNodeRoot(node)) {
            return;
        }
        long nodeStore = this.nodeStorage[node];
        if (NodeTable.isNodeStoreMarked(nodeStore)) {
            return;
        }
        this.nodeStorage[node] = NodeTable.setMarkInStore(nodeStore);
        builder.append(' ').append(this.nodeToString(node)).append('\n');
        this.treeToStringRecursive((int)NodeTable.getLowFromStore(nodeStore), builder);
        this.treeToStringRecursive((int)NodeTable.getHighFromStore(nodeStore), builder);
    }

    final void unMarkTree(int node) {
        assert (this.isNodeValidOrRoot(node));
        this.unMarkTreeRecursive(node);
        assert (this.isNoneMarked());
    }

    private void unMarkTreeRecursive(int node) {
        if (this.isNodeRoot(node)) {
            return;
        }
        long nodeStore = this.nodeStorage[node];
        if (!NodeTable.isNodeStoreMarked(nodeStore)) {
            return;
        }
        this.nodeStorage[node] = NodeTable.unsetMarkInStore(nodeStore);
        this.unMarkTreeRecursive((int)NodeTable.getLowFromStore(nodeStore));
        this.unMarkTreeRecursive((int)NodeTable.getHighFromStore(nodeStore));
    }

    private static final class NodeToStringSupplier {
        private final int node;
        private final NodeTable table;

        public NodeToStringSupplier(NodeTable table, int node) {
            this.table = table;
            this.node = node;
        }

        public String toString() {
            return this.table.nodeToString(this.node);
        }
    }
}

