/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnegative;

public final class NaturalsTransformer
implements IntIterator {
    private final PrimitiveIterator.OfInt original;
    private final IntUnaryOperator transformer;
    private int next;

    public NaturalsTransformer(PrimitiveIterator.OfInt original, IntUnaryOperator transformer) {
        this.original = original;
        this.transformer = transformer;
        this.next = this.getNext();
    }

    private int getNext() {
        while (this.original.hasNext()) {
            int nextCandidate = this.transformer.applyAsInt(this.original.nextInt());
            if (nextCandidate < 0) continue;
            return nextCandidate;
        }
        return -1;
    }

    public boolean hasNext() {
        return this.next >= 0;
    }

    @Nonnegative
    public int nextInt() {
        if (this.next < 0) {
            throw new NoSuchElementException();
        }
        int value = this.next;
        this.next = this.getNext();
        return value;
    }
}

