/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.map;

import de.tum.in.naturals.map.AbstractInt2DoubleEntrySet;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2DoubleMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;
import java.util.function.IntToDoubleFunction;
import javax.annotation.Nullable;

public class Nat2DoubleDenseArrayMap
extends AbstractInt2DoubleMap {
    private static final long serialVersionUID = 943823872741225228L;
    private final double[] array;
    @Nullable
    private transient EntrySetView entriesView = null;
    @Nullable
    private transient KeySetView keySetView = null;
    private int size = 0;
    @Nullable
    private transient ValuesView valuesView = null;

    public Nat2DoubleDenseArrayMap(double[] array) {
        this.array = array;
        for (double value : array) {
            if (this.isAbsent(value)) continue;
            ++this.size;
        }
    }

    public Nat2DoubleDenseArrayMap(int size) {
        this.array = new double[size];
        Arrays.fill(this.array, Double.NaN);
    }

    public Nat2DoubleDenseArrayMap(int size, double initialValue) {
        this.checkNotAbsent(initialValue);
        this.array = new double[size];
        if (initialValue != 0.0) {
            Arrays.fill(this.array, initialValue);
        }
        this.size = size;
    }

    public Nat2DoubleDenseArrayMap(int size, IntToDoubleFunction initialValues) {
        this.array = new double[size];
        for (int i = 0; i < this.array.length; ++i) {
            double value = initialValues.applyAsDouble(i);
            this.checkNotAbsent(value);
            this.array[i] = value;
        }
        this.size = size;
    }

    private void checkNotAbsent(double value) {
        if (this.isAbsent(value)) {
            throw new IllegalArgumentException(String.format("Value %s not allowed", value));
        }
    }

    public void clear() {
        Arrays.fill(this.array, Double.NaN);
        this.size = 0;
    }

    public boolean containsKey(int key) {
        return 0 <= key && key < this.array.length && !this.isAbsent(this.array[key]);
    }

    public boolean containsValue(double v) {
        if (this.isAbsent(v)) {
            return false;
        }
        for (double value : this.array) {
            if (Double.doubleToRawLongBits(value) != Double.doubleToRawLongBits(v)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Nat2DoubleDenseArrayMap) {
            Nat2DoubleDenseArrayMap other = (Nat2DoubleDenseArrayMap)((Object)o);
            return this.size == other.size && Arrays.equals(this.array, other.array);
        }
        return super.equals(o);
    }

    public void fill(int from, int to, double value) {
        this.checkNotAbsent(value);
        Arrays.fill(this.array, from, to, value);
    }

    public void fill(PrimitiveIterator.OfInt iterator, double value) {
        while (iterator.hasNext()) {
            this.array[iterator.next().intValue()] = value;
        }
    }

    public double get(int key) {
        double value = this.array[key];
        return this.isAbsent(value) ? this.defaultReturnValue() : value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array) ^ HashCommon.mix((int)this.size);
    }

    public ObjectSet<Int2DoubleMap.Entry> int2DoubleEntrySet() {
        if (this.entriesView == null) {
            this.entriesView = new EntrySetView(this);
        }
        return new EntrySetView(this);
    }

    private boolean isAbsent(double value) {
        return Double.isNaN(value);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntSet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySetView(this);
        }
        return this.keySetView;
    }

    private int nextKey(int index) {
        for (int i = index; i < this.array.length; ++i) {
            if (this.isAbsent(this.array[i])) continue;
            return i;
        }
        return -1;
    }

    public double put(int key, double value) {
        this.checkNotAbsent(value);
        double previous = this.array[key];
        this.array[key] = value;
        if (this.isAbsent(previous)) {
            ++this.size;
            return this.defaultReturnValue();
        }
        return previous;
    }

    public double remove(int key) {
        double previous = this.array[key];
        if (this.isAbsent(previous)) {
            return this.defaultReturnValue();
        }
        this.array[key] = Double.NaN;
        --this.size;
        return previous;
    }

    public int size() {
        return this.size;
    }

    public DoubleCollection values() {
        if (this.valuesView == null) {
            this.valuesView = new ValuesView(this);
        }
        return this.valuesView;
    }

    private static class ValuesView
    extends AbstractDoubleCollection {
        private final Nat2DoubleDenseArrayMap map;

        ValuesView(Nat2DoubleDenseArrayMap map) {
            this.map = map;
        }

        public void clear() {
            this.map.clear();
        }

        public boolean contains(double v) {
            return this.map.containsValue(v);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection other = (Collection)o;
            return other.size() == this.size() && this.containsAll(other);
        }

        public int hashCode() {
            return HashCommon.mix((int)this.map.hashCode());
        }

        public DoubleIterator iterator() {
            return new ValuesIterator(this.map);
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ValuesIterator
    implements DoubleIterator {
        private final Nat2DoubleDenseArrayMap map;
        private int current;
        private int next;

        ValuesIterator(Nat2DoubleDenseArrayMap map) {
            this.map = map;
            this.current = -1;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double value = this.map.array[this.next];
            this.current = this.next;
            this.next = this.map.nextKey(this.next + 1);
            return value;
        }

        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.current);
            this.current = -1;
        }
    }

    private static class KeySetView
    extends AbstractIntSet {
        private final Nat2DoubleDenseArrayMap map;

        KeySetView(Nat2DoubleDenseArrayMap map) {
            this.map = map;
        }

        public KeySetView clone() {
            return this;
        }

        public void forEach(IntConsumer action) {
            int index = this.map.nextKey(0);
            while (index >= 0) {
                action.accept(index);
                index = this.map.nextKey(index + 1);
            }
        }

        public IntIterator iterator() {
            return new KeySetIterator(this.map);
        }

        public boolean remove(int key) {
            if (!this.map.containsKey(key)) {
                return false;
            }
            this.map.remove(key);
            return true;
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class KeySetIterator
    implements IntIterator {
        private final Nat2DoubleDenseArrayMap map;
        private int current = -1;
        private int next;

        public KeySetIterator(Nat2DoubleDenseArrayMap map) {
            this.map = map;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.map.nextKey(this.next + 1);
            return this.current;
        }

        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.current);
            this.current = -1;
        }
    }

    private static class FastMapEntry
    extends AbstractInt2DoubleMap.BasicEntry {
        private final Nat2DoubleDenseArrayMap map;
        int index = -1;

        public FastMapEntry(Nat2DoubleDenseArrayMap map) {
            this.map = map;
        }

        public double getDoubleValue() {
            return this.map.array[this.index];
        }

        public int getIntKey() {
            return this.index;
        }

        public double setValue(double v) {
            double oldValue = this.map.array[this.index];
            ((Nat2DoubleDenseArrayMap)this.map).array[this.index] = v;
            return oldValue;
        }
    }

    private static class FastEntryIterator
    implements ObjectIterator<Int2DoubleMap.Entry> {
        private final FastMapEntry entry;
        private final Nat2DoubleDenseArrayMap map;
        private int next;

        FastEntryIterator(Nat2DoubleDenseArrayMap map) {
            this.entry = new FastMapEntry(map);
            this.map = map;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public Int2DoubleMap.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.entry.index = this.next;
            this.next = this.map.nextKey(this.next + 1);
            return this.entry;
        }

        public void remove() {
            if (this.entry.index == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.entry.index);
            this.entry.index = -1;
        }
    }

    private static class EntrySetView
    extends AbstractInt2DoubleEntrySet<Nat2DoubleDenseArrayMap> {
        EntrySetView(Nat2DoubleDenseArrayMap map) {
            super(map);
        }

        public EntrySetView clone() throws CloneNotSupportedException {
            return (EntrySetView)super.clone();
        }

        public ObjectIterator<Int2DoubleMap.Entry> fastIterator() {
            return new FastEntryIterator((Nat2DoubleDenseArrayMap)this.map);
        }

        public ObjectIterator<Int2DoubleMap.Entry> iterator() {
            return new EntryIterator((Nat2DoubleDenseArrayMap)this.map);
        }
    }

    private static class EntryIterator
    implements ObjectIterator<Int2DoubleMap.Entry> {
        private final Nat2DoubleDenseArrayMap map;
        private int next;

        EntryIterator(Nat2DoubleDenseArrayMap map) {
            this.map = map;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public Int2DoubleMap.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            this.next = this.map.nextKey(this.next + 1);
            assert (this.map.containsKey(index));
            return new AbstractInt2DoubleMap.BasicEntry(index, this.map.array[index]);
        }
    }
}

