/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerStore;
import jhoafparser.parser.HOAFParser;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredHeader;
import jhoafparser.storage.StoredState;
import jhoafparser.transformations.ToTransitionAcceptance;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public final class AutomatonReader {
    private AutomatonReader() {
    }

    public static void readHoaStream(String string, Function<List<String>, ValuationSetFactory> factorySupplier, Consumer<Automaton<HoaState, ?>> consumer) throws ParseException {
        AutomatonReader.readHoaStream(new StringReader(string), factorySupplier, consumer);
    }

    public static void readHoaStream(Reader reader, Function<List<String>, ValuationSetFactory> factorySupplier, Consumer<Automaton<HoaState, ?>> consumer) throws ParseException {
        HOAFParser.parseHOA((Reader)reader, () -> new ToTransitionAcceptance((HOAConsumer)new HoaConsumerAutomatonSupplier(consumer, factorySupplier)), null);
    }

    public static Automaton<HoaState, OmegaAcceptance> readHoa(String string, Function<List<String>, ValuationSetFactory> factorySupplier) throws ParseException {
        return AutomatonReader.readHoa(new StringReader(string), factorySupplier);
    }

    public static Automaton<HoaState, OmegaAcceptance> readHoa(Reader reader, Function<List<String>, ValuationSetFactory> factorySupplier) throws ParseException {
        return AutomatonReader.readHoa(reader, factorySupplier, OmegaAcceptance.class);
    }

    public static <A extends OmegaAcceptance> Automaton<HoaState, A> readHoa(String input, Function<List<String>, ValuationSetFactory> factorySupplier, Class<A> acceptanceClass) throws ParseException {
        return AutomatonReader.readHoa(new StringReader(input), factorySupplier, acceptanceClass);
    }

    public static <A extends OmegaAcceptance> Automaton<HoaState, A> readHoa(Reader stream, Function<List<String>, ValuationSetFactory> factorySupplier, Class<A> acceptanceClass) throws ParseException {
        AtomicReference<Automaton<HoaState, A>> automaton = new AtomicReference<Automaton<HoaState, A>>();
        AutomatonReader.readHoaStream(stream, factorySupplier, AutomatonReader.consumer(automaton, acceptanceClass));
        return automaton.get();
    }

    private static <A extends OmegaAcceptance> Consumer<Automaton<HoaState, ?>> consumer(AtomicReference<Automaton<HoaState, A>> box, Class<A> acceptanceClass) {
        return automaton -> {
            Automaton oldValue = box.getAndSet(AutomatonUtil.cast(automaton, HoaState.class, acceptanceClass));
            if (oldValue != null) {
                throw new IllegalArgumentException(String.format("Stream contained at least two automata: %s, %s", automaton, oldValue));
            }
        };
    }

    private static final class StoredConverter {
        private final MutableAutomaton<HoaState, ?> automaton;
        @Nullable
        private final int[] remapping;
        private final Int2ObjectMap<HoaState> states;
        private final StoredAutomaton storedAutomaton;
        private final StoredHeader storedHeader;
        private final ValuationSetFactory vsFactory;

        StoredConverter(StoredAutomaton storedAutomaton, Function<List<String>, ValuationSetFactory> factorySupplier) throws HOAConsumerException {
            this.vsFactory = factorySupplier.apply(storedAutomaton.getStoredHeader().getAPs());
            StoredConverter.check(!storedAutomaton.hasUniversalBranching(), "Universal branching not supported", new Object[0]);
            this.storedAutomaton = storedAutomaton;
            this.storedHeader = storedAutomaton.getStoredHeader();
            List variables = this.storedHeader.getAPs();
            List<String> alphabet = this.vsFactory.alphabet();
            if (variables.equals(alphabet)) {
                this.remapping = null;
            } else {
                this.remapping = new int[variables.size()];
                ListIterator variableIterator = variables.listIterator();
                while (variableIterator.hasNext()) {
                    int variableIndex = alphabet.indexOf(variableIterator.next());
                    Preconditions.checkArgument((variableIndex >= 0 ? 1 : 0) != 0);
                    this.remapping[variableIterator.previousIndex()] = variableIndex;
                }
            }
            this.automaton = new HashMapAutomaton<HoaState, OmegaAcceptance>(this.vsFactory, StoredConverter.acceptance(this.storedHeader));
            String name = storedAutomaton.getStoredHeader().getName();
            if (name != null) {
                this.automaton.name(name);
            }
            this.states = new Int2ObjectLinkedOpenHashMap(storedAutomaton.getNumberOfStates());
        }

        private static void check(boolean condition, String formatString, Object ... args) throws HOAConsumerException {
            if (!condition) {
                throw new HOAConsumerException(String.format(formatString, args));
            }
        }

        private void addEdge(HoaState source, ValuationSet valuationSet, @Nullable List<Integer> storedEdgeAcceptance, HoaState successor) throws HOAConsumerException {
            Edge<HoaState> edge = storedEdgeAcceptance == null ? Edge.of(successor) : Edge.of(successor, BitSets.of(storedEdgeAcceptance));
            StoredConverter.check(((OmegaAcceptance)this.automaton.acceptance()).isWellFormedEdge(edge), "%s is not well-formed for %s", edge, this.automaton.acceptance());
            this.automaton.addEdge(source, valuationSet, edge);
        }

        private static OmegaAcceptance acceptance(StoredHeader header) throws HOAConsumerException {
            StoredHeader.NameAndExtra name = (StoredHeader.NameAndExtra)Iterables.getOnlyElement((Iterable)header.getAcceptanceNames(), null);
            BooleanExpression expression = header.getAcceptanceCondition();
            int sets = header.getNumberOfAcceptanceSets();
            switch (name == null ? "default" : name.name.toLowerCase(Locale.ENGLISH)) {
                case "all": {
                    return AllAcceptance.INSTANCE;
                }
                case "none": {
                    return NoneAcceptance.INSTANCE;
                }
                case "buchi": {
                    return BuchiAcceptance.INSTANCE;
                }
                case "parity": {
                    int colours;
                    boolean even;
                    String stringParity;
                    boolean max;
                    String stringPriority;
                    StoredConverter.check(((List)name.extra).size() == 3, "Malformed parity condition.", new Object[0]);
                    switch (stringPriority = ((List)name.extra).get(0).toString()) {
                        case "max": {
                            max = true;
                            break;
                        }
                        case "min": {
                            max = false;
                            break;
                        }
                        default: {
                            throw new HOAConsumerException("Unknown priority " + stringPriority);
                        }
                    }
                    switch (stringParity = ((List)name.extra).get(1).toString()) {
                        case "even": {
                            even = true;
                            break;
                        }
                        case "odd": {
                            even = false;
                            break;
                        }
                        default: {
                            throw new HOAConsumerException("Unknown parity " + stringParity);
                        }
                    }
                    String stringColours = ((List)name.extra).get(2).toString();
                    try {
                        colours = Integer.valueOf(stringColours);
                    }
                    catch (NumberFormatException e) {
                        throw (HOAConsumerException)new HOAConsumerException("Failed to parse colours " + stringColours).initCause((Throwable)e);
                    }
                    StoredConverter.check(colours >= 0, "Negative colours", new Object[0]);
                    StoredConverter.check(colours == sets, "Mismatch between colours (%d) and acceptance set count (%d)", colours, sets);
                    return new ParityAcceptance(sets, ParityAcceptance.Parity.of(max, even));
                }
                case "co-buchi": {
                    return CoBuchiAcceptance.INSTANCE;
                }
                case "generalized-buchi": {
                    return GeneralizedBuchiAcceptance.of(Integer.parseInt(((List)name.extra).get(0).toString()));
                }
                case "generalized-co-buchi": {
                    return new EmersonLeiAcceptance(sets, (BooleanExpression<AtomAcceptance>)expression);
                }
                case "streett": {
                    return new EmersonLeiAcceptance(sets, (BooleanExpression<AtomAcceptance>)expression);
                }
                case "rabin": {
                    return RabinAcceptance.of((BooleanExpression<AtomAcceptance>)expression);
                }
                case "generalized-rabin": {
                    return GeneralizedRabinAcceptance.of((BooleanExpression<AtomAcceptance>)expression);
                }
            }
            return new EmersonLeiAcceptance(sets, (BooleanExpression<AtomAcceptance>)expression);
        }

        private HoaState getSuccessor(List<Integer> successors) throws HOAConsumerException {
            StoredConverter.check(successors.size() == 1, "Universal edges not supported", new Object[0]);
            return (HoaState)this.states.get(((Integer)Iterables.getOnlyElement(successors)).intValue());
        }

        MutableAutomaton<HoaState, ?> transform() throws HOAConsumerException {
            HoaState state;
            int stateId;
            for (StoredState storedState : this.storedAutomaton.getStoredStates()) {
                stateId = storedState.getStateId();
                state = new HoaState(stateId, storedState.getInfo());
                assert (!this.states.containsKey(stateId));
                this.states.put(stateId, (Object)state);
            }
            for (List startState : this.storedHeader.getStartStates()) {
                StoredConverter.check(startState.size() == 1, "Universal initial states not supported", new Object[0]);
                this.automaton.addInitialState((HoaState)this.states.get(((Integer)Iterables.getOnlyElement((Iterable)startState)).intValue()));
            }
            for (StoredState storedState : this.storedAutomaton.getStoredStates()) {
                stateId = storedState.getStateId();
                state = (HoaState)this.states.get(stateId);
                this.automaton.addState(state);
                assert (storedState.getAccSignature() == null || storedState.getAccSignature().isEmpty());
                if (this.storedAutomaton.hasEdgesImplicit(stateId)) {
                    assert (!this.storedAutomaton.hasEdgesWithLabel(stateId));
                    Iterable edgesImplicit = this.storedAutomaton.getEdgesImplicit(stateId);
                    assert (edgesImplicit != null);
                    long counter = 0L;
                    long numberExpectedEdges = 1L << this.storedHeader.getAPs().size();
                    for (StoredEdgeImplicit implicitEdge : edgesImplicit) {
                        assert (counter < numberExpectedEdges);
                        HoaState successorState = this.getSuccessor(implicitEdge.getConjSuccessors());
                        ValuationSet valuationSet = this.vsFactory.of(BooleanExpression.fromImplicit((long)counter));
                        List edgeAcceptance = implicitEdge.getAccSignature();
                        this.addEdge(state, valuationSet, edgeAcceptance, successorState);
                        ++counter;
                    }
                    assert (counter == numberExpectedEdges);
                    continue;
                }
                if (!this.storedAutomaton.hasEdgesWithLabel(stateId)) continue;
                IntUnaryOperator apMapping = this.remapping == null ? null : i -> this.remapping[i];
                for (StoredEdgeWithLabel edgeWithLabel : this.storedAutomaton.getEdgesWithLabel(stateId)) {
                    HoaState successorState = this.getSuccessor(edgeWithLabel.getConjSuccessors());
                    ValuationSet valuationSet = this.vsFactory.of((BooleanExpression<AtomLabel>)edgeWithLabel.getLabelExpr(), apMapping);
                    this.addEdge(state, valuationSet, edgeWithLabel.getAccSignature(), successorState);
                }
            }
            this.automaton.trim();
            return this.automaton;
        }
    }

    public static final class HoaState {
        final int id;
        @Nullable
        final String info;

        HoaState(int id, @Nullable String info) {
            this.id = id;
            this.info = info;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HoaState)) {
                return false;
            }
            HoaState that = (HoaState)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return HashCommon.mix((int)this.id);
        }

        public String toString() {
            return this.info == null ? Integer.toString(this.id) : String.format("%d (%s)", this.id, this.info);
        }
    }

    private static final class HoaConsumerAutomatonSupplier
    extends HOAConsumerStore {
        private final Consumer<? super Automaton<HoaState, ?>> consumer;
        private final Function<List<String>, ValuationSetFactory> factorySupplier;

        HoaConsumerAutomatonSupplier(Consumer<? super Automaton<HoaState, ?>> consumer, Function<List<String>, ValuationSetFactory> factorySupplier) {
            this.consumer = consumer;
            this.factorySupplier = factorySupplier;
        }

        public void notifyEnd() throws HOAConsumerException {
            super.notifyEnd();
            this.consumer.accept(new StoredConverter(this.getStoredAutomaton(), this.factorySupplier).transform());
        }
    }
}

