/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractCachedStatesAutomaton;
import owl.automaton.EdgeTreeAutomatonMixin;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.Either;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;

public abstract class TwoPartAutomaton<A, B, C extends OmegaAcceptance>
extends AbstractCachedStatesAutomaton<Either<A, B>, C>
implements EdgeTreeAutomatonMixin<Either<A, B>, C> {
    @Override
    public final Set<Either<A, B>> initialStates() {
        return Sets.union(Collections3.transformSet(this.initialStatesA(), Either::left), Collections3.transformSet(this.initialStatesB(), Either::right));
    }

    @Override
    public final Set<Edge<Either<A, B>>> edges(Either<A, B> state, BitSet valuation) {
        return state.either(a -> {
            Set<Edge<Either<A, B>>> edges = this.moveAtoB(a).stream().flatMap(b -> this.liftB(this.edgesB(b, valuation)).stream()).collect(Collectors.toSet());
            edges.addAll(this.liftA(this.edgesA(a, valuation)));
            return this.deduplicate(edges);
        }, b -> this.deduplicate(this.liftB(this.edgesB(b, valuation))));
    }

    @Override
    public final ValuationTree<Edge<Either<A, B>>> edgeTree(Either<A, B> state) {
        return state.either(a -> {
            Set trees = this.moveAtoB(a).stream().map(x -> this.edgeTreeB(x).map(this::liftB)).collect(Collectors.toSet());
            trees.add(this.edgeTreeA(a).map(this::liftA));
            return ValuationTrees.union(trees).map(this::deduplicate);
        }, b -> this.edgeTreeB(b).map(x -> this.deduplicate(this.liftB((Set<Edge<B>>)x))));
    }

    protected abstract Set<A> initialStatesA();

    protected abstract Set<B> initialStatesB();

    protected Set<Edge<A>> edgesA(A state, BitSet valuation) {
        return this.edgeTreeA(state).get(valuation);
    }

    protected Set<Edge<B>> edgesB(B state, BitSet valuation) {
        return this.edgeTreeB(state).get(valuation);
    }

    protected abstract ValuationTree<Edge<A>> edgeTreeA(A var1);

    protected abstract ValuationTree<Edge<B>> edgeTreeB(B var1);

    protected abstract Set<B> moveAtoB(A var1);

    protected Set<Edge<Either<A, B>>> deduplicate(Set<Edge<Either<A, B>>> edges) {
        return edges;
    }

    private Set<Edge<Either<A, B>>> liftA(Set<Edge<A>> aEdges) {
        return Collections3.transformSet(aEdges, edge -> edge.withSuccessor(Either.left(edge.successor())));
    }

    private Set<Edge<Either<A, B>>> liftB(Set<Edge<B>> aEdges) {
        return Collections3.transformSet(aEdges, edge -> edge.withSuccessor(Either.right(edge.successor())));
    }
}

