/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import com.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import owl.automaton.Automaton;
import owl.automaton.edge.Edge;

public abstract class OmegaAcceptance {
    public abstract int acceptanceSets();

    public abstract BooleanExpression<AtomAcceptance> booleanExpression();

    @Nullable
    public abstract String name();

    public List<Object> nameExtra() {
        return List.of();
    }

    public abstract BitSet acceptingSet();

    public abstract BitSet rejectingSet();

    public abstract boolean isWellFormedEdge(Edge<?> var1);

    public <S> boolean isWellFormedAutomaton(Automaton<S, ?> automaton) {
        return Iterables.all(automaton.states(), x -> Iterables.all(automaton.edges(x), this::isWellFormedEdge));
    }

    public String toString() {
        String name = this.name();
        return (String)(name == null ? this.getClass().getSimpleName() : name + " " + this.nameExtra()) + ": " + this.acceptanceSets() + " " + this.booleanExpression();
    }
}

