/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.TwoPartAutomaton;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.optimizations.AcceptanceOptimizations;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.Either;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.LtlLanguageExpressible;
import owl.ltl.SyntacticFragments;

public final class AnnotatedLDBA<S, T extends LtlLanguageExpressible, B extends GeneralizedBuchiAcceptance, X, Y> {
    private final MutableAutomaton<S, NoneAcceptance> initialComponent;
    private final SetMultimap<S, T> epsilonJumps;
    private final MutableAutomaton<T, B> acceptingComponent;
    private final X annotation;
    private final Y stateAnnotation;
    private final Function<S, EquivalenceClass> languageFunction;

    private AnnotatedLDBA(MutableAutomaton<S, NoneAcceptance> initialComponent, MutableAutomaton<T, B> acceptingComponent, SetMultimap<S, T> epsilonJumps, Function<S, EquivalenceClass> languageFunction, X annotation, Y stateAnnotation) {
        this.initialComponent = initialComponent;
        this.epsilonJumps = epsilonJumps;
        this.acceptingComponent = acceptingComponent;
        this.languageFunction = languageFunction;
        this.annotation = annotation;
        this.stateAnnotation = stateAnnotation;
        assert (this.acceptingComponent.is(Automaton.Property.SEMI_DETERMINISTIC));
    }

    static <S, T extends LtlLanguageExpressible, Acc extends GeneralizedBuchiAcceptance, X, Y> AnnotatedLDBA<S, T, Acc, X, Y> build(MutableAutomaton<S, NoneAcceptance> initialComponent, AcceptingComponentBuilder<T, Acc> acceptingComponentBuilder, Function<S, Set<T>> jumps, Function<S, EquivalenceClass> languageFunction, X annotation, Y stateAnnotation) {
        SetMultimap epsilonJumps = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Set<S> scc : SccDecomposition.computeSccs(initialComponent, false)) {
            for (S state : scc) {
                Set<T> targets = jumps.apply(state);
                acceptingComponentBuilder.addInitialStates(targets);
                epsilonJumps.putAll(state, targets);
            }
        }
        MutableAutomaton<T, Acc> acceptingComponent = acceptingComponentBuilder.build();
        AcceptanceOptimizations.removeDeadStates(acceptingComponent);
        epsilonJumps.values().retainAll(acceptingComponent.states());
        for (Set<S> scc : SccDecomposition.computeSccs(initialComponent)) {
            if (!scc.stream().noneMatch(x -> epsilonJumps.keySet().contains(x) || SyntacticFragments.isSafety(((EquivalenceClass)languageFunction.apply(x)).modalOperators())) || !SccDecomposition.isTrap(initialComponent, scc)) continue;
            initialComponent.removeStateIf(scc::contains);
            initialComponent.trim();
        }
        return new AnnotatedLDBA<S, T, Acc, X, Y>(initialComponent, acceptingComponent, epsilonJumps, languageFunction, annotation, stateAnnotation);
    }

    public B acceptance() {
        return (B)((GeneralizedBuchiAcceptance)this.acceptingComponent.acceptance());
    }

    public Automaton<T, B> acceptingComponent() {
        return this.acceptingComponent;
    }

    public X annotation() {
        return this.annotation;
    }

    public MutableAutomaton<Either<S, T>, B> copyAsMutable() {
        MutableAutomaton mutableAutomaton = MutableAutomatonFactory.copy(new AutomatonView());
        AcceptanceOptimizations.removeDeadStates(mutableAutomaton);
        return mutableAutomaton;
    }

    public ValuationSetFactory factory() {
        return this.acceptingComponent.factory();
    }

    public Automaton<S, NoneAcceptance> initialComponent() {
        return this.initialComponent;
    }

    public Y stateAnnotation() {
        return this.stateAnnotation;
    }

    static interface AcceptingComponentBuilder<S, B extends GeneralizedBuchiAcceptance> {
        public void addInitialStates(Collection<? extends S> var1);

        public MutableAutomaton<S, B> build();
    }

    private class AutomatonView
    extends TwoPartAutomaton<S, T, B> {
        private AutomatonView() {
        }

        @Override
        public String name() {
            return AnnotatedLDBA.this.initialComponent.name();
        }

        @Override
        protected Set<S> initialStatesA() {
            return AnnotatedLDBA.this.initialComponent.initialStates();
        }

        @Override
        protected Set<T> initialStatesB() {
            return Set.of();
        }

        @Override
        protected Set<Edge<S>> edgesA(S state, BitSet valuation) {
            return AnnotatedLDBA.this.initialComponent.edges(state, valuation);
        }

        @Override
        protected Set<Edge<T>> edgesB(T state, BitSet valuation) {
            return AnnotatedLDBA.this.acceptingComponent.edges(state, valuation);
        }

        @Override
        protected ValuationTree<Edge<S>> edgeTreeA(S state) {
            return AnnotatedLDBA.this.initialComponent.edgeTree(state);
        }

        @Override
        protected ValuationTree<Edge<T>> edgeTreeB(T state) {
            return AnnotatedLDBA.this.acceptingComponent.edgeTree(state);
        }

        @Override
        protected Set<T> moveAtoB(S state) {
            return Collections.unmodifiableSet(AnnotatedLDBA.this.epsilonJumps.get(state));
        }

        @Override
        protected Set<Edge<Either<S, T>>> deduplicate(Set<Edge<Either<S, T>>> edges) {
            Edge initialComponentEdge = null;
            HashSet acceptingComponentEdges = new HashSet();
            for (Edge edge : edges) {
                if (edge.successor().isLeft()) {
                    assert (initialComponentEdge == null);
                    initialComponentEdge = edge;
                    continue;
                }
                acceptingComponentEdges.add(edge);
            }
            if (initialComponentEdge == null) {
                return edges;
            }
            EquivalenceClass initialComponentLanguage = AnnotatedLDBA.this.languageFunction.apply(((Either)initialComponentEdge.successor()).fromLeft().orElseThrow());
            if (SyntacticFragments.isSafety(initialComponentLanguage.modalOperators())) {
                acceptingComponentEdges.removeIf(x -> initialComponentLanguage.equals(((LtlLanguageExpressible)((Either)x.successor()).fromRight().orElseThrow()).language()));
            }
            if (acceptingComponentEdges.size() == edges.size() - 1) {
                return edges;
            }
            acceptingComponentEdges.add(initialComponentEdge);
            return acceptingComponentEdges;
        }

        @Override
        public B acceptance() {
            return (GeneralizedBuchiAcceptance)AnnotatedLDBA.this.acceptingComponent.acceptance();
        }

        @Override
        public ValuationSetFactory factory() {
            return AnnotatedLDBA.this.acceptingComponent.factory();
        }
    }
}

