/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.util;

import java.util.ArrayList;
import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.util.AcceptanceRepository;

public class AcceptanceRepositoryStandard
implements AcceptanceRepository {
    private static final String ACC_ALL = "all";
    private static final String ACC_NONE = "none";
    private static final String ACC_BUCHI = "Buchi";
    private static final String ACC_COBUCHI = "coBuchi";
    private static final String ACC_GENERALIZED_BUCHI = "generalized-Buchi";
    private static final String ACC_GENERALIZED_COBUCHI = "generalized-coBuchi";
    private static final String ACC_RABIN = "Rabin";
    private static final String ACC_STREETT = "Streett";
    private static final String ACC_GENERALIZED_RABIN = "generalized-Rabin";
    private static final String ACC_PARITY = "parity";

    @Override
    public BooleanExpression<AtomAcceptance> getCanonicalAcceptanceExpression(String accName, List<Object> extraInfo) throws IllegalArgumentException {
        switch (accName) {
            case "all": {
                return AcceptanceRepositoryStandard.forAll(extraInfo);
            }
            case "none": {
                return AcceptanceRepositoryStandard.forNone(extraInfo);
            }
            case "Buchi": {
                return AcceptanceRepositoryStandard.forBuchi(extraInfo);
            }
            case "coBuchi": {
                return AcceptanceRepositoryStandard.forCoBuchi(extraInfo);
            }
            case "generalized-Buchi": {
                return AcceptanceRepositoryStandard.forGenBuchi(extraInfo);
            }
            case "generalized-coBuchi": {
                return AcceptanceRepositoryStandard.forGenCoBuchi(extraInfo);
            }
            case "Rabin": {
                return AcceptanceRepositoryStandard.forRabin(extraInfo);
            }
            case "Streett": {
                return AcceptanceRepositoryStandard.forStreett(extraInfo);
            }
            case "generalized-Rabin": {
                return AcceptanceRepositoryStandard.forGeneralizedRabin(extraInfo);
            }
            case "parity": {
                return AcceptanceRepositoryStandard.forParity(extraInfo);
            }
        }
        return null;
    }

    public static BooleanExpression<AtomAcceptance> forAll(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_ALL, extraInfo, 0);
        return new BooleanExpression<boolean>(true);
    }

    public static BooleanExpression<AtomAcceptance> forNone(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_NONE, extraInfo, 0);
        return new BooleanExpression<boolean>(false);
    }

    public static BooleanExpression<AtomAcceptance> forBuchi(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_BUCHI, extraInfo, 0);
        return new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(0));
    }

    public static BooleanExpression<AtomAcceptance> forCoBuchi(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_COBUCHI, extraInfo, 0);
        return new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(0));
    }

    public static BooleanExpression<AtomAcceptance> forGenBuchi(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_GENERALIZED_BUCHI, extraInfo, 1);
        int numberOfInf = AcceptanceRepositoryStandard.extraInfoToIntegerList(ACC_GENERALIZED_BUCHI, extraInfo).get(0);
        if (numberOfInf == 0) {
            return new BooleanExpression<boolean>(true);
        }
        BooleanExpression<AtomAcceptance> result = null;
        for (int i = 0; i < numberOfInf; ++i) {
            BooleanExpression<AtomAcceptance> inf = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(i));
            result = i == 0 ? inf : result.and(inf);
        }
        return result;
    }

    public static BooleanExpression<AtomAcceptance> forGenCoBuchi(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_GENERALIZED_COBUCHI, extraInfo, 1);
        int numberOfFin = AcceptanceRepositoryStandard.extraInfoToIntegerList(ACC_GENERALIZED_COBUCHI, extraInfo).get(0);
        if (numberOfFin == 0) {
            return new BooleanExpression<boolean>(false);
        }
        BooleanExpression<AtomAcceptance> result = null;
        for (int i = 0; i < numberOfFin; ++i) {
            BooleanExpression<AtomAcceptance> fin = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(i));
            result = i == 0 ? fin : result.and(fin);
        }
        return result;
    }

    public static BooleanExpression<AtomAcceptance> forRabin(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_RABIN, extraInfo, 1);
        int numberOfPairs = AcceptanceRepositoryStandard.extraInfoToIntegerList(ACC_RABIN, extraInfo).get(0);
        if (numberOfPairs == 0) {
            return new BooleanExpression<boolean>(false);
        }
        BooleanExpression<AtomAcceptance> result = null;
        for (int i = 0; i < numberOfPairs; ++i) {
            BooleanExpression<AtomAcceptance> fin = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(2 * i));
            BooleanExpression<AtomAcceptance> inf = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(2 * i + 1));
            BooleanExpression<AtomAcceptance> pair = fin.and(inf);
            result = i == 0 ? pair : result.or(pair);
        }
        return result;
    }

    public static BooleanExpression<AtomAcceptance> forStreett(List<Object> extraInfo) {
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_STREETT, extraInfo, 1);
        int numberOfPairs = AcceptanceRepositoryStandard.extraInfoToIntegerList(ACC_STREETT, extraInfo).get(0);
        if (numberOfPairs == 0) {
            return new BooleanExpression<boolean>(true);
        }
        BooleanExpression<AtomAcceptance> result = null;
        for (int i = 0; i < numberOfPairs; ++i) {
            BooleanExpression<AtomAcceptance> fin = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(2 * i));
            BooleanExpression<AtomAcceptance> inf = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(2 * i + 1));
            BooleanExpression<AtomAcceptance> pair = fin.or(inf);
            result = i == 0 ? pair : result.and(pair);
        }
        return result;
    }

    public static BooleanExpression<AtomAcceptance> forGeneralizedRabin(List<Object> extraInfo) {
        List<Integer> parameters = AcceptanceRepositoryStandard.extraInfoToIntegerList(ACC_GENERALIZED_RABIN, extraInfo);
        if (parameters.size() == 0) {
            throw new IllegalArgumentException("Acceptance generalized-Rabin needs at least one argument");
        }
        int numberOfPairs = parameters.get(0);
        if (parameters.size() != numberOfPairs + 1) {
            throw new IllegalArgumentException("Acceptance generalized-Rabin with " + numberOfPairs + " generalized pairs: There is not exactly one argument per pair");
        }
        BooleanExpression<AtomAcceptance> result = null;
        int currentIndex = 0;
        for (int i = 0; i < numberOfPairs; ++i) {
            BooleanExpression<AtomAcceptance> fin;
            int numberOfInf = parameters.get(i + 1);
            BooleanExpression<AtomAcceptance> pair = fin = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(currentIndex++));
            for (int j = 0; j < numberOfInf; ++j) {
                BooleanExpression<AtomAcceptance> inf = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(currentIndex++));
                pair = pair.and(inf);
            }
            result = i == 0 ? pair : result.or(pair);
        }
        return result;
    }

    public static BooleanExpression<AtomAcceptance> forParity(List<Object> extraInfo) {
        String evenOdd;
        String minMax;
        AcceptanceRepositoryStandard.checkNumberOfArguments(ACC_PARITY, extraInfo, 3);
        boolean min = false;
        boolean even = false;
        switch (minMax = AcceptanceRepositoryStandard.extraInfoToString(ACC_PARITY, extraInfo, 0)) {
            case "min": {
                min = true;
                break;
            }
            case "max": {
                min = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("For acceptance parity, the first argument has to be either 'min' or 'max'");
            }
        }
        switch (evenOdd = AcceptanceRepositoryStandard.extraInfoToString(ACC_PARITY, extraInfo, 1)) {
            case "even": {
                even = true;
                break;
            }
            case "odd": {
                even = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("For acceptance parity, the second argument has to be either 'even' or 'odd'");
            }
        }
        if (!(extraInfo.get(2) instanceof Integer)) {
            throw new IllegalArgumentException("For acceptance parity, the third argument has to be the number of colors");
        }
        int colors = (Integer)extraInfo.get(2);
        if (colors < 0) {
            throw new IllegalArgumentException("For acceptance parity, the third argument has to be the number of colors (non-negative)");
        }
        if (colors == 0) {
            if (min && even) {
                return new BooleanExpression<boolean>(true);
            }
            if (!min && even) {
                return new BooleanExpression<boolean>(false);
            }
            if (min && !even) {
                return new BooleanExpression<boolean>(false);
            }
            if (!min && !even) {
                return new BooleanExpression<boolean>(true);
            }
        }
        BooleanExpression<AtomAcceptance> result = null;
        boolean reversed = min;
        boolean infOnOdd = !even;
        for (int i = 0; i < colors; ++i) {
            int color;
            int n = color = reversed ? colors - i - 1 : i;
            boolean produceInf = color % 2 == 0 ? !infOnOdd : infOnOdd;
            BooleanExpression<AtomAcceptance> node = produceInf ? new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(color)) : new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(color));
            result = result == null ? node : (produceInf ? node.or(result) : node.and(result));
        }
        return result;
    }

    private static List<Integer> extraInfoToIntegerList(String accName, List<Object> extraInfo) {
        ArrayList<Integer> result = new ArrayList<Integer>(extraInfo.size());
        for (Object i : extraInfo) {
            if (!(i instanceof Integer)) {
                throw new IllegalArgumentException("For acceptance " + accName + ", all arguments have to be integers");
            }
            result.add((Integer)i);
        }
        return result;
    }

    private static String extraInfoToString(String accName, List<Object> extraInfo, int index) {
        if (extraInfo.get(index) instanceof String) {
            return (String)extraInfo.get(index);
        }
        throw new IllegalArgumentException("Argument " + (index - 1) + " for acceptance " + accName + " has to be a string!");
    }

    private static void checkNumberOfArguments(String accName, List<Object> extraInfo, int expectedNumberOfArguments) throws IllegalArgumentException {
        if (expectedNumberOfArguments != extraInfo.size()) {
            throw new IllegalArgumentException("For acceptance " + accName + ", expected " + expectedNumberOfArguments + " arguments, got " + extraInfo.size());
        }
    }
}

