/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.storage.UniqueTable;

public class AcceptanceSimplify {
    private static Boolean getSimpleTruth(BooleanExpression<AtomAcceptance> acc) {
        switch (acc.getType()) {
            case EXP_FALSE: {
                return new Boolean(false);
            }
            case EXP_TRUE: {
                return new Boolean(true);
            }
        }
        return null;
    }

    public static BooleanExpression<AtomAcceptance> simplify(BooleanExpression<AtomAcceptance> acc) {
        switch (acc.getType()) {
            case EXP_FALSE: 
            case EXP_TRUE: {
                return acc;
            }
            case EXP_ATOM: {
                return acc;
            }
            case EXP_AND: {
                Boolean left = AcceptanceSimplify.getSimpleTruth(acc.getLeft());
                Boolean right = AcceptanceSimplify.getSimpleTruth(acc.getRight());
                if (left != null && right != null) {
                    return new BooleanExpression<boolean>(left != false && right != false);
                }
                if (left != null) {
                    return left != false ? acc.getRight() : new BooleanExpression<boolean>(false);
                }
                if (right != null) {
                    return right != false ? acc.getLeft() : new BooleanExpression<boolean>(false);
                }
                return acc;
            }
            case EXP_OR: {
                Boolean left = AcceptanceSimplify.getSimpleTruth(acc.getLeft());
                Boolean right = AcceptanceSimplify.getSimpleTruth(acc.getRight());
                if (left != null && right != null) {
                    return new BooleanExpression<boolean>(left != false || right != false);
                }
                if (left != null) {
                    return left != false ? new BooleanExpression<AtomAcceptance>((AtomAcceptance)((boolean)true)) : acc.getRight();
                }
                if (right != null) {
                    return right != false ? new BooleanExpression<AtomAcceptance>((AtomAcceptance)((boolean)true)) : acc.getLeft();
                }
                return acc;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition " + acc);
    }

    public static boolean isConjunctive(BooleanExpression<AtomAcceptance> acc) {
        switch (acc.getType()) {
            case EXP_AND: {
                return AcceptanceSimplify.isConjunctive(acc.getLeft()) && AcceptanceSimplify.isConjunctive(acc.getRight());
            }
            case EXP_FALSE: 
            case EXP_TRUE: 
            case EXP_ATOM: {
                return true;
            }
            case EXP_OR: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition " + acc);
    }

    private static List<BooleanExpression<AtomAcceptance>> toDNF(BooleanExpression<AtomAcceptance> acc, UniqueTable<BooleanExpression<AtomAcceptance>> uniqueTable) {
        if (AcceptanceSimplify.isConjunctive(acc)) {
            return Collections.singletonList(uniqueTable.findOrAdd(acc));
        }
        switch (acc.getType()) {
            case EXP_OR: {
                List<BooleanExpression<AtomAcceptance>> left = AcceptanceSimplify.toDNF(acc.getLeft(), uniqueTable);
                List<BooleanExpression<AtomAcceptance>> right = AcceptanceSimplify.toDNF(acc.getRight(), uniqueTable);
                left.addAll(right);
                return left;
            }
            case EXP_AND: {
                List<BooleanExpression<AtomAcceptance>> left = AcceptanceSimplify.toDNF(acc.getLeft(), uniqueTable);
                List<BooleanExpression<AtomAcceptance>> right = AcceptanceSimplify.toDNF(acc.getRight(), uniqueTable);
                ArrayList<BooleanExpression<AtomAcceptance>> result = new ArrayList<BooleanExpression<AtomAcceptance>>();
                for (BooleanExpression<AtomAcceptance> l : left) {
                    for (BooleanExpression<AtomAcceptance> r : right) {
                        result.add(uniqueTable.findOrAdd(l.and(r)));
                    }
                }
                return result;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition: " + acc);
    }

    public static List<BooleanExpression<AtomAcceptance>> toDNF(BooleanExpression<AtomAcceptance> acc) {
        UniqueTable<BooleanExpression<AtomAcceptance>> uniqueTable = new UniqueTable<BooleanExpression<AtomAcceptance>>();
        return AcceptanceSimplify.toDNF(acc, uniqueTable);
    }

    public static BooleanExpression<AtomAcceptance> toDNFCondition(BooleanExpression<AtomAcceptance> acc) {
        List<BooleanExpression<AtomAcceptance>> list = AcceptanceSimplify.toDNF(acc);
        if (list.size() == 0) {
            return new BooleanExpression<boolean>(false);
        }
        BooleanExpression<AtomAcceptance> result = list.remove(0);
        for (BooleanExpression<AtomAcceptance> clause : list) {
            result = result.or(clause);
        }
        return result;
    }
}

