/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import owl.automaton.AbstractImplicitAutomaton;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.ImmutableViewSettings;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;

public final class Views {
    public static final Transformer COMPLETE = environment -> (input, context) -> Views.complete(AutomatonUtil.cast(input), new MutableAutomatonUtil.Sink());
    public static final OwlModuleParser.TransformerParser COMPLETE_CLI = ImmutableTransformerParser.builder().key("complete").description("Make the transition relation of an automaton complet by adding a sink-state.").parser(settings -> COMPLETE).build();

    private Views() {
    }

    public static <S> Automaton<S, OmegaAcceptance> complement(Automaton<S, ?> automaton) {
        return Views.complement(automaton, null);
    }

    public static <S> Automaton<S, OmegaAcceptance> complement(Automaton<S, ?> automaton, @Nullable S trapState) {
        Automaton<S, ?> completeAutomaton = trapState == null ? automaton : Views.complete(automaton, trapState);
        Preconditions.checkArgument((boolean)completeAutomaton.is(Automaton.Property.COMPLETE), (Object)"Automaton is not complete.");
        Preconditions.checkArgument((!completeAutomaton.initialStates().isEmpty() ? 1 : 0) != 0, (Object)"Automaton is empty.");
        Object acceptance = completeAutomaton.acceptance();
        if (acceptance instanceof BuchiAcceptance) {
            return Views.createView(completeAutomaton, Views.builder().acceptance(CoBuchiAcceptance.INSTANCE).build());
        }
        if (acceptance instanceof CoBuchiAcceptance) {
            return Views.createView(completeAutomaton, Views.builder().acceptance(BuchiAcceptance.INSTANCE).build());
        }
        if (acceptance instanceof ParityAcceptance) {
            ParityAcceptance parityAcceptance = (ParityAcceptance)automaton.acceptance();
            return Views.createView(completeAutomaton, Views.builder().acceptance(parityAcceptance.complement()).build());
        }
        throw new UnsupportedOperationException();
    }

    public static <S> Automaton<S, ?> complete(Automaton<S, ?> automaton, S trapState) {
        Object acceptance = automaton.acceptance();
        if (acceptance instanceof AllAcceptance) {
            return new Complete(automaton, Edge.of(trapState, 0), CoBuchiAcceptance.INSTANCE);
        }
        return new Complete(automaton, Edge.of(trapState, ((OmegaAcceptance)acceptance).rejectingSet()), acceptance);
    }

    public static <S, A extends OmegaAcceptance> Automaton<Set<S>, A> createPowerSetAutomaton(Automaton<S, ?> automaton, A acceptance, boolean dropEmptySet) {
        return AutomatonFactory.create(automaton.factory(), automaton.initialStates(), acceptance, (states, valuation) -> {
            Set successors = states.stream().flatMap(x -> automaton.successors((Object)x, (BitSet)valuation).stream()).collect(Collectors.toUnmodifiableSet());
            return dropEmptySet && successors.isEmpty() ? null : Edge.of(successors);
        });
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> filter(Automaton<S, A> automaton, Set<S> states) {
        return Views.createView(automaton, Views.builder().stateFilter(states::contains).build());
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> filter(Automaton<S, A> automaton, Set<S> states, Predicate<Edge<S>> edgeFilter) {
        return Views.createView(automaton, Views.builder().edgeFilter(edgeFilter).stateFilter(states::contains).build());
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> remap(Automaton<S, A> automaton, IntUnaryOperator remappingOperator) {
        return Views.createView(automaton, Views.builder().edgeRewriter(edge -> edge.withAcceptance(remappingOperator)).build());
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> replaceInitialState(Automaton<S, A> automaton, Set<S> initialStates) {
        return Views.createView(automaton, Views.builder().initialStates(initialStates).build());
    }

    static <S, A extends OmegaAcceptance> Automaton<S, A> createView(Automaton<S, ?> automaton, ViewSettings<S, A> settings) {
        return new AutomatonView<S, A>(automaton, settings);
    }

    static <S, A extends OmegaAcceptance> ImmutableViewSettings.Builder<S, A> builder() {
        return ImmutableViewSettings.builder();
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> viewAs(Automaton<S, ?> automaton, Class<A> acceptanceClazz) {
        if (acceptanceClazz.isInstance(automaton.acceptance())) {
            return AutomatonUtil.cast(automaton, acceptanceClazz);
        }
        if (ParityAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof BuchiAcceptance));
            ImmutableViewSettings<S, ParityAcceptance> remapping = Views.builder().acceptance(new ParityAcceptance(2, ParityAcceptance.Parity.MIN_EVEN)).edgeRewriter(edge -> edge.inSet(0) ? edge : Edge.of(edge.successor(), 1)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        if (RabinAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof BuchiAcceptance));
            ImmutableViewSettings<S, RabinAcceptance> remapping = Views.builder().acceptance(RabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.of(0))).edgeRewriter(edge -> edge.withAcceptance(x -> x + 1)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        if (GeneralizedRabinAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof GeneralizedBuchiAcceptance));
            int sets = ((OmegaAcceptance)automaton.acceptance()).acceptanceSets();
            ImmutableViewSettings<S, GeneralizedRabinAcceptance> remapping = Views.builder().acceptance(GeneralizedRabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.ofGeneralized(0, sets))).edgeRewriter(edge -> edge.withAcceptance(x -> x + 1)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        if (BuchiAcceptance.class.equals(acceptanceClazz) || GeneralizedBuchiAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof AllAcceptance));
            ImmutableViewSettings<S, BuchiAcceptance> remapping = Views.builder().acceptance(BuchiAcceptance.INSTANCE).edgeRewriter(edge -> edge.withAcceptance(0)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        if (EmersonLeiAcceptance.class.equals(acceptanceClazz)) {
            Object acceptance = automaton.acceptance();
            ImmutableViewSettings<S, EmersonLeiAcceptance> remapping = Views.builder().acceptance(new EmersonLeiAcceptance(((OmegaAcceptance)acceptance).acceptanceSets(), ((OmegaAcceptance)acceptance).booleanExpression())).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        throw new UnsupportedOperationException();
    }

    public static <S> Automaton<S, NoneAcceptance> viewAsLts(Automaton<S, ?> automaton) {
        ImmutableViewSettings<S, NoneAcceptance> remapping = Views.builder().acceptance(NoneAcceptance.INSTANCE).edgeRewriter(Edge::withoutAcceptance).build();
        return Views.createView(automaton, remapping);
    }

    public static class AutomatonView<S, A extends OmegaAcceptance>
    extends AbstractImplicitAutomaton<S, A> {
        private final Automaton<S, ?> backingAutomaton;
        private final ViewSettings<S, A> settings;

        private AutomatonView(Automaton<S, ?> automaton, ViewSettings<S, A> settings) {
            super(automaton.factory(), AutomatonView.initialStates(automaton, settings), AutomatonView.acceptance(automaton, settings));
            this.backingAutomaton = automaton;
            this.settings = settings;
        }

        private static <S, A extends OmegaAcceptance> A acceptance(Automaton<S, ?> automaton, ViewSettings<S, A> settings) {
            A acceptance = settings.acceptance();
            return (A)(acceptance == null ? automaton.acceptance() : acceptance);
        }

        private static <S> Set<S> initialStates(Automaton<S, ?> automaton, ViewSettings<S, ?> settings) {
            Set<S> initialStates = settings.initialStates();
            if (initialStates != null) {
                return initialStates;
            }
            Predicate<S> stateFilter = settings.stateFilter();
            if (stateFilter == null) {
                return automaton.initialStates();
            }
            return Sets.filter(automaton.initialStates(), stateFilter::test);
        }

        private boolean stateFilter(S state) {
            Predicate<S> filter = this.settings.stateFilter();
            return filter == null || filter.test(state);
        }

        private boolean edgeFilter(Edge<S> edge) {
            Predicate<Edge<S>> filter = this.settings.edgeFilter();
            return (filter == null || filter.test(edge)) && this.stateFilter(edge.successor());
        }

        private boolean filterRequired() {
            return this.settings.stateFilter() != null || this.settings.edgeFilter() != null;
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.backingAutomaton.preferredEdgeAccess();
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            Set<Edge<S>> filteredEdges = this.filterRequired() ? Sets.filter(this.backingAutomaton.edges(state, valuation), this::edgeFilter) : this.backingAutomaton.edges(state, valuation);
            Function<Edge<S>, Edge<S>> edgeRewriter = this.settings.edgeRewriter();
            return edgeRewriter == null ? filteredEdges : Collections3.transformSet(filteredEdges, edgeRewriter);
        }

        @Override
        public Set<Edge<S>> edges(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            Set<Edge<S>> filteredEdges = this.filterRequired() ? Sets.filter(this.backingAutomaton.edges(state), this::edgeFilter) : this.backingAutomaton.edges(state);
            Function<Edge<S>, Edge<S>> edgeRewriter = this.settings.edgeRewriter();
            return edgeRewriter == null ? filteredEdges : Collections3.transformSet(filteredEdges, edgeRewriter);
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            Map<Edge<S>, ValuationSet> filteredEdges = this.filterRequired() ? Maps.filterKeys(this.backingAutomaton.edgeMap(state), this::edgeFilter) : this.backingAutomaton.edgeMap(state);
            Function<Edge<S>, Edge<S>> edgeRewriter = this.settings.edgeRewriter();
            return edgeRewriter == null ? filteredEdges : Collections3.transformMap(filteredEdges, edgeRewriter);
        }

        @Override
        public ValuationTree<Edge<S>> edgeTree(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            ValuationTree<Edge<S>> edges = this.backingAutomaton.edgeTree(state);
            Function edgeRewriter = this.settings.edgeRewriter();
            Function<Set, Set> mapper = this.filterRequired() ? (edgeRewriter == null ? x -> Sets.filter((Set)x, this::edgeFilter) : x -> Collections3.transformSet(Sets.filter((Set)x, this::edgeFilter), edgeRewriter)) : (edgeRewriter == null ? null : x -> Collections3.transformSet(x, edgeRewriter));
            return mapper == null ? edges : edges.map(mapper);
        }

        @Override
        public boolean is(Automaton.Property property) {
            Boolean value = this.settings.properties().get((Object)property);
            return value == null ? super.is(property) : value.booleanValue();
        }
    }

    @Value.Immutable
    static abstract class ViewSettings<S, A extends OmegaAcceptance> {
        ViewSettings() {
        }

        @Nullable
        abstract A acceptance();

        @Nullable
        abstract Set<S> initialStates();

        @Nullable
        abstract Predicate<S> stateFilter();

        @Nullable
        abstract Predicate<Edge<S>> edgeFilter();

        @Nullable
        abstract Function<Edge<S>, Edge<S>> edgeRewriter();

        @Value.Default
        Map<Automaton.Property, Boolean> properties() {
            return Map.of();
        }
    }

    static class Complete<S, A extends OmegaAcceptance, B extends OmegaAcceptance>
    implements Automaton<S, B> {
        private final Edge<S> sinkEdge;
        private final Set<Edge<S>> sinkEdgeSet;
        private final Automaton<S, A> automaton;
        private final S sink;
        private final Set<S> sinkSet;
        private final B acceptance;
        @Nullable
        private Map<S, ValuationSet> incompleteStates;

        Complete(Automaton<S, A> automaton, Edge<S> sinkEdge, B acceptance) {
            this.automaton = automaton;
            this.sink = sinkEdge.successor();
            this.sinkSet = Set.of(this.sink);
            this.sinkEdge = sinkEdge;
            this.sinkEdgeSet = Set.of(sinkEdge);
            this.acceptance = acceptance;
        }

        @Override
        public B acceptance() {
            return this.acceptance;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.automaton.factory();
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.automaton.preferredEdgeAccess();
        }

        @Override
        public Set<S> initialStates() {
            return this.automaton.initialStates();
        }

        @Override
        public Set<S> states() {
            if (this.incompleteStates == null) {
                this.incompleteStates = AutomatonUtil.getIncompleteStates(this.automaton);
            }
            if (this.incompleteStates.isEmpty()) {
                return this.automaton.states();
            }
            return Sets.union(this.automaton.states(), this.sinkSet);
        }

        @Override
        public Set<S> successors(S state) {
            if (this.sink.equals(state)) {
                return this.sinkSet;
            }
            if (this.incompleteStates != null && this.incompleteStates.containsKey(state)) {
                return Sets.union(this.automaton.states(), this.sinkSet);
            }
            return Edges.successors(this.edgeMap(state).keySet());
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            if (this.sink.equals(state)) {
                return this.sinkEdgeSet;
            }
            Set<Edge<S>> edges = this.automaton.edges(state, valuation);
            return edges.isEmpty() ? this.sinkEdgeSet : edges;
        }

        @Override
        public Set<Edge<S>> edges(S state) {
            if (this.sink.equals(state)) {
                return this.sinkEdgeSet;
            }
            if (this.incompleteStates != null && this.incompleteStates.containsKey(state)) {
                return Sets.union(this.automaton.edges(state), this.sinkEdgeSet);
            }
            return this.preferredEdgeAccess().get(0) == Automaton.PreferredEdgeAccess.EDGE_TREE ? this.edgeTree(state).values() : this.edgeMap(state).keySet();
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            ValuationSet valuationSet;
            ValuationSetFactory factory = this.automaton.factory();
            if (this.sink.equals(state)) {
                return Map.of(this.sinkEdge, factory.universe());
            }
            if (this.incompleteStates != null && !this.incompleteStates.containsKey(state)) {
                return this.automaton.edgeMap(state);
            }
            HashMap<Edge<S>, ValuationSet> edges = new HashMap<Edge<S>, ValuationSet>(this.automaton.edgeMap(state));
            ValuationSet valuationSet2 = valuationSet = this.incompleteStates == null ? factory.union(edges.values()).complement() : this.incompleteStates.get(state);
            if (!valuationSet.isEmpty()) {
                edges.put(this.sinkEdge, valuationSet);
            }
            return edges;
        }

        @Override
        public ValuationTree<Edge<S>> edgeTree(S state) {
            if (this.sink.equals(state)) {
                return ValuationTree.of(this.sinkEdgeSet);
            }
            ValuationTree<Edge<S>> valuationTree = this.automaton.edgeTree(state);
            if (this.incompleteStates != null && !this.incompleteStates.containsKey(state)) {
                return valuationTree;
            }
            return valuationTree.map(x -> x.isEmpty() ? this.sinkEdgeSet : x);
        }

        @Override
        public boolean is(Automaton.Property property) {
            return property == Automaton.Property.COMPLETE || this.automaton.is(property);
        }
    }
}

